/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.common;

import java.util.ArrayList;
import java.util.Iterator;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.CardParseException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.IPolicy;
import org.eclipse.higgins.icard.common.io.XMLElementFormat;
import org.eclipse.higgins.icard.common.utils.CardContext;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.io.IElementFormat;

public abstract class BasicCardProvider
implements ICardProvider {
    public Iterator getICardsByFormat(CallbackHandler authHandler, IElementFormat format) throws CardException {
        ArrayList cards = new ArrayList();
        Iterator itr = this.getICards(authHandler);
        while (itr.hasNext()) {
            ICard card;
            Object o = itr.next();
            if (!(o instanceof ICard) || !(card = (ICard)o).isFormatSupported(format)) continue;
            cards.add(o);
        }
        return cards.iterator();
    }

    public Iterator getICardsByPolicy(CallbackHandler authHandler, IPolicy policy) throws CardException {
        ArrayList<ICard> cards = new ArrayList<ICard>();
        Iterator itr = this.getICards(authHandler);
        while (itr.hasNext()) {
            ICard card = (ICard)itr.next();
            if (policy == null) {
                cards.add(card);
                continue;
            }
            if (!policy.isSatisfiedBy(card)) continue;
            cards.add(card);
        }
        return cards.iterator();
    }

    public IElement[] exportICards(CallbackHandler authHandler, IElementFormat format, CUID[] cards) throws CardException {
        ArrayList<IElement> res = new ArrayList<IElement>();
        for (int i = 0; i < cards.length; ++i) {
            ICard card = this.getICardByCUID(authHandler, cards[i]);
            if (card == null) {
                throw new CardException("Can't find card with CUID=\"" + cards[i] + "\"");
            }
            if (!card.isFormatSupported(format)) {
                throw new CardException("The card with CUID=\"" + cards[i] + "\" doesn't support required export format.");
            }
            IElement e = card.toElement(format);
            if (e == null) {
                throw new CardException("The card with CUID=\"" + cards[i] + "\" can't be converted to the required export format.");
            }
            res.add(e);
        }
        return res.toArray(new IElement[res.size()]);
    }

    public ICard persistCard(CallbackHandler authHandler, ICard card) throws CardException {
        if (card == null) {
            throw new CardException("Parameter \"card\" should not be null.");
        }
        XMLElementFormat elementDescriptor = new XMLElementFormat(new QName[]{CardContext.QN_IC_ROAMING_INFORMATION_CARD});
        IElement iElm = card.toElement((IElementFormat)elementDescriptor);
        if (this.canImportICard(authHandler, iElm)) {
            return this.importICard(authHandler, iElm);
        }
        return null;
    }

    public boolean canImportICard(CallbackHandler authHandler, IElement element) throws CardParseException {
        ICard c = this.parseCardElement(authHandler, element);
        return c != null;
    }
}

