/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.common;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IClaimType;
import org.eclipse.higgins.icard.ISimpleClaim;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.icard.common.utils.CardContext;
import org.eclipse.higgins.icard.io.IElementFormat;
import org.eclipse.higgins.icard.io.IXMLElementFormat;

public abstract class Card
implements ICard {
    private static Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$common$Card == null ? (class$org$eclipse$higgins$icard$common$Card = Card.class$("org.eclipse.higgins.icard.common.Card")) : class$org$eclipse$higgins$icard$common$Card));
    protected String name_ = null;
    protected URI id_ = null;
    protected String version_ = null;
    protected String issuer_ = null;
    protected byte[] issuerID_ = null;
    protected String issuerName_ = null;
    protected byte[] image_ = null;
    protected String imageMimeType_ = null;
    protected Date timeIssued_ = null;
    protected Date timeExpires_ = null;
    protected List claimTypes_ = null;
    protected List supportedTokenTypes_ = null;
    protected String language_ = null;
    protected ICardProvider provider_ = null;
    protected boolean isSelfIssued_ = false;
    protected Date timeLastUpdated_ = null;
    protected String description_ = null;
    protected HashMap claimValues_ = null;
    protected HashMap claimValuesByLocalName_ = null;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$common$Card;

    public String getName() {
        return this.name_ != null ? this.name_ : "";
    }

    public void setName(String name) throws CardException {
        this.name_ = name;
    }

    public String getID() {
        return this.id_ != null ? this.id_.toString() : "";
    }

    public void setID(URI id) {
        this.id_ = id;
    }

    public String getIssuerName() {
        if (this.issuerName_ != null) {
            return this.issuerName_;
        }
        try {
            URI uri = new URI(this.issuer_);
            return uri.getHost().toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setIssuerName(String issuerName) throws CardException {
        this.issuerName_ = issuerName;
    }

    public String getIssuer() {
        return this.issuer_ != null ? this.issuer_ : "";
    }

    public void setIssuer(String issuer) {
        this.issuer_ = issuer;
    }

    public byte[] getImage() {
        return this.image_;
    }

    public void setImage(byte[] image) {
        this.image_ = image;
    }

    public String getImageType() {
        return this.imageMimeType_;
    }

    public void setImageType(String imageMimeType) {
        this.imageMimeType_ = imageMimeType;
    }

    public Date getTimeIssued() {
        return this.timeIssued_;
    }

    public void setTimeIssued(Date timeIssued) throws CardException {
        this.timeIssued_ = timeIssued;
    }

    public Date getTimeExpires() {
        return this.timeExpires_;
    }

    public void setTimeExpires(Date timeExpires) throws CardException {
        this.timeExpires_ = timeExpires;
    }

    public Iterator getSupportedClaimTypes() {
        if (this.claimTypes_ != null) {
            return this.claimTypes_.iterator();
        }
        return null;
    }

    public void setSupportedClaimTypes(List supportedClaimTypes) {
        this.claimTypes_ = supportedClaimTypes;
    }

    public List getSupportedClaimTypesUris() {
        ArrayList<String> res = new ArrayList<String>();
        if (this.claimTypes_ != null) {
            for (int i = 0; i < this.claimTypes_.size(); ++i) {
                IClaimType type = (IClaimType)this.claimTypes_.get(i);
                res.add(type.getType().toString());
            }
        }
        return Collections.unmodifiableList(res);
    }

    public String getVersion() {
        return this.version_;
    }

    public void setVersion(String version) {
        this.version_ = version;
    }

    public List getSupportedTokenTypes() {
        return this.supportedTokenTypes_;
    }

    public void setSupportedTokenTypes(List supportedTokenTypes) {
        this.supportedTokenTypes_ = supportedTokenTypes;
    }

    public ICardProvider getProvider() {
        return this.provider_;
    }

    public Date getTimeLastUpdated() {
        return this.timeLastUpdated_;
    }

    public void setTimeLastUpdated(Date timeLastUpdated) {
        this.timeLastUpdated_ = timeLastUpdated;
    }

    public boolean isSelfIssued() {
        return this.isSelfIssued_;
    }

    public void setSelfIssued(boolean isSelfIssued) {
        this.isSelfIssued_ = isSelfIssued;
    }

    public CUID getCUID() {
        String providerId = this.provider_ != null ? this.getProvider().getID() : "";
        return new CUID(providerId, this.issuer_, this.getID());
    }

    public String getDescription() {
        return this.description_;
    }

    public void setDescription(String description) {
        this.description_ = description;
    }

    public boolean isClaimsRetrieved() {
        return this.claimValues_ != null;
    }

    public void setClaims(List claims) throws InvalidTypeException {
        if (this.claimValues_ == null) {
            this.claimValues_ = new LinkedHashMap();
            this.claimValuesByLocalName_ = new HashMap();
        }
        for (int i = 0; i < claims.size(); ++i) {
            Object c = (IClaim)claims.get(i);
            try {
                if (c instanceof ISimpleClaim) {
                    ISimpleClaim sc = (ISimpleClaim)c;
                    ClaimValue cv = new ClaimValue(sc.getType(), sc.getValues(), (ICard)this);
                    c = cv;
                }
            }
            catch (Throwable e) {
                log.error((Object)e, e);
            }
            this.claimValues_.put(c.getType().getType(), c);
            this.claimValuesByLocalName_.put(c.getTypeLocalName(), c);
        }
    }

    public boolean isFormatSupported(IElementFormat format) {
        if (format.getFormatID() == "XML") {
            IXMLElementFormat xmlf = (IXMLElementFormat)format;
            QName[] names = xmlf.getElementNames();
            for (int i = 0; i < names.length; ++i) {
                if (!names[i].equals(CardContext.QN_IC_ROAMING_INFORMATION_CARD)) continue;
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

