/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CardException;

public class DateConvertor {
    private static Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$common$utils$DateConvertor == null ? (class$org$eclipse$higgins$icard$common$utils$DateConvertor = DateConvertor.class$("org.eclipse.higgins.icard.common.utils.DateConvertor")) : class$org$eclipse$higgins$icard$common$utils$DateConvertor));
    private static SimpleDateFormat zeroTZFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static SimpleDateFormat rfc822TZFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static SimpleDateFormat rfc822MsTZFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S'Z'");
    private static final String COMPLETE_DATE_HOURS_MINUTES_SECS_MSECS_Z = "yyyy-MM-dd'T'HH':'mm':'ss'.'S'Z'";
    static /* synthetic */ Class class$org$eclipse$higgins$icard$common$utils$DateConvertor;

    private static Date parseAsZeroTimeZoneFormat(String date) {
        Date res = null;
        try {
            if (date.matches(".*Z$")) {
                res = zeroTZFormat.parse(date);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return res;
    }

    private static Date parseAsZeroTimeZoneMSFormat(String date) {
        Date res = null;
        try {
            if (date.matches(".*Z$")) {
                res = rfc822MsTZFormat.parse(date);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return res;
    }

    private static Date parseAsRFC822ZoneFormat(String date) {
        Date res = null;
        try {
            int indx = date.lastIndexOf(":");
            if (indx != -1) {
                String dt = date.substring(0, indx) + date.substring(indx + 1, date.length());
                res = rfc822TZFormat.parse(dt);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return res;
    }

    public static Date parse(String date) throws CardException {
        if (date != null) {
            String dateTrim = date.trim();
            Date dt = null;
            dt = DateConvertor.getDateFromIso8601(date);
            if (dt == null) {
                dt = DateConvertor.parseAsZeroTimeZoneFormat(dateTrim);
            }
            if (dt == null) {
                dt = DateConvertor.parseAsZeroTimeZoneMSFormat(dateTrim);
            }
            if (dt == null) {
                dt = DateConvertor.parseAsRFC822ZoneFormat(dateTrim);
            }
            if (dt == null) {
                throw new CardException("Could't parse date : " + date);
            }
            return dt;
        }
        return null;
    }

    private static int parseToInt(String token, int def) {
        if (token == null) {
            return def;
        }
        try {
            return Integer.parseInt(token, 10);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return def;
        }
    }

    private static boolean isAlphaChar(char c) {
        return c > '@' && c < '[';
    }

    private static int parseOutMillisFromTimeZone(String timeZone) {
        char c;
        if (timeZone == null || !timeZone.startsWith(".") || timeZone.length() < 4) {
            return 0;
        }
        StringBuffer millis = new StringBuffer();
        for (int i = 1; i < timeZone.length() && (c = timeZone.charAt(i)) != '+' && c != '-' && i <= 4 && !DateConvertor.isAlphaChar(c); ++i) {
            millis.append(c);
        }
        int fs = DateConvertor.parseToInt(millis.toString(), 0);
        int numDecimals = millis.length();
        int ms = 0;
        if (numDecimals > 0) {
            double x = Math.pow(10.0, numDecimals);
            float faction = (float)fs / (float)x;
            ms = (int)(1000.0f * faction);
        }
        return ms;
    }

    public static Date getDateFromIso8601(String iso8601) {
        Date result = null;
        if (iso8601 == null || iso8601.length() < 4) {
            return result;
        }
        int len = iso8601.length();
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int millis = 0;
        String timeZone = null;
        if (len == 4) {
            year = DateConvertor.parseToInt(iso8601.substring(0, 4), 0);
        } else if (len == 7) {
            year = DateConvertor.parseToInt(iso8601.substring(0, 4), 0);
            month = DateConvertor.parseToInt(iso8601.substring(5, 7), 0);
        } else if (len == 10) {
            year = DateConvertor.parseToInt(iso8601.substring(0, 4), 0);
            month = DateConvertor.parseToInt(iso8601.substring(5, 7), 0);
            day = DateConvertor.parseToInt(iso8601.substring(8, 10), 0);
        } else if (len > 15) {
            year = DateConvertor.parseToInt(iso8601.substring(0, 4), 0);
            month = DateConvertor.parseToInt(iso8601.substring(5, 7), 0);
            day = DateConvertor.parseToInt(iso8601.substring(8, 10), 0);
            hour = DateConvertor.parseToInt(iso8601.substring(11, 13), 0);
            minute = DateConvertor.parseToInt(iso8601.substring(14, 16), 0);
            if (iso8601.charAt(16) == ':') {
                second = DateConvertor.parseToInt(iso8601.substring(17, 19), 0);
                timeZone = iso8601.substring(19, len);
            } else {
                timeZone = iso8601.substring(16, len);
            }
            millis = DateConvertor.parseOutMillisFromTimeZone(timeZone);
            timeZone = DateConvertor.trimTimeZone(timeZone);
        }
        month = Math.max(0, month - 1);
        day = Math.max(1, day);
        if (timeZone == null) {
            int offset = TimeZone.getDefault().getRawOffset();
            timeZone = DateConvertor.convertOffSetToTimeZone(offset);
        } else {
            timeZone = timeZone.equals("Z") ? "GMT+00:00" : "GMT" + timeZone;
        }
        return DateConvertor.makeDate(year, month, day, hour, minute, second, millis, timeZone);
    }

    private static String padder(int value, int pads) {
        String v = Integer.toString(value);
        int numZeros = pads - v.length();
        StringBuffer result = new StringBuffer();
        if (numZeros > 0) {
            for (int i = 0; i < numZeros; ++i) {
                result.append("0");
            }
        }
        result.append(v);
        return result.toString();
    }

    private static String convertOffSetToTimeZone(int offset) {
        StringBuffer result = new StringBuffer();
        result.append("GMT");
        boolean isPositive = true;
        if (offset < 0) {
            isPositive = false;
        }
        if (isPositive) {
            result.append("+");
        } else {
            result.append("-");
            offset *= -1;
        }
        int hour = offset / 3600000;
        int minutes = offset / 216000000;
        result.append(DateConvertor.padder(hour, 2));
        result.append(":");
        result.append(DateConvertor.padder(minutes, 2));
        return result.toString();
    }

    private static String trimTimeZone(String timeZone) {
        if (timeZone == null) {
            return null;
        }
        int beginIndex = 0;
        int len = timeZone.length();
        for (int i = 0; i < timeZone.length(); ++i) {
            beginIndex = i;
            char c = timeZone.charAt(i);
            if (c == '+' || c == '-' || i > 4 || DateConvertor.isAlphaChar(c)) break;
        }
        return timeZone.substring(beginIndex, len);
    }

    public static Date makeDate(int year, int month, int day, int hour, int minute, int sec, int msec, String timeZone) {
        Calendar cal;
        if (timeZone != null) {
            TimeZone tzone = TimeZone.getTimeZone(timeZone);
            cal = Calendar.getInstance(tzone);
        } else {
            cal = Calendar.getInstance();
        }
        cal.set(year, month, day, hour, minute, sec);
        cal.set(14, msec);
        return cal.getTime();
    }

    public static String getIso8601Date(Date date) {
        if (date == null) {
            date = new Date();
        }
        SimpleDateFormat sdf = new SimpleDateFormat(COMPLETE_DATE_HOURS_MINUTES_SECS_MSECS_Z);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sdf.format(date);
    }

    public static String format(Date date) {
        if (date == null) {
            return "";
        }
        return DateConvertor.getIso8601Date(date);
    }

    public static String formatMS(Date date) {
        if (date == null) {
            return "";
        }
        return rfc822MsTZFormat.format(date);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

