/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.common.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.AuthenticationRequiredException;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IPwmCard;
import org.eclipse.higgins.icard.ISimpleClaim;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.common.ClaimType;

public class PwmCardClaimsHelper {
    private static Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$common$utils$PwmCardClaimsHelper == null ? (class$org$eclipse$higgins$icard$common$utils$PwmCardClaimsHelper = PwmCardClaimsHelper.class$("org.eclipse.higgins.icard.common.utils.PwmCardClaimsHelper")) : class$org$eclipse$higgins$icard$common$utils$PwmCardClaimsHelper));
    public static final String PWM_ISSUER_TYPE = "http://eclipse.org/higgins/2008/passwordmanaged";
    public static final String CLAIM_TYPE_SITE = "http://eclipse.org/higgins/2008/site";
    public static final String CLAIM_TYPE_USERNAME = "http://eclipse.org/higgins/2008/username";
    public static final String CLAIM_TYPE_PASSWORD = "http://eclipse.org/higgins/2008/password";
    public static final String CLAIM_TYPE_FORM_ID = "http://eclipse.org/higgins/2008/formId";
    public static final String CLAIM_TYPE_FORM_NAME = "http://eclipse.org/higgins/2008/formName";
    public static final String CLAIM_TYPE_FORM_ACTION = "http://eclipse.org/higgins/2008/formAction";
    private static final HashMap SUPPORTED_CLAIM_TYPES_HASH = new HashMap();
    private static final ArrayList SUPPORTED_CLAIM_TYPE_URIS = new ArrayList();
    static /* synthetic */ Class class$org$eclipse$higgins$icard$common$utils$PwmCardClaimsHelper;

    public static ArrayList getSupportedClaimTypes() {
        return new ArrayList(SUPPORTED_CLAIM_TYPES_HASH.values());
    }

    public static ArrayList getSupportedClaimTypeUris() {
        return new ArrayList(SUPPORTED_CLAIM_TYPE_URIS);
    }

    public static boolean isClaimSupported(String claimType) {
        if (claimType == null) {
            return false;
        }
        return SUPPORTED_CLAIM_TYPES_HASH.containsKey(claimType);
    }

    public static ClaimType getClaimType(String claimType) {
        if (SUPPORTED_CLAIM_TYPES_HASH.containsKey(claimType)) {
            return (ClaimType)SUPPORTED_CLAIM_TYPES_HASH.get(claimType);
        }
        return null;
    }

    public static HashMap getSupportedClaimTypesHash() {
        return new HashMap(SUPPORTED_CLAIM_TYPES_HASH);
    }

    public static String getSimpleClaimValue(IPwmCard card, String claimType) throws AuthenticationRequiredException, InvalidTypeException, CardException {
        ISimpleClaim sc;
        List values;
        IClaim cv = card.getClaim(claimType);
        if (cv instanceof ISimpleClaim && (values = (sc = (ISimpleClaim)cv).getValues()).size() > 0) {
            return (String)values.get(0);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SUPPORTED_CLAIM_TYPE_URIS.add(CLAIM_TYPE_SITE);
        SUPPORTED_CLAIM_TYPE_URIS.add(CLAIM_TYPE_USERNAME);
        SUPPORTED_CLAIM_TYPE_URIS.add(CLAIM_TYPE_PASSWORD);
        SUPPORTED_CLAIM_TYPE_URIS.add(CLAIM_TYPE_FORM_ID);
        SUPPORTED_CLAIM_TYPE_URIS.add(CLAIM_TYPE_FORM_NAME);
        SUPPORTED_CLAIM_TYPE_URIS.add(CLAIM_TYPE_FORM_ACTION);
        try {
            SUPPORTED_CLAIM_TYPES_HASH.put(CLAIM_TYPE_SITE, new ClaimType(CLAIM_TYPE_SITE, "Site", "Site"));
            SUPPORTED_CLAIM_TYPES_HASH.put(CLAIM_TYPE_USERNAME, new ClaimType(CLAIM_TYPE_USERNAME, "User name", "User name"));
            SUPPORTED_CLAIM_TYPES_HASH.put(CLAIM_TYPE_PASSWORD, new ClaimType(CLAIM_TYPE_PASSWORD, "User password", "User password"));
            SUPPORTED_CLAIM_TYPES_HASH.put(CLAIM_TYPE_FORM_ID, new ClaimType(CLAIM_TYPE_FORM_ID, "Form Id", "Form Id", false, false));
            SUPPORTED_CLAIM_TYPES_HASH.put(CLAIM_TYPE_FORM_NAME, new ClaimType(CLAIM_TYPE_FORM_NAME, "Form name", "Form name", false, false));
            SUPPORTED_CLAIM_TYPES_HASH.put(CLAIM_TYPE_FORM_ACTION, new ClaimType(CLAIM_TYPE_FORM_ACTION, "Form action", "Form action", false, false));
        }
        catch (CardException e) {
            log.error((Object)e, (Throwable)e);
        }
    }
}

