/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
*     Sergey Lyakhov - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.common;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.higgins.icard.ITemplateContainer;
import org.eclipse.higgins.icard.ITemplateElement;
import org.eclipse.higgins.icard.ITemplateValue;

/**
 * 
 * 
 */
public class TemplateContainer extends TemplateElement implements ITemplateContainer {
	protected ArrayList elements_ = new ArrayList();

	/**
	 * @param id
	 * @param description
	 * @param displayName
	 */
	public TemplateContainer(String id, String description, String displayName) {
		id_ = id;
		description_ = description;
		displayName_ = displayName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.ITemplateContainer#addTemplateElement(org.eclipse.higgins.icard.ITemplateElement)
	 */
	public void addTemplateElement(ITemplateElement element) {
		if (element != null && elements_.contains(element) == false)
			elements_.add(element);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.ITemplateContainer#removeTemplateElement(org.eclipse.higgins.icard.ITemplateElement)
	 */
	public void removeTemplateElement(ITemplateElement element) {
		if (element != null && elements_.contains(element))
			elements_.remove(element);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.ITemplateContainer#getTemplateElementByID(java.lang.String)
	 */
	public ITemplateElement getTemplateElementByID(String id) {
		if (id == null)
			return null;
		int size = elements_.size();
		for (int i = 0; i < size; i++) {
			ITemplateElement element = (ITemplateElement) elements_.get(i);
			if (id.equals(element.getID()))
				return element;
		}
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.ITemplateContainer#getTemplateElements()
	 */
	public Iterator getTemplateElements() {
		return elements_.iterator();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.ITemplateContainer#getTemplateValueByID(java.lang.String)
	 */
	public ITemplateValue getTemplateValueByID(String id) {
		ITemplateElement elm = getTemplateElementByID(id);
		if (elm == null)
			return null;
		if (elm instanceof ITemplateValue)
			return (ITemplateValue) elm;
		return null;
	}

}
