/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
*     Sergey Lyakhov - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.common;

import org.eclipse.higgins.icard.ITemplateElement;

public abstract class TemplateElement implements ITemplateElement {

	protected String description_;

	protected String displayName_;

	protected String id_;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.ITemplateElement#getDescription()
	 */
	public String getDescription() {
		return description_;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.ITemplateElement#getDisplayName()
	 */
	public String getDisplayName() {
		return displayName_;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.ITemplateElement#getID()
	 */
	public String getID() {
		return id_;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.ITemplateElement#setDescription(java.lang.String)
	 */
	public void setDescription(String description) {
		description_ = description;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.ITemplateElement#setDisplayName(java.lang.String)
	 */
	public void setDisplayName(String displayName) {
		displayName_ = displayName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.ITemplateElement#setID(java.lang.String)
	 */
	public void setID(String id) {
		id_ = id;
	}

}
