/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
*     Sergey Lyakhov - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.common;

import java.util.List;

import org.eclipse.higgins.icard.ITemplateValue;
import org.eclipse.higgins.icard.IUIDescriptor;

public class TemplateValue extends TemplateElement implements ITemplateValue {
	protected String value_;

	protected boolean isValueRequired_ = false;
	
	protected IUIDescriptor descriptor_;

	/**
	 * @param id
	 * @param defaultValue
	 * @param regExpPattern
	 * @param description
	 * @param displayName
	 * @param isValueRequired
	 * @return
	 */
	public static TemplateValue createTextFieldTemplate(String id, String defaultValue, String regExpPattern, String description, String displayName,
			String inputMask, boolean isValueRequired) {
		TemplateValue newValue = new TemplateValue();
		newValue.setID(id);
		newValue.setDescription(description);
		newValue.setDisplayName(displayName);
		newValue.setIsValueRequired(isValueRequired);
		newValue.setValue(defaultValue);
		
		newValue.setUIDescriptor(UIDescriptor.createTextFieldDescriptor(regExpPattern, inputMask));

		return newValue;
	}

	/**
	 * @param id
	 * @param defaultValue
	 * @param regExpPattern
	 * @param description
	 * @param displayName
	 * @param isValueRequired
	 * @return
	 */
	public static TemplateValue createTextAreaTemplate(String id, String defaultValue, String regExpPattern, String description, String displayName,
			boolean isValueRequired) {
		TemplateValue newValue = new TemplateValue();
		newValue.setID(id);
		newValue.setValue(defaultValue);
		newValue.setDescription(description);
		newValue.setDisplayName(displayName);
		newValue.setIsValueRequired(isValueRequired);
		
		newValue.setUIDescriptor(UIDescriptor.createTextAreaDescriptor(regExpPattern));
		
		return newValue;
	}

	/**
	 * @param id
	 * @param defaultValue
	 * @param description
	 * @param displayName
	 * @param isValueRequired
	 * @return
	 */
	public static TemplateValue createFileTemplate(String id, String defaultValue, String description, String displayName, boolean isValueRequired) {
		TemplateValue newValue = new TemplateValue();
		newValue.setID(id);
		newValue.setValue(defaultValue);
		newValue.setDescription(description);
		newValue.setDisplayName(displayName);
		newValue.setIsValueRequired(isValueRequired);
		
		newValue.setUIDescriptor(UIDescriptor.createFileDescriptor());

		return newValue;
	}

	/**
	 * @param id
	 * @param defaultValue
	 * @param optionalValues
	 * @param description
	 * @param displayName
	 * @param isValueRequired
	 * @return
	 */
	public static TemplateValue createCheckBoxTemplate(String id, String defaultValue, List optionalValues, String description, String displayName,
			boolean isValueRequired) {
		TemplateValue newValue = new TemplateValue();
		newValue.setID(id);
		newValue.setValue(defaultValue);
		newValue.setDescription(description);
		newValue.setDisplayName(displayName);
		newValue.setIsValueRequired(isValueRequired);
		
		newValue.setUIDescriptor(UIDescriptor.createCheckBoxDescriptor(optionalValues));

		return newValue;
	}

	/**
	 * @param id
	 * @param defaultValue
	 * @param optionalValues
	 * @param description
	 * @param displayName
	 * @param isValueRequired
	 * @return
	 */
	public static TemplateValue createComboBoxTemplate(String id, String defaultValue, List optionalValues, String description, String displayName,
			boolean isValueRequired) {
		TemplateValue newValue = new TemplateValue();
		newValue.setID(id);
		newValue.setValue(defaultValue);
		newValue.setDescription(description);
		newValue.setDisplayName(displayName);
		newValue.setIsValueRequired(isValueRequired);

		newValue.setUIDescriptor(UIDescriptor.createComboBoxDescriptor(optionalValues));
		
		return newValue;
	}

	public static TemplateValue createDateTimeTemplate(String id, String defaultValue, String regExpPattern, String description, String displayName,
			String inputMask, boolean isValueRequired) {
		TemplateValue newValue = new TemplateValue();
		newValue.setID(id);
		newValue.setDescription(description);
		newValue.setDisplayName(displayName);
		newValue.setIsValueRequired(isValueRequired);
		newValue.setValue(defaultValue);
		newValue.setUIDescriptor(UIDescriptor.createDateTimeDescriptor(inputMask, regExpPattern));
		return newValue;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.ITemplateValue#getValue()
	 */
	public String getValue() {
		return value_;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.ITemplateValue#setValue(java.lang.String)
	 */
	public void setValue(String value) {
		value_ = value;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.ITemplateValue#isValueRequired()
	 */
	public boolean isValueRequired() {
		return isValueRequired_;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.ITemplateValue#setIsValueRequired(boolean)
	 */
	public void setIsValueRequired(boolean isValueRequired) {
		isValueRequired_ = isValueRequired;
	}

	public IUIDescriptor getUIDescriptor() {
		return descriptor_;
	}

	public void setUIDescriptor(IUIDescriptor descriptor) {
		this.descriptor_ = descriptor;
	}

}
