/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.common;

import java.util.List;

import org.eclipse.higgins.icard.IUIDescriptor;

public class UIDescriptor implements IUIDescriptor {
	protected int valueType_;

	protected List optionalValues_;

	protected String pattern_;

	protected String inputMask_;

	public static UIDescriptor createTextFieldDescriptor(String regExpPattern, String inputMask) {
		UIDescriptor newValue = new UIDescriptor();
		newValue.valueType_ = IUIDescriptor.TYPE_TEXTFILED;
		newValue.setPattern(regExpPattern);
		newValue.setInputMask(inputMask);
		return newValue;
	}

	public static UIDescriptor createTextAreaDescriptor(String regExpPattern) {
		UIDescriptor newValue = new UIDescriptor();
		newValue.valueType_ = IUIDescriptor.TYPE_TEXTAREA;
		newValue.setPattern(regExpPattern);
		return newValue;
	}

	public static UIDescriptor createFileDescriptor() {
		UIDescriptor newValue = new UIDescriptor();
		newValue.valueType_ = IUIDescriptor.TYPE_FILE;
		return newValue;
	}

	public static UIDescriptor createCheckBoxDescriptor(List optionalValues) {
		UIDescriptor newValue = new UIDescriptor();
		newValue.valueType_ = IUIDescriptor.TYPE_CHECKBOX;
		newValue.setOptionalValues(optionalValues);
		return newValue;
	}

	public static UIDescriptor createComboBoxDescriptor(List optionalValues) {
		UIDescriptor newValue = new UIDescriptor();
		newValue.valueType_ = IUIDescriptor.TYPE_COMBOBOX;
		newValue.setOptionalValues(optionalValues);
		return newValue;
	}

	public static UIDescriptor createDateTimeDescriptor(String inputMask, String pattern) {
		UIDescriptor newValue = new UIDescriptor();
		newValue.valueType_ = IUIDescriptor.TYPE_DATETIME;
		newValue.setPattern(pattern);
		newValue.setInputMask(inputMask);
		return newValue;
	}

	public int getType() {
		return valueType_;
	}

	public List getOptionalValues() {
		return optionalValues_;
	}

	public String getPattern() {
		return pattern_;
	}

	public void setOptionalValues(List values) {
		optionalValues_ = values;
	}

	public void setPattern(String pattern) {
		pattern_ = pattern;
	}

	public String getInputMask() {
		return inputMask_;
	}

	public void setInputMask(String inputMask) {
		inputMask_ = inputMask;
	}

}
