/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.common.auth;

import javax.security.auth.callback.Callback;

import org.eclipse.higgins.icard.auth.IPinCodeCredential;
import org.eclipse.higgins.icard.common.auth.callback.PinCodeCallback;

public class PinCodeCredential implements IPinCodeCredential {

	protected Callback[] callbacks = new Callback[1];
	private PinCodeCallback pc;
	
	public PinCodeCredential() {
		pc = new PinCodeCallback("PIN code");
		callbacks[0] = pc;
	}
	
	public byte[] getPinCode() {
		return pc.getPin();
	}

	public void setPinCode(byte[] pin) {
		pc.setPin(pin);
	}

	public Callback[] getCallbacks() {
		return callbacks;
	}

}
