/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.common.auth;

import java.net.URI;
import java.security.cert.X509Certificate;

import javax.security.auth.callback.Callback;

import org.eclipse.higgins.icard.auth.IPinCodeCredential;
import org.eclipse.higgins.icard.auth.ISelfIssuedCredential;
import org.eclipse.higgins.icard.auth.ITSSelfIssuedCredential;
import org.eclipse.higgins.icard.auth.ITokenServiceCredential;

public class TSSelfIssuedCredential implements ITSSelfIssuedCredential {
	protected ITokenServiceCredential tsc;
	protected ISelfIssuedCredential sic;
	
	public TSSelfIssuedCredential(ITokenServiceCredential tsc, ISelfIssuedCredential sic) {
		this.tsc = tsc;
		this.sic = sic;
	}

	public URI getAddress() {
		return tsc.getAddress();
	}

	public X509Certificate getCertificate() {
		return tsc.getCertificate();
	}

	public URI getMetadataAddress() {
		return tsc.getMetadataAddress();
	}

	public Callback[] getCallbacks() {
		Callback[] cts = tsc.getCallbacks();
		Callback[] csi = sic.getCallbacks();
		Callback[] c = new Callback[cts.length + csi.length];
		for (int i = 0; i < c.length; i++) {
			if (i < cts.length) {
				c[i] = cts[i];
			} else {
				c[i] = csi[i - cts.length];
			}
		}
		return c;
	}

	public String getPPID() {
		return sic.getPPID();
	}

	public IPinCodeCredential getPinCodeCredential() {
		return sic.getPinCodeCredential();
	}

	public void setPinCodeCredential(IPinCodeCredential pinCodeCredential) {
		sic.setPinCodeCredential(pinCodeCredential);
	}

}
