/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.common.auth;

import java.net.URI;
import java.security.cert.X509Certificate;

import javax.security.auth.callback.Callback;

import org.eclipse.higgins.icard.auth.ITSUsernamePasswordCredential;
import org.eclipse.higgins.icard.auth.ITokenServiceCredential;
import org.eclipse.higgins.icard.auth.IUsernamePasswordCredential;

public class TSUsernamePasswordCredential implements ITSUsernamePasswordCredential {
	ITokenServiceCredential tsc;
	IUsernamePasswordCredential upc;

	public TSUsernamePasswordCredential(ITokenServiceCredential tsc, IUsernamePasswordCredential upc) {
		this.tsc = tsc;
		this.upc = upc;
	}

	public URI getAddress() {
		return tsc.getAddress();
	}

	public X509Certificate getCertificate() {
		return tsc.getCertificate();
	}

	public URI getMetadataAddress() {
		return tsc.getMetadataAddress();
	}

	public Callback[] getCallbacks() {
		Callback[] cts = tsc.getCallbacks();
		Callback[] cup = upc.getCallbacks();
		Callback[] c = new Callback[cts.length + cup.length];
		for (int i = 0; i < c.length; i++) {
			if (i < cts.length) {
				c[i] = cts[i];
			} else {
				c[i] = cup[i - cts.length];
			}
		}
		return c;
	}

	public boolean isUsernamePredefined() {
		return upc.isUsernamePredefined();
	}

	public String getUsername() {
		return upc.getUsername();
	}

	public void setUsername(String username) {
		upc.setUsername(username);
	}

	public String getPassword() {
		return upc.getPassword();
	}

	public void setPassword(String password) {
		upc.setPassword(password);
	}
}