/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.common.auth;

import javax.security.auth.callback.Callback;

import org.eclipse.higgins.icard.auth.IX509V3Credential;
import org.eclipse.higgins.icard.common.auth.callback.X509V3Callback;

public class X509V3Credential implements IX509V3Credential {
	
	protected Callback[] callbacks = new Callback[1];
	protected X509V3Callback x509c;

	public X509V3Credential(String vt, String et, String ek) {
		x509c = new X509V3Callback(vt, et, ek);
		callbacks[0] = x509c;
	}

	public Callback[] getCallbacks() {
		return callbacks;
	}

}
