/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.common.auth.callback;

import java.io.Serializable;

import javax.security.auth.callback.Callback;

public class X509V3Callback implements Callback, Serializable {
	private static final long serialVersionUID = 2157215580035141023L;

	private String ValueType;
	private String EncodingType;
	private String encoded_key;
	
	public X509V3Callback(String vt, String et, String ek) {
		this.ValueType = vt;
		this.EncodingType = et;
		this.encoded_key = ek;
	}

	public String getValueType() {
		return ValueType;
	}

	public void setValueType(String valueType) {
		ValueType = valueType;
	}

	public String getEncodingType() {
		return EncodingType;
	}

	public void setEncodingType(String encodingType) {
		EncodingType = encodingType;
	}

	public String getEncoded_key() {
		return encoded_key;
	}

	public void setEncoded_key(String encoded_key) {
		this.encoded_key = encoded_key;
	}
}
