package org.eclipse.higgins.icard.common.io;

import org.eclipse.higgins.icard.io.IFormatProvider;
import org.eclipse.higgins.registry.IConfiguration;

public abstract class AbstractFormatProvider implements IFormatProvider {
	private final String id;

	private final String name;

	private final String fileExtension;

	private final String description;
	
	public AbstractFormatProvider(final String id, final String name, final String fileExtension, final String description) {
		this.id = id;
		this.name = name;
		this.fileExtension = fileExtension;
		this.description = description;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.icard.io.IOFormatDescriptor#getDescription()
	 */
	public String getDescription() {
		return description;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.icard.io.IOFormatDescriptor#getFileExtension()
	 */
	public String getFileExtension() {
		return fileExtension;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.icard.io.IOFormatDescriptor#getName()
	 */
	public String getName() {
		return name;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.registry.IServiceProvider#getConfiguration()
	 */
	public IConfiguration getConfiguration() {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.registry.IServiceProvider#getID()
	 */
	public String getID() {
		return id;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.registry.IServiceProvider#setID(java.lang.String)
	 */
	public void setID(String id) throws Exception {
		throw new UnsupportedOperationException();
	}

}
