/*******************************************************************************
 * Copyright (c) 2007-2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.common.io;

import org.eclipse.higgins.icard.auth.ICredentialDescriptor;
import org.eclipse.higgins.icard.io.IElementFormat;
import org.eclipse.higgins.icard.io.IFormatDescriptor;

public class FormatDescriptor implements IFormatDescriptor {
	protected ICredentialDescriptor credentialDescriptor;
	protected IElementFormat elementDescriptor;
	protected String name;
	protected String description;
	protected String fileExtension;
	protected String id;

	public FormatDescriptor(String id, String name, String description, String fileExtension, ICredentialDescriptor credentialDescriptor, IElementFormat elementDescriptor) {
		setID(id);
		setName(name);
		setDescription(description);
		setFileExtension(fileExtension);
		setCredentialDescriptor(credentialDescriptor);
		setElementDescriptor(elementDescriptor);
	}

	public ICredentialDescriptor getCredentialDescriptor() {
		return credentialDescriptor;
	}

	protected void setCredentialDescriptor(ICredentialDescriptor credentialDescriptor) {
		this.credentialDescriptor = credentialDescriptor;
	}

	public String getDescription() {
		return description;
	}

	protected void setDescription(String description) {
		this.description = description;
	}

	public String getFileExtension() {
		return fileExtension;
	}

	protected void setFileExtension(String fileExtension) {
		this.fileExtension = fileExtension;
	}

	public String getName() {
		return name;
	}

	protected void setName(String name) {
		this.name = name;
	}

	public String getID() {
		return id;
	}

	protected void setID(String id) {
		this.id = id;
	}

	public IElementFormat getElementDescriptor() {
		return elementDescriptor;
	}

	protected void setElementDescriptor(IElementFormat elementDescriptor) {
		this.elementDescriptor = elementDescriptor;
	}
}
