/*******************************************************************************
 * Copyright (c) 2007-2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.common.io;

import org.apache.axiom.om.OMElement;
import org.eclipse.higgins.icard.common.utils.XMLHelper;
import org.eclipse.higgins.icard.io.IElement;
import org.w3c.dom.Element;

public class IOElement implements IElement
{
	/**
	 * The contained element object
	 */
	private Object objectElement = null;

	/**
	 * Gets the Class of the contained element object
	 * 
	 */
	public java.lang.Class getObjectClass()
	{
		if (null == this.objectElement) {
			return null;
		}
		return this.objectElement.getClass();
	}
	
	/**
	 * Gets the List of the element Classes supported by the underlying implementation
	 * 
	 */
	public Class[] getSupportedClasses()
	{
		final java.util.List result = new java.util.ArrayList();
		result.add(String.class);
		result.add(Element.class);
		result.add(OMElement.class);
		return (Class[]) result.toArray();
	}

	public Object get()
	{
		return this.objectElement;
	}

	public Object getAs(final Class classElement) throws Exception
	{
		if (null == this.objectElement) {
			return null;
		}
		if (classElement.isInstance(this.objectElement))
		{
			return this.objectElement;
		}
		final Object resultElement = null;
		try
		{
			if (String.class.isInstance(this.objectElement))
			{
				final String strElement = (String)this.objectElement;
				if ((classElement.equals
					(org.w3c.dom.Element.class)))
				{
					return XMLHelper.toDOM(strElement);
				}
				else if ((classElement.equals
					(OMElement.class)))
				{
					return XMLHelper.toOM(strElement);
				}
			}
			else if (org.w3c.dom.Element.class.isInstance(this.objectElement))
			{
				final org.w3c.dom.Element domElement = (org.w3c.dom.Element)this.objectElement;
				if (classElement.equals
					(String.class))
				{
					return XMLHelper.toString(domElement);
				}
				else if ((classElement.equals(OMElement.class)))
				{
					return XMLHelper.toOM(domElement);				
				}
			}
			else if (OMElement.class.isInstance(this.objectElement))
			{
				final OMElement omElement = (OMElement)this.objectElement;
				if (classElement.equals(String.class))
				{
					return XMLHelper.toString(omElement);
				}
				else if ((classElement.equals
					(org.w3c.dom.Element.class)))
				{
					return XMLHelper.toDOM(omElement);				
				}
			}		
			else
			{
				throw new Exception("Unsupported class: " + classElement.getName());			
			}
		}
		catch (final Exception e)
		{
			return null;
		}
		return resultElement;
	}

	public void set
		(final Object objectElement)
		throws Exception
	{
		if (null != objectElement)
		{
			if (!((String.class.isInstance(objectElement))
				|| (Element.class.isInstance(objectElement))
				|| (OMElement.class.isInstance(objectElement))))
			{
				throw new Exception
					("Unsupported IElement.set: " + objectElement.getClass().getName());
			}
		}
		this.objectElement = objectElement;
	}

}
