/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.icard.common.utils;

import java.net.URI;

/**
 * Contains URIs of higgins schema for CardSpace-interoperable I-Card
 */
public class IdASContext {

	public static final String HIGGINS_NS = "http://www.eclipse.org/higgins/ontologies/2008/6/higgins#";
	public static final String ICARD_NS = "http://www.eclipse.org/higgins/ontologies/2008/infoCard#";

	//
	public static final URI HIGGINS_uniqueIdentifier = URI.create(HIGGINS_NS + "entityId");

	// ICard subject URIs
	public static final URI ICARD_ICard = URI.create(ICARD_NS + "ICard");
	public static final URI ICARD_language = URI.create(ICARD_NS + "language");
	public static final URI ICARD_supportedClaimType = URI.create(ICARD_NS + "supportedClaimType");
	public static final URI ICARD_version = URI.create(ICARD_NS + "version");
	public static final URI ICARD_name = URI.create(ICARD_NS + "name");
	public static final URI ICARD_image = URI.create(ICARD_NS + "image");
	public static final URI ICARD_imageMimeType = URI.create(ICARD_NS + "imageMimeType");
	public static final URI ICARD_issuer = URI.create(ICARD_NS + "issuer");
	public static final URI ICARD_issuerName = URI.create(ICARD_NS + "issuerName");
	public static final URI ICARD_expiredTime = URI.create(ICARD_NS + "expiredTime");
	public static final URI ICARD_timeIssued = URI.create(ICARD_NS + "timeIssued");
	public static final URI ICARD_timeLastUpdated = URI.create(ICARD_NS + "timeLastUpdated");
	public static final URI ICARD_isSelfIssued = URI.create(ICARD_NS + "isSelfIssued");
	public static final URI ICARD_supportedTokenType = URI.create(ICARD_NS + "supportedTokenType");
	public static final URI ICARD_ClaimType = URI.create(ICARD_NS + "ClaimType");
	public static final URI ICARD_claimTypeType = URI.create(ICARD_NS + "claimTypeType");
	public static final URI ICARD_claimTypeName = URI.create(ICARD_NS + "claimTypeName");
	public static final URI ICARD_claimTypeDescription = URI.create(ICARD_NS + "claimTypeDescription");

	// InformationCard subject URIs
	public static final URI ICARD_InformationCard = URI.create(ICARD_NS + "InformationCard");
	public static final URI ICARD_hashSalt = URI.create(ICARD_NS + "hashSalt");
	public static final URI ICARD_masterKey = URI.create(ICARD_NS + "masterKey");

	// PersonalInformationCard subject URIs
	public static final URI ICARD_PersonalInformationCard = URI.create(ICARD_NS + "PersonalInformationCard");
	public static final URI ICARD_pinDigest = URI.create(ICARD_NS + "pinDigest");
	public static final URI ICARD_ClaimValueListRef = URI.create(ICARD_NS + "ClaimValueListRef");
	public static final URI ICARD_claimValueListRef = URI.create(ICARD_NS + "claimValueListRef");
	public static final URI ICARD_claimValueListContext = URI.create(ICARD_NS + "claimValueListContext");
	public static final URI ICARD_claimValueListSubject = URI.create(ICARD_NS + "claimValueListSubject");
	
	//ManagedInformationCard subject URIs
	public static final URI ICARD_ManagedInformationCard = URI.create(ICARD_NS + "ManagedInformationCard");
	public static final URI ICARD_requireAppliesTo = URI.create(ICARD_NS + "requireAppliesTo");
	public static final URI ICARD_privacyNotice = URI.create(ICARD_NS + "privacyNotice");
	public static final URI ICARD_TokenService = URI.create(ICARD_NS + "TokenService");
	public static final URI ICARD_tokenService = URI.create(ICARD_NS + "tokenService");
	public static final URI ICARD_endpoint_address = URI.create(ICARD_NS + "endpoint_address");
	public static final URI ICARD_endpoint_metadata = URI.create(ICARD_NS + "endpoint_metadata");
	public static final URI ICARD_endpoint_identity = URI.create(ICARD_NS + "endpoint_identity");
	public static final URI ICARD_credential_displayCredentialHint = URI.create(ICARD_NS + "credential_displayCredentialHint");
	public static final URI ICARD_credential_credential = URI.create(ICARD_NS + "credential_credential");

	//ClaimList subject URIs
	public static final URI ICARD_ClaimList = URI.create(ICARD_NS + "ClaimList");
//	public static final URI ICARD_Claim = URI.create(ICARD_NS + "Claim");
//	public static final URI ICARD_claim = URI.create(ICARD_NS + "claim");
//	public static final URI ICARD_typeOfClaim = URI.create(ICARD_NS + "typeOfClaim");
//	public static final URI ICARD_valueOfClaim = URI.create(ICARD_NS + "valueOfClaim");
	public static final URI ICARD_CardReference = URI.create(ICARD_NS + "CardReference");
	public static final URI ICARD_cardReference = URI.create(ICARD_NS + "cardReference");
	public static final URI ICARD_subjectCardReference = URI.create(ICARD_NS + "subjectCardReference");
	public static final URI ICARD_contextCardReference = URI.create(ICARD_NS + "contextCardReference");

}
