/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICardExtensionEvent;
import org.eclipse.higgins.icard.IExtensionListener;
import org.eclipse.higgins.icard.IInformationCardExtension;
import org.eclipse.higgins.icard.io.IElement;

public class InformationCardExtension
implements IInformationCardExtension {
    protected IElement element;
    protected boolean enabled;
    protected Object id;
    protected ArrayList listeners;

    public InformationCardExtension(IElement element, boolean enabled, Object id) {
        this.element = element;
        this.enabled = enabled;
        this.id = id;
    }

    public IElement getElement() {
        return this.element;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setElement(IElement extension) throws CardException {
        this.element = extension;
        this.setElementChangedEvent();
    }

    private void setElementChangedEvent() throws CardException {
        if (this.listeners != null && this.listeners.size() > 0) {
            ICardExtensionEvent event = new ICardExtensionEvent((IInformationCardExtension)this);
            Iterator lstnrs = this.listeners.iterator();
            while (lstnrs.hasNext()) {
                IExtensionListener listener = (IExtensionListener)lstnrs.next();
                listener.extensionElementChanged(event);
            }
        }
    }

    public void setEnabled(boolean enabled) throws CardException {
        this.enabled = enabled;
        this.setEnabledChangedEvent();
    }

    private void setEnabledChangedEvent() throws CardException {
        if (this.listeners != null && this.listeners.size() > 0) {
            ICardExtensionEvent event = new ICardExtensionEvent((IInformationCardExtension)this);
            Iterator lstnrs = this.listeners.iterator();
            while (lstnrs.hasNext()) {
                IExtensionListener listener = (IExtensionListener)lstnrs.next();
                listener.extensionEnabledChanged(event);
            }
        }
    }

    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public synchronized void addListener(IExtensionListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IExtensionListener listener) {
        if (this.listeners != null && this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }
}

