/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.AuthenticationException;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.CardParseException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.IPolicy;
import org.eclipse.higgins.icard.ISimpleClaim;
import org.eclipse.higgins.icard.ISimpleClaimType;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.common.BasicCardProvider;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.provider.cardspace.common.CRDData;
import org.eclipse.higgins.icard.provider.cardspace.common.CardSpacePolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.MCardEntity;
import org.eclipse.higgins.icard.provider.cardspace.common.ManagedCard;
import org.eclipse.higgins.icard.provider.cardspace.common.STSFaultException;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardUtils;
import org.eclipse.higgins.iss.ICardSelectorService;
import org.eclipse.higgins.iss.IDisplayToken;
import org.eclipse.higgins.iss.IICardSelector;
import org.eclipse.higgins.iss.IIdentityToken;
import org.eclipse.higgins.iss.SelectionANDofORs;
import org.eclipse.higgins.iss.SelectionANDofORsElm;
import org.w3c.dom.Element;

public abstract class ManagedCardProvider
extends BasicCardProvider {
    private static Log log;
    protected String rpKeyStore = null;
    protected String rpKeyStorePassword = null;
    protected String rpCertificateAlias = null;
    protected String relyingPartyURI = "urn://higgins-selector";
    protected X509Certificate rpCertificate = null;
    protected static final String APPLIES_TO_SELECTOR_ID = "appliesTo.selectorIdentifier";
    protected static final String APPLIES_TO_KEYSTORE = "appliesTo.keystoreFile";
    protected static final String APPLIES_TO_KEYSTORE_PASS = "appliesTo.keystorePassword";
    protected static final String APPLIES_TO_CERTIFICATE_ALIAS = "appliesTo.certificateAlias";
    protected static String strCertificate;
    protected X509Certificate certificate = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.icard.provider.cardspace.common.ManagedCardProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        strCertificate = "MIICVDCCAb2gAwIBAgIERWUHrzANBgkqhkiG9w0BAQUFADBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwHhcNMDYxMTIzMDIyOTU3WhcNMjYxMTE4MDIyOTU3WjBFMQswCQYDVQQGEwJVUzEQMA4GA1UEChMHRWNsaXBzZTEQMA4GA1UECxMHSGlnZ2luczESMBAGA1UEAxMJbG9jYWxob3N0MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCUFDtM2/nLEhSJqF7zqayW8gQ183KCiKME53VkSjl6C7O9J2hEiBMWsI9a+qBm13VWKvmTc3h3EsLaR/dOreXyCLKEwDIpwHojW3+i037OOxL6U3Ij094rqfHBCJP2xEyLNpPXdIioEgP5H6MTRPXShsBsTQ7bEhZs0QKyXwTNHwIDAQABo0YwRDAdBgNVHQ4EFgQUTHM9O3KViNYsvuGeg4eANMCFHuMwEwYDVR0lBAwwCgYIKwYBBQUHAwEwDgYDVR0PAQH/BAQDAgSwMA0GCSqGSIb3DQEBBQUAA4GBADkZZ34T637gwxp/EmRlRd4ru1Y2ribGoLRpY1icJYlyrUB3552f1K7r69EQxuwnyUnFYVhB+4ZnzhralkKtNs8UVo7RZHSE8jKWOi4YU3RXSqEHKs10ttQLLcHPuH4o9t2OJLeaVtaijbdicbxUEwqhgcNnNrQHe6+f5fgwzSYM";
    }

    protected void init(Map config) throws Exception {
        try {
            String selectorID;
            if (config.containsKey(APPLIES_TO_KEYSTORE)) {
                this.rpKeyStore = (String)config.get(APPLIES_TO_KEYSTORE);
            }
            if (config.containsKey(APPLIES_TO_KEYSTORE_PASS)) {
                this.rpKeyStorePassword = (String)config.get(APPLIES_TO_KEYSTORE_PASS);
            }
            if (config.containsKey(APPLIES_TO_CERTIFICATE_ALIAS)) {
                this.rpCertificateAlias = (String)config.get(APPLIES_TO_CERTIFICATE_ALIAS);
            }
            if (config.containsKey(APPLIES_TO_SELECTOR_ID) && (selectorID = (String)config.get(APPLIES_TO_SELECTOR_ID)) != null && selectorID.trim().length() > 0) {
                this.relyingPartyURI = selectorID;
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public ICard getICardByCUID(CallbackHandler authHandler, CUID cuid, ICredential userCredential) throws AuthenticationException, CardException {
        ICard card = this.getICardByCUID(authHandler, cuid);
        if (card instanceof ManagedCard) {
            if (this.rpCertificate == null) {
                this.initFakeRelyingPartyCertificate();
            }
            ManagedCard mcard = (ManagedCard)card;
            CardSpacePolicy p = new CardSpacePolicy();
            p.setRequiredClaims(mcard.getSupportedClaimTypesUris());
            String tokenType = CardUtils.getDefaultTokenType(mcard);
            p.setTokenType(tokenType);
            try {
                ICardSelectorService iss = ICardSelectorService.getInstance();
                IICardSelector s = iss.getICardSelector(authHandler, (IPolicy)p);
                SelectionANDofORs selection = new SelectionANDofORs();
                selection.action = this.relyingPartyURI;
                selection.add(new SelectionANDofORsElm(mcard.getCUID().toString(), 0, 0));
                selection.setCredential(userCredential);
                selection.sslCertChain = new X509Certificate[]{this.rpCertificate};
                LinkedList<ISimpleClaim> claims = new LinkedList<ISimpleClaim>();
                IIdentityToken t = s.getIdentityToken(selection);
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                t.getAs((Class)clazz);
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("org.eclipse.higgins.iss.IDisplayToken");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IDisplayToken dt = (IDisplayToken)t.getAs((Class)clazz2);
                Iterator itr = mcard.getSupportedClaimTypes();
                while (itr.hasNext()) {
                    ISimpleClaimType ct = (ISimpleClaimType)itr.next();
                    ISimpleClaim c = (ISimpleClaim)dt.getClaim(ct.getType());
                    if (c == null) {
                        c = new ClaimValue(ct, "");
                    }
                    claims.add(c);
                }
                mcard.setClaims(claims);
                return mcard;
            }
            catch (STSFaultException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CardException((Throwable)e);
            }
        }
        throw new CardException("Unsupported card type: " + card);
    }

    public ICardTemplate[] getCardCreationTemplates(CallbackHandler authHandler) {
        return null;
    }

    public ICardTemplate getCardCreationTemplatesByID(CallbackHandler authHandler, String ID) {
        return null;
    }

    public Class[] getSupportedTypes() {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.higgins.icard.IManagedInformationCard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return classArray;
    }

    protected X509Certificate getDefaultCertificate() {
        if (this.certificate == null) {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                String strEncryptionCertificate = "-----BEGIN CERTIFICATE-----\n" + strCertificate + "\n-----END CERTIFICATE-----\n";
                ByteArrayInputStream streamCertificate = new ByteArrayInputStream(strEncryptionCertificate.getBytes());
                this.certificate = (X509Certificate)certificateFactory.generateCertificate(streamCertificate);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return this.certificate;
    }

    public ICard parseCardElement(CallbackHandler authHandler, IElement element) throws CardParseException {
        Element card;
        block14: {
            if (element == null) {
                return null;
            }
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.w3c.dom.Element");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((card = (Element)element.getAs((Class)clazz)) != null) break block14;
            return null;
        }
        try {
            Element crd = null;
            if ("Signature".equals(card.getLocalName())) {
                CRDData crdData = CardCryptography.getCardFromSignedEnvelop(card);
                IElement iElm = crdData.getCard();
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("org.w3c.dom.Element");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                crd = (Element)iElm.getAs((Class)clazz);
            } else {
                crd = card;
            }
            MCardEntity c = new MCardEntity();
            c.initFromXML(crd);
            return c;
        }
        catch (CardParseException e) {
            throw e;
        }
        catch (Exception e) {
            log.warn((Object)e, (Throwable)e);
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    private X509Certificate getCertificateFromKeystore() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 131->134)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void initFakeRelyingPartyCertificate() {
        if (this.rpKeyStore == null) {
            log.warn((Object)"The file name of key store of fake RP certificate is not defined. The following configuration parameter should be defined: appliesTo.keystoreFile");
        } else if (this.rpCertificateAlias == null) {
            log.warn((Object)"The file name of key store of fake RP certificate is not defined. The following configuration parameter should be defined: appliesTo.keystoreFile");
        } else {
            this.rpCertificate = this.getCertificateFromKeystore();
        }
        if (this.rpCertificate == null) {
            this.rpCertificate = this.getCertificateFromKeystore();
        }
    }
}

