/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common;

import java.net.URI;
import java.security.cert.CertStore;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.policy.ICardSpacePolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.CardSpacePolicy;
import org.eclipse.higgins.sts.client.PPIDHelper;

public class PPIDCardSpacePolicy
extends CardSpacePolicy
implements ICardSpacePolicy {
    public X509Certificate[] x509Cert;
    byte[] ppid;
    private CertStore certStore;
    private String rpURL;
    static final String PPID_CLAIM = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier";
    static final String TOKEN_TYPE = "urn:oasis:names:tc:SAML:1.0:assertion";
    static final URI TOKEN_TYPE_URI = URI.create("urn:oasis:names:tc:SAML:1.0:assertion");

    public PPIDCardSpacePolicy(X509Certificate[] x509cert, CertStore certStore, byte[] ppid, String rpUrl) {
        this.x509Cert = x509cert;
        this.certStore = certStore;
        this.ppid = ppid;
        this.tokenType = TOKEN_TYPE;
        this.issuer = "http://schemas.xmlsoap.org/ws/2005/05/identity/issuer/self";
        this.rpURL = rpUrl;
        this.requiredClaims.add(PPID_CLAIM);
    }

    public boolean isSatisfiedBy(IInformationCard icard) {
        byte[] ppid_card;
        block5: {
            log.trace((Object)"CardSpacePolicy::isSatisfiedBy(IInformationCard icard)");
            log.trace((Object)("icard: " + icard));
            if (!this.issuer.equals(icard.getIssuer())) {
                log.trace((Object)"issuer not ok.");
                return false;
            }
            log.trace((Object)"issuer ok.");
            List suppTokenTypes = icard.getSupportedTokenTypes();
            log.trace((Object)("Supported token types: " + suppTokenTypes));
            if (suppTokenTypes == null || !suppTokenTypes.contains(TOKEN_TYPE_URI)) {
                log.trace((Object)("Token type: " + this.tokenType + " is not supported."));
            }
            try {
                ppid_card = PPIDHelper.computeClaimValuePPID((IInformationCard)icard, (X509Certificate[])this.x509Cert, (CertStore)this.certStore, (String)this.rpURL);
                if (!Arrays.equals(this.ppid, ppid_card)) break block5;
                return true;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                return false;
            }
        }
        ppid_card = PPIDHelper.computeOld1_5ClaimValuePPID((IInformationCard)icard, (X509Certificate[])this.x509Cert, (CertStore)this.certStore, (String)this.rpURL);
        return Arrays.equals(this.ppid, ppid_card);
    }
}

