/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common;

import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.AuthenticationException;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.CardParseException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.common.BasicCardProvider;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.provider.cardspace.common.PCardEntity;
import org.eclipse.higgins.icard.provider.cardspace.common.PersonalCard;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.PersonalCardTemplateHelper;
import org.w3c.dom.Element;

public abstract class PersonalCardProvider
extends BasicCardProvider {
    protected Log log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public PersonalCardProvider() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.icard.provider.cardspace.common.PersonalCardProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
    }

    public ICard getICardByCUID(CallbackHandler authHandler, CUID cuid, ICredential userCredential) throws AuthenticationException, CardException {
        ICard card = this.getICardByCUID(authHandler, cuid);
        if (card instanceof PersonalCard) {
            PersonalCard pcard = (PersonalCard)card;
            pcard.retrieveClaims(userCredential);
            return pcard;
        }
        throw new CardException("Unsupported card type: " + card);
    }

    public ICardTemplate[] getCardCreationTemplates(CallbackHandler authHandler) {
        return new ICardTemplate[]{PersonalCardTemplateHelper.getCardTemplate((ICardProvider)this)};
    }

    public ICardTemplate getCardCreationTemplatesByID(CallbackHandler authHandler, String ID) {
        if ("PersonalCardTemplate".equals(ID)) {
            return PersonalCardTemplateHelper.getCardTemplate((ICardProvider)this);
        }
        return null;
    }

    public Class[] getSupportedTypes() {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.higgins.icard.IPersonalInformationCard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return classArray;
    }

    public ICard parseCardElement(CallbackHandler authHandler, IElement element) throws CardParseException {
        Element card;
        block9: {
            if (element == null) {
                return null;
            }
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.w3c.dom.Element");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((card = (Element)element.getAs((Class)clazz)) != null) break block9;
            return null;
        }
        try {
            PCardEntity c = new PCardEntity();
            c.initFromXML(card);
            return c;
        }
        catch (CardParseException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.warn((Object)e, (Throwable)e);
            return null;
        }
    }
}

