/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.common.io.IOElement;
import org.eclipse.higgins.icard.common.utils.CardContext;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.policy.ISTSPrivacyPolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.XMLUtils;
import org.w3c.dom.Element;

public class STSPrivacyPolicy
implements ISTSPrivacyPolicy {
    protected static Log log;
    protected IElement element;
    protected String version;
    protected String policyURL;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.icard.provider.cardspace.common.STSPrivacyPolicy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public STSPrivacyPolicy(String policyURL, String version) throws CardException {
        if (policyURL == null) {
            throw new CardException("Parameter \"policyURL\" is null.");
        }
        try {
            new URI(policyURL);
        }
        catch (URISyntaxException e) {
            throw new CardException("Privacy policy URL is not valid URI : " + policyURL, (Throwable)e);
        }
        this.policyURL = policyURL;
        if (version != null && version.trim().length() > 0) {
            int v;
            try {
                v = Integer.parseInt(version);
            }
            catch (NumberFormatException e) {
                throw new CardException("Privacy policy version should be positive integer : " + policyURL, (Throwable)e);
            }
            if (v < 0) {
                throw new CardException("Privacy policy version should be positive integer : " + policyURL);
            }
            this.version = version;
        }
    }

    public STSPrivacyPolicy(Element element) throws CardException {
        if (element == null) {
            throw new CardException("Parameter \"element\" is null.");
        }
        this.element = new IOElement();
        try {
            this.element.set((Object)element);
        }
        catch (Exception e) {
            throw new CardException((Throwable)e);
        }
        String ver = element.getAttribute("Version");
        this.version = ver != null ? ver : "";
        this.policyURL = XMLUtils.getTextContent(element);
        try {
            new URL(this.policyURL);
        }
        catch (MalformedURLException e) {
            throw new CardException("URL of STS privacy policy is not valid", (Throwable)e);
        }
    }

    public STSPrivacyPolicy(String privacyPolicy) throws CardException {
        if (privacyPolicy == null) {
            throw new CardException("Parameter \"privacyPolicy\" is null.");
        }
        this.element = new IOElement();
        try {
            this.element.set((Object)privacyPolicy);
        }
        catch (Exception e) {
            throw new CardException((Throwable)e);
        }
        OMElement oe = null;
        try {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.apache.axiom.om.OMElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            oe = (OMElement)this.element.getAs((Class)clazz);
        }
        catch (Exception e) {
            throw new CardException((Throwable)e);
        }
        String ver = oe.getAttributeValue(CardContext.QN_IC_VERSION_ATTR);
        this.version = ver != null ? ver : "";
        this.policyURL = oe.getText();
        try {
            new URL(this.policyURL);
        }
        catch (MalformedURLException e) {
            throw new CardException("URL of STS privacy policy is not valid", (Throwable)e);
        }
    }

    public IElement getPrivacyElement() {
        if (this.element == null) {
            try {
                this.initPrivacyElement();
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return this.element;
    }

    private synchronized void initPrivacyElement() throws Exception {
        if (this.element == null) {
            OMElement elm = OMAbstractFactory.getOMFactory().createOMElement(CardContext.QN_IC_PRIVACY_NOTICE, null);
            elm.setText(this.policyURL);
            if (this.version != null) {
                elm.addAttribute("Version", this.version, null);
            }
            IOElement ioelm = new IOElement();
            ioelm.set((Object)elm);
            this.element = ioelm;
        }
    }

    public String getPrivacyUrl() {
        return this.policyURL;
    }

    public String getPrivacyVersion() {
        return this.version;
    }
}

