/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common;

import org.eclipse.higgins.icard.ITokenService;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.ICredentialDescriptor;
import org.eclipse.higgins.icard.auth.ITokenServiceCredential;
import org.eclipse.higgins.icard.common.auth.TokenServiceCredential;
import org.w3c.dom.Element;

public class TSCredentialDescriptor
implements ICredentialDescriptor {
    protected String type_;
    protected String displayCredentialHint_;
    protected ITokenServiceCredential credential_;
    protected Element credentialElement_ = null;
    protected ITokenService tokenService = null;

    public TSCredentialDescriptor(ITokenService tokenService) {
        this.tokenService = tokenService;
        this.initialize();
    }

    public TSCredentialDescriptor(String type, String displayCredentialHint, ITokenServiceCredential credential) {
        this.type_ = type;
        this.displayCredentialHint_ = displayCredentialHint;
        this.credential_ = credential;
    }

    private void initialize() {
        if (this.tokenService != null) {
            ICredentialDescriptor base = this.tokenService.getUserCredential();
            this.type_ = base.getType();
            this.displayCredentialHint_ = base.getDisplayCredentialHint();
            this.credentialElement_ = base.asXML();
            this.credential_ = new TokenServiceCredential(this.tokenService.getEndpointReference()).createCredential(base.getCredential());
        }
    }

    public Element asXML() {
        return this.credentialElement_;
    }

    public ICredential getCredential() {
        return this.credential_;
    }

    public String getDisplayCredentialHint() {
        return this.displayCredentialHint_;
    }

    public String getType() {
        return this.type_;
    }
}

