/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common.io;

import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.IImportCardInfo;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.common.io.ImportCardInformation;
import org.eclipse.higgins.icard.common.utils.XMLHelper;
import org.eclipse.higgins.icard.io.CardIOException;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.io.IFormatDescriptor;
import org.eclipse.higgins.icard.io.IInputProcessor;
import org.eclipse.higgins.icard.provider.cardspace.common.CRDData;
import org.eclipse.higgins.icard.provider.cardspace.common.SignatureNotValidException;
import org.eclipse.higgins.icard.provider.cardspace.common.io.CRDFormatProvider;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.w3c.dom.Element;

public class CRDInputProcessor
implements IInputProcessor {
    private Log log;
    static /* synthetic */ Class class$0;

    public CRDInputProcessor() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.icard.provider.cardspace.common.io.CRDInputProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
    }

    public IFormatDescriptor checkInput(InputStream is) throws SignatureNotValidException {
        IFormatDescriptor format = null;
        try {
            Element crdElm = XMLHelper.domFromStream((InputStream)is);
            CardCryptography.getCardFromSignedEnvelop(crdElm);
            format = CRDFormatProvider.formatDescriptor;
        }
        catch (SignatureNotValidException e) {
            throw e;
        }
        catch (Exception e) {
            format = null;
            this.log.info((Object)e, (Throwable)e);
        }
        return format;
    }

    public IElement[] process(InputStream is, ICredential credential) throws CardIOException {
        try {
            Element crdElm = XMLHelper.domFromStream((InputStream)is);
            CRDData crdData = CardCryptography.getCardFromSignedEnvelop(crdElm);
            if (!crdData.isSignatureValid()) {
                throw new SignatureNotValidException("Signature is not valid, most likely .crd file is corrupt.");
            }
            IElement[] res = new IElement[]{crdData.getCard()};
            return res;
        }
        catch (SignatureNotValidException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new CardIOException((Throwable)e);
        }
    }

    public IImportCardInfo[] getCardInformation(InputStream is, ICredential credential) throws CardIOException {
        try {
            Element crdElm = XMLHelper.domFromStream((InputStream)is);
            CRDData crdData = CardCryptography.getCardFromSignedEnvelop(crdElm);
            if (!crdData.isSignatureValid()) {
                throw new SignatureNotValidException("Signature is not valid, most likely .crd file is corrupt.");
            }
            IImportCardInfo[] res = new IImportCardInfo[]{new ImportCardInformation(crdData.getCard(), "org.eclipse.higgins.icard.format.crd", crdData.getCertificateChain())};
            return res;
        }
        catch (SignatureNotValidException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new CardIOException("Can not get certificate chain from CRD document", (Throwable)e);
        }
    }
}

