/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common.io;

import java.io.InputStream;
import java.util.ArrayList;
import javax.security.auth.callback.PasswordCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.IImportCardInfo;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.common.io.ImportCardInformation;
import org.eclipse.higgins.icard.io.CardIOException;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.io.IFormatDescriptor;
import org.eclipse.higgins.icard.io.IInputProcessor;
import org.eclipse.higgins.icard.provider.cardspace.common.io.HDSCardElement;
import org.eclipse.higgins.icard.provider.cardspace.common.io.HDSFormatProvider;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HDSInputProcessor
implements IInputProcessor {
    private Log log;
    static /* synthetic */ Class class$0;

    public HDSInputProcessor() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.icard.provider.cardspace.common.io.HDSInputProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
    }

    public IFormatDescriptor checkInput(InputStream is) {
        IFormatDescriptor res = null;
        if (CardCryptography.isEncriptedStore(is)) {
            res = HDSFormatProvider.formatDescriptor;
        }
        return res;
    }

    public IElement[] process(InputStream is, ICredential credential) throws CardIOException {
        Document cardBackup;
        IElement[] res = null;
        try {
            PasswordCallback pc = (PasswordCallback)credential.getCallbacks()[0];
            String password = new String(pc.getPassword());
            cardBackup = CardCryptography.decrypt(is, password);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardIOException((Throwable)e);
        }
        ArrayList<HDSCardElement> cardsList = new ArrayList<HDSCardElement>();
        NodeList newCards = cardBackup.getDocumentElement().getChildNodes();
        int i = 0;
        while (i < newCards.getLength()) {
            Node nd = newCards.item(i);
            if (nd.getNodeType() == 1) {
                Element card = (Element)nd;
                try {
                    HDSCardElement e = new HDSCardElement();
                    e.set(card);
                    cardsList.add(e);
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                }
            }
            ++i;
        }
        res = new IElement[cardsList.size()];
        i = 0;
        while (i < res.length) {
            res[i] = (IElement)cardsList.get(i);
            ++i;
        }
        return res;
    }

    public IImportCardInfo[] getCardInformation(InputStream is, ICredential credential) throws CardIOException {
        IImportCardInfo[] res = null;
        IElement[] elements = this.process(is, credential);
        if (elements != null) {
            int len = elements.length;
            res = new IImportCardInfo[len];
            int i = 0;
            while (i < len) {
                res[i] = new ImportCardInformation(elements[i], "org.eclipse.higgins.icard.format.hds", null);
                ++i;
            }
        }
        return res;
    }
}

