/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common.io;

import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.IPasswordCredential;
import org.eclipse.higgins.icard.io.CardIOException;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.io.IOutputProcessor;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HDSOutputProcessor
implements IOutputProcessor {
    private Log log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public HDSOutputProcessor() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.icard.provider.cardspace.common.io.HDSOutputProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
    }

    public void process(IElement[] icards, OutputStream out, ICredential credential) throws CardIOException {
        IPasswordCredential pc = null;
        String password = null;
        if (credential instanceof IPasswordCredential) {
            pc = (IPasswordCredential)credential;
            password = pc.getPassword();
        }
        if (pc == null) {
            throw new CardIOException("Invalid credential type: " + credential);
        }
        if (password == null) {
            throw new CardIOException("Password can't be null");
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringComments(true);
            dbf.setIgnoringElementContentWhitespace(true);
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element store = doc.createElementNS("http://www.eclipse.org/higgins/2008/06/backup", "RoamingStore");
            doc.appendChild(store);
            int i = 0;
            while (i < icards.length) {
                IElement iElement = icards[i];
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.w3c.dom.Element");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Element e = (Element)iElement.getAs((Class)clazz);
                Element card = (Element)doc.importNode(e, true);
                store.appendChild(card);
                ++i;
            }
            CardCryptography.encrypt(doc, out, password);
        }
        catch (Exception e) {
            this.log.error((Object)"Can't export cards", (Throwable)e);
            throw new CardIOException("Can't export cards", (Throwable)e);
        }
    }
}

