/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common.io;

import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.IPasswordCredential;
import org.eclipse.higgins.icard.io.CardIOException;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.io.IOutputProcessor;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HDSOutputProcessor
implements IOutputProcessor {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$common$io$HDSOutputProcessor == null ? (class$org$eclipse$higgins$icard$provider$cardspace$common$io$HDSOutputProcessor = HDSOutputProcessor.class$("org.eclipse.higgins.icard.provider.cardspace.common.io.HDSOutputProcessor")) : class$org$eclipse$higgins$icard$provider$cardspace$common$io$HDSOutputProcessor));
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$common$io$HDSOutputProcessor;
    static /* synthetic */ Class class$org$w3c$dom$Element;

    public void process(IElement[] icards, OutputStream out, ICredential credential) throws CardIOException {
        IPasswordCredential pc = null;
        String password = null;
        if (credential instanceof IPasswordCredential) {
            pc = (IPasswordCredential)credential;
            password = pc.getPassword();
        }
        if (pc == null) {
            throw new CardIOException("Invalid credential type: " + credential);
        }
        if (password == null) {
            throw new CardIOException("Password can't be null");
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringComments(true);
            dbf.setIgnoringElementContentWhitespace(true);
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element store = doc.createElementNS("http://www.eclipse.org/higgins/2008/06/backup", "RoamingStore");
            doc.appendChild(store);
            for (int i = 0; i < icards.length; ++i) {
                Element e = (Element)icards[i].getAs(class$org$w3c$dom$Element == null ? HDSOutputProcessor.class$("org.w3c.dom.Element") : class$org$w3c$dom$Element);
                Element card = (Element)doc.importNode(e, true);
                store.appendChild(card);
            }
            CardCryptography.encrypt(doc, out, password);
        }
        catch (Exception e) {
            this.log.error((Object)"Can't export cards", (Throwable)e);
            throw new CardIOException("Can't export cards", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

