/*******************************************************************************
 * Copyright (c) 2007-2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.provider.cardspace.common;

import java.util.Date;

import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.InvalidClaimException;
import org.eclipse.higgins.icard.InvalidStateException;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.ReadOnlyObjectException;

/**
 * Dummy class of managed cards which doesn't support update operations. Useful for
 * in-memory operations only.
 */
public class DummyManagedCard extends ManagedCard {

	public void applyUpdates() throws InvalidStateException, CardException {
		throw new UnsupportedOperationException();
	}

	public void beginUpdates() throws InvalidStateException {
		throw new UnsupportedOperationException();
	}

	public void cancelUpdates() throws InvalidStateException {
		throw new UnsupportedOperationException();
	}

	public boolean isEditMode() {
		return false;
	}

	public boolean isEditable() {
		return false;
	}

	public void setImage(byte[] newImage, String newImageType) throws CardException {
		throw new UnsupportedOperationException();
	}

	public void setIssuerName(String name) throws CardException {
		throw new UnsupportedOperationException();
	}

	public void setName(String newName) throws CardException {
		throw new UnsupportedOperationException();
	}

	public void setTimeExpires(Date date) throws CardException {
		throw new UnsupportedOperationException();
	}

	public IClaim createClaim(String type) throws InvalidTypeException, ReadOnlyObjectException, CardException {
		throw new UnsupportedOperationException();
	}

	public IClaim setClaim(IClaim copyFrom) throws InvalidClaimException, InvalidTypeException, ReadOnlyObjectException, CardException {
		throw new UnsupportedOperationException();
	}

}
