/*******************************************************************************
 * Copyright (c) 20072008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.provider.cardspace.common;

import javax.security.auth.callback.CallbackHandler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.AuthenticationException;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.IPersonalInformationCard;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.PersonalCardTemplateHelper;
import org.w3c.dom.Element;

public abstract class PersonalCardProvider implements ICardProvider {
	protected Log log = LogFactory.getLog(PersonalCardProvider.class);

	public ICard getICardByCUID(CallbackHandler authHandler, CUID cuid, ICredential userCredential) throws AuthenticationException, CardException {
		ICard card = getICardByCUID(authHandler, cuid);
		if (card instanceof PersonalCard) {
			PersonalCard pcard = (PersonalCard) card;
/*			ISelfIssuedCredential credentials = null;
			ICredentialDescriptor[] cds = pcard.getRequiredCredentials();
			if (cds != null && cds.length > 0) {
				credentials = (ISelfIssuedCredential) cds[0].getCredential();
			}
*/
			pcard.retrieveClaims(userCredential);
			return pcard;
		} else {
			throw new CardException("Unsupported card type: " + card);
		}
	}

	/**
	 * Returns template object for personal card.
	 */
	public ICardTemplate[] getCardCreationTemplates(CallbackHandler authHandler) {
		return new ICardTemplate[] {PersonalCardTemplateHelper.getCardTemplate(this)};
	}

	/**
	 * The only supported types is {@link IPersonalInformationCard}
	 */
	public Class[] getSupportedTypes() {
		return new Class[] {IPersonalInformationCard.class};
	}

	public boolean canImportICard(CallbackHandler authHandler, IElement element) {
		if (element == null)
			return false;
		try {
			Element card = (Element) element.getAs(Element.class);
			if (card == null) {
				return false;
			}
			DummyPersonalCard c = new DummyPersonalCard();
			c.initFromXML(card);
			return true;
		} catch (Exception e) {
			log.error(e);
		}
		return false;
	}

}
