/*******************************************************************************
 * Copyright (c) 2007-2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.provider.cardspace.common.io;

import org.eclipse.higgins.icard.common.auth.BasicCredentialDescriptor;
import org.eclipse.higgins.icard.common.auth.PasswordCredential;
import org.eclipse.higgins.icard.common.io.FormatDescriptor;
import org.eclipse.higgins.icard.io.IFormatDescriptor;
import org.eclipse.higgins.icard.io.IFormatProvider;
import org.eclipse.higgins.icard.io.IInputProcessor;
import org.eclipse.higgins.icard.io.IOutputProcessor;
import org.eclipse.higgins.registry.IConfiguration;

public class CRDSFormatProvider implements IFormatProvider {
	private static final String FORMAT_ID = "org.eclipse.higgins.icard.format.crds";

	private static final String FORMAT_NAME = "Cardspace Back-up File Format";

	private static final String FILE_EXTENSION = ".crds";

	private static final String FORMAT_DESCRIPTION = "This format represents the format of Cardspace back-up files.";
	
	protected static final IFormatDescriptor formatDescriptor = new FormatDescriptor(FORMAT_NAME, FORMAT_DESCRIPTION, FILE_EXTENSION, new BasicCredentialDescriptor("PasswordCredential", "Please type password", PasswordCredential.class));
	private final IInputProcessor inputProcessor = new CRDSInputProcessor(); 
	private final IOutputProcessor outputProcessor = null; 


	/* (non-Javadoc)
	 * @see org.eclipse.higgins.registry.IServiceProvider#getConfiguration()
	 */
	public IConfiguration getConfiguration() {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.registry.IServiceProvider#getID()
	 */
	public String getID() {
		return FORMAT_ID;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.registry.IServiceProvider#setID(java.lang.String)
	 */
	public void setID(String id) throws Exception {
		throw new UnsupportedOperationException();
	}

	public IFormatDescriptor getFormatDescriptor() {
		return formatDescriptor;
	}

	public IInputProcessor getInputProcessor() {
		return inputProcessor;
	}

	public IOutputProcessor getOutputProcessor() {
		return outputProcessor;
	}

}
