/*******************************************************************************
 * Copyright (c) 2007-2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.provider.cardspace.common.io;

import java.net.URI;

import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.common.io.IOElement;
import org.eclipse.higgins.icard.io.IICardElement;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardContext;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardUtils;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.XMLUtils;
import org.w3c.dom.Element;

public class IOICardElement extends IOElement implements IICardElement {
	protected CUID cuid = null;
	
	public void set(Object objectElement) throws Exception {
		super.set(objectElement);
		initCUID();
	}

	public CUID getCUID() {
		return cuid;
	}

	protected void initCUID() throws Exception {
//		String s = (String) getAs(String.class);
//		System.out.println(s);
		Element card = (Element) getAs(Element.class);
		if ("RoamingInformationCard".equals(card.getLocalName())) {
			card = XMLUtils.getChildElement(card, CardContext.IC_NS, "InformationCardMetaData");
		}
		if (card != null) {
			URI id = CardUtils.parseCardId(card);
			String issuer = CardUtils.parseIssuer(card);
			String providerID = null;
			cuid = new CUID(providerID, issuer, id.toString());
		}
	}
}
