/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.CardParseException;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.ICredentialDescriptor;
import org.eclipse.higgins.icard.common.auth.SelfIssuedCredential;
import org.eclipse.higgins.icard.common.auth.UsernamePasswordCredential;
import org.eclipse.higgins.icard.common.auth.X509V3Credential;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CredentialDescriptor
implements ICredentialDescriptor {
    private String type_;
    private String displayCredentialHint_;
    private Element credentialElm_;
    protected ICredential credential_;

    public CredentialDescriptor(String hint, String credential) throws ParserConfigurationException, SAXException, IOException, IllegalArgumentException, CardException {
        this.displayCredentialHint_ = hint;
        if (credential == null) {
            throw new IllegalArgumentException("Parameter \"credential\" is null.");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringComments(true);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        StringReader sisCredential = new StringReader(credential);
        InputSource isCredential = new InputSource(sisCredential);
        Document mdDoc = db.parse(isCredential);
        this.credentialElm_ = mdDoc.getDocumentElement();
        this.credentialElm_.removeAttribute("xmlns");
        this.parseType();
    }

    public CredentialDescriptor(String hint, Element credential) throws IllegalArgumentException, CardException {
        this.displayCredentialHint_ = hint;
        if (credential == null) {
            throw new IllegalArgumentException("Parameter \"credential\" is null.");
        }
        this.credentialElm_ = credential;
        this.parseType();
    }

    public CredentialDescriptor(String hint, String type, ICredential credential) throws IllegalArgumentException, CardException {
        this.displayCredentialHint_ = hint;
        if (credential == null) {
            throw new IllegalArgumentException("Parameter \"credential\" is null.");
        }
        this.type_ = type;
        this.credential_ = credential;
    }

    public String getType() {
        return this.type_;
    }

    public String getDisplayCredentialHint() {
        return this.displayCredentialHint_;
    }

    public Element asXML() {
        return this.credentialElm_;
    }

    private void parseType() throws CardException {
        NodeList nl = this.credentialElm_.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Element e;
            Node node = nl.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            if ("DisplayCredentialHint".equals(node.getLocalName())) continue;
            this.type_ = node.getLocalName();
            if ("UsernamePasswordCredential".equals(this.type_)) {
                String name = null;
                e = XMLUtils.getChildElement(element, null, "Username");
                if (e != null) {
                    name = e.getFirstChild().getNodeValue();
                }
                this.credential_ = new UsernamePasswordCredential(name);
                continue;
            }
            if ("SelfIssuedCredential".equals(this.type_)) {
                String ppid = null;
                e = XMLUtils.getChildElement(element, null, "PrivatePersonalIdentifier");
                if (e != null) {
                    ppid = e.getFirstChild().getNodeValue();
                }
                this.credential_ = new SelfIssuedCredential(ppid);
                continue;
            }
            if ("KerberosV5Credential".equals(this.type_)) {
                throw new CardParseException("Cards with Kerberos credential type currently are not supported.");
            }
            if ("X509V3Credential".equals(this.type_)) {
                Element e2 = XMLUtils.getChildElement(element, null, "X509Data");
                if (e2 == null) continue;
                Element keyIdentifier = XMLUtils.getChildElement(e2, null, "KeyIdentifier");
                String value_type = keyIdentifier.getAttribute("ValueType");
                String encoding_type = keyIdentifier.getAttribute("EncodingType");
                String encoded_key = keyIdentifier.getFirstChild().getNodeValue();
                this.credential_ = new X509V3Credential(value_type, encoding_type, encoded_key);
                continue;
            }
            throw new CardParseException("Unexpected credentials type " + this.type_);
        }
    }

    public ICredential getCredential() {
        return this.credential_;
    }
}

