/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common.io;

import java.io.InputStream;
import java.util.ArrayList;
import javax.security.auth.callback.PasswordCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.IImportCardInfo;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.common.io.ImportCardInformation;
import org.eclipse.higgins.icard.io.CardIOException;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.io.IFormatDescriptor;
import org.eclipse.higgins.icard.io.IInputProcessor;
import org.eclipse.higgins.icard.provider.cardspace.common.io.HDSCardElement;
import org.eclipse.higgins.icard.provider.cardspace.common.io.HDSFormatProvider;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HDSInputProcessor
implements IInputProcessor {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$common$io$HDSInputProcessor == null ? (class$org$eclipse$higgins$icard$provider$cardspace$common$io$HDSInputProcessor = HDSInputProcessor.class$("org.eclipse.higgins.icard.provider.cardspace.common.io.HDSInputProcessor")) : class$org$eclipse$higgins$icard$provider$cardspace$common$io$HDSInputProcessor));
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$common$io$HDSInputProcessor;

    public IFormatDescriptor checkInput(InputStream is) {
        IFormatDescriptor res = null;
        if (CardCryptography.isEncriptedStore(is)) {
            res = HDSFormatProvider.formatDescriptor;
        }
        return res;
    }

    public IElement[] process(InputStream is, ICredential credential) throws CardIOException {
        int i;
        Document cardBackup;
        IElement[] res = null;
        try {
            PasswordCallback pc = (PasswordCallback)credential.getCallbacks()[0];
            String password = new String(pc.getPassword());
            cardBackup = CardCryptography.decrypt(is, password);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardIOException((Throwable)e);
        }
        ArrayList<HDSCardElement> cardsList = new ArrayList<HDSCardElement>();
        NodeList newCards = cardBackup.getDocumentElement().getChildNodes();
        for (i = 0; i < newCards.getLength(); ++i) {
            Node nd = newCards.item(i);
            if (nd.getNodeType() != 1) continue;
            Element card = (Element)nd;
            try {
                HDSCardElement e = new HDSCardElement();
                e.set(card);
                cardsList.add(e);
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)e);
            }
        }
        res = new IElement[cardsList.size()];
        for (i = 0; i < res.length; ++i) {
            res[i] = (IElement)cardsList.get(i);
        }
        return res;
    }

    public IImportCardInfo[] getCardInformation(InputStream is, ICredential credential) throws CardIOException {
        IImportCardInfo[] res = null;
        IElement[] elements = this.process(is, credential);
        if (elements != null) {
            int len = elements.length;
            res = new IImportCardInfo[len];
            for (int i = 0; i < len; ++i) {
                res[i] = new ImportCardInformation(elements[i], "org.eclipse.higgins.icard.format.hds", null);
            }
        }
        return res;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

