/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.icard.provider.cardspace.db;

import org.eclipse.higgins.icard.CardException;

/**
 * Common database access object interface
 * 
 */
public interface IDAO {

	public final static int NEW_OBJ = 0;

	public final static int STORED_OBJ = 1;

	public final static int CHANGED_OBJ = 2;

	public final static int PRE_DELETED_STORED_OBJ = 3;

	public final static int PRE_DELETED_NEW_OBJ = 4;

	public final static int DELETED_OBJ = 5;

	/**
	 * @return An identifier of this DAO object. If this object is not yet
	 *         stored then returns -1, otherwise returns a unique positive value
	 */
	public int getID();

	/**
	 * @return Identifier of its state. <code>NEW_OBJ</code> - a newly created
	 *         object was not yet stored. <code>STORED_OBJ</code> - object is
	 *         stored in the database and was not yet modified.
	 *         <code>CHANGED_OBJ</code> - stored object which was modified and
	 *         should be updated in database.
	 *         <code>PRE_DELETED_STORED_OBJ</code> - stored object which
	 *         should be deleted from database. <code>PRE_DELETED_NEW_OBJ</code> -
	 *         new object which should not be saved to database.
	 *         <code>DELETED_OBJ</code> - already deleted object.
	 */
	public int getState();

	/**
	 * Invocation of this method says that this object should be deleted.
	 * <code>PRE_DELETED_STORED_OBJ</code> - stored object which should be
	 * deleted from database during. <code>PRE_DELETED_NEW_OBJ</code> - new
	 * object which should not be saved to database.
	 * 
	 */
	public void setDeleteState();

	/**
	 * Persists the state of the DAO object.
	 * 
	 * @throws CardException
	 */
	public void store() throws CardException;

	/**
	 * @param listener
	 */
	public void addListener(IDAOListener listener);

	/**
	 * @param listener
	 */
	public void removeListener(IDAOListener listener);
}
