/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.icard.provider.cardspace.db;

import java.sql.Date;
import java.util.ArrayList;

import org.eclipse.higgins.icard.CardException;

/**
 * DAO interface which represents data of cardspace-compatible information card
 * (see cardspace techref)
 */
public interface IDaoCard extends IDAO {

	/**
	 * @return
	 */
	public String getUserID();

	/**
	 * @return
	 */
	public String getCardID();

	/**
	 * @param cardID
	 * @throws CardException
	 */
	public void setCardID(String cardID) throws CardException;

	/**
	 * @return
	 */
	public String getLanguage();

	/**
	 * @param language
	 * @throws CardException
	 */
	public void setLanguage(String language) throws CardException;

	/**
	 * @return
	 */
	public String getName();

	/**
	 * @param name
	 * @throws CardException
	 */
	public void setName(String name) throws CardException;

	/**
	 * @return
	 */
	public int getVersion();

	/**
	 * @param version
	 * @throws CardException
	 */
	public void setVersion(int version) throws CardException;

	/**
	 * @return
	 */
	public byte[] getImage();

	/**
	 * @param image
	 * @throws CardException
	 */
	public void setImage(byte[] image) throws CardException;

	/**
	 * @return
	 */
	public String getImageType();

	/**
	 * @param imageType
	 * @throws CardException
	 */
	public void setImageType(String imageType) throws CardException;

	/**
	 * @return
	 */
	public Date getTimeIssued();

	/**
	 * @param timeIssued
	 * @throws CardException
	 */
	public void setTimeIssued(Date timeIssued) throws CardException;

	/**
	 * @return
	 */
	public Date getTimeExpires();

	/**
	 * @param timeExpires
	 * @throws CardException
	 */
	public void setTimeExpires(Date timeExpires) throws CardException;

	/**
	 * @return
	 */
	public Date getTimeLastUpdated();

	/**
	 * @param timeLastUpdated
	 * @throws CardException
	 */
	public void setTimeLastUpdated(Date timeLastUpdated) throws CardException;

	/**
	 * @return
	 */
	public byte[] getHashSalt();

	/**
	 * @param hashSalt
	 * @throws CardException
	 */
	public void setHashSalt(byte[] hashSalt) throws CardException;

	/**
	 * @return
	 */
	public byte[] getMasterKey();

	/**
	 * @param masterKey
	 * @throws CardException
	 */
	public void setMasterKey(byte[] masterKey) throws CardException;

	/**
	 * @return
	 */
	public byte[] getIssuerID();

	/**
	 * @param issuerID
	 * @throws CardException
	 */
	public void setIssuerID(byte[] issuerID) throws CardException;

	/**
	 * @return <code>ArrayList</code> of
	 *         <code>IDaoInformationCardExtension</code> extensions
	 */
	public ArrayList getExtensions();

	/**
	 * @return
	 */
	public IDaoInformationCardExtension createInformationCardExtension();

	/**
	 * @param extension
	 * @throws CardException
	 */
	public void addInformationCardExtension(IDaoInformationCardExtension extension) throws CardException;

}
