/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.icard.provider.cardspace.db;

import org.eclipse.higgins.icard.CardException;

/**
 * Represents <code>IInformationCardExtension</code> data
 * 
 */
public interface IDaoInformationCardExtension extends IDAO {

	/**
	 * Id of owner card
	 * 
	 * @return
	 */
	public int getCardID();

	/**
	 * @return Card extension XML element
	 */
	public String getElement();

	/**
	 * @param element
	 *            Card extension XML element
	 * @throws CardException
	 */
	public void setElement(String element) throws CardException;

	/**
	 * @return Whether this extension should be processed
	 */
	public boolean isEnabled();

	/**
	 * Enable/disable this extension for processing
	 * @param enabled
	 * @throws CardException
	 */
	public void setEnabled(boolean enabled) throws CardException;

}
