/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.icard.provider.cardspace.db;

import java.util.ArrayList;

import org.eclipse.higgins.icard.CardException;

/**
 * DAO interface which represents data of cardspace-compatible managed card (see
 * cardspace techref)
 */
public interface IDaoMCard extends IDaoCard {

	/**
	 * @return
	 */
	public Boolean getRequireAppliesTo();

	/**
	 * @param requireAppliesTo
	 * @throws CardException
	 */
	public void setRequireAppliesTo(Boolean requireAppliesTo) throws CardException;

	/**
	 * @return
	 */
	public String getPrivacyNotice();

	/**
	 * @param privacyNotice
	 * @throws CardException
	 */
	public void setPrivacyNotice(String privacyNotice) throws CardException;

	/**
	 * @return
	 */
	public ArrayList getSupportedTokenTypeList();

	/**
	 * @return
	 */
	public IDaoSupportedTokenType createSupportedTokenType();

	/**
	 * @param supportedTokenType
	 * @throws CardException
	 */
	public void addSupportedTokenType(IDaoSupportedTokenType supportedTokenType) throws CardException;

	/**
	 * @return
	 */
	public ArrayList getSupportedClaimTypeList();

	/**
	 * @return
	 */
	public IDaoSupportedClaimType createSupportedClaimType();

	/**
	 * @param supportedClaimType
	 * @throws CardException
	 */
	public void addSupportedClaimType(IDaoSupportedClaimType supportedClaimType) throws CardException;

	/**
	 * @return
	 */
	public ArrayList getTokenServiceList();

	/**
	 * @return
	 */
	public IDaoTokenService createTokenService();

	/**
	 * @param tokenService
	 * @throws CardException
	 */
	public void addTokenService(IDaoTokenService tokenService) throws CardException;

	/**
	 * @return
	 */
	public String getIssuer();

	/**
	 * @param issuer
	 * @throws CardException
	 */
	public void setIssuer(String issuer) throws CardException;

	/**
	 * @return
	 */
	public String getIssuerName();

	/**
	 * @param issuerName
	 * @throws CardException
	 */
	public void setIssuerName(String issuerName) throws CardException;

}