/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.icard.provider.cardspace.db;

import org.eclipse.higgins.icard.CardException;

/**
 * Database access object which represents claims of cardspace-compatible
 * personal card (see cardspace techref)
 * 
 */
public interface IDaoPCardClaim extends IDAO {

	/**
	 * @return
	 */
	public int getCardID();

	/**
	 * @return
	 */
	public int getTypeID();

	/**
	 * @return
	 */
	public String getType();

	/**
	 * @param type
	 * @throws CardException
	 */
	public void setType(String type) throws CardException;

	/**
	 * @return
	 */
	public String getValue();

	/**
	 * @param value
	 * @throws CardException
	 */
	public void setValue(String value) throws CardException;

}