/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.icard.provider.cardspace.db;

import org.eclipse.higgins.icard.CardException;

/**
 * Database access object which represents supported claim type of
 * cardspace-compatible information card (see cardspace techref)
 * 
 */
public interface IDaoSupportedClaimType extends IDAO {

	/**
	 * @return
	 */
	public int getCardID();

	/**
	 * @return
	 */
	public int getTypeID();

	/**
	 * @return
	 */
	public String getType();

	/**
	 * @param type
	 * @throws CardException
	 */
	public void setType(String type) throws CardException;

	/**
	 * @return
	 */
	public String getTypeLocalName();

	/**
	 * @param typeLocalName
	 * @throws CardException
	 */
	public void setTypeLocalName(String typeLocalName) throws CardException;

	/**
	 * @return
	 */
	public String getDisplayName();

	/**
	 * @param displayName
	 * @throws CardException
	 */
	public void setDisplayName(String displayName) throws CardException;

	/**
	 * @return
	 */
	public String getDescription();

	/**
	 * @param description
	 * @throws CardException
	 */
	public void setDescription(String description) throws CardException;

}
