/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.entity.idas;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.IEndpointReference;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.ICredentialDescriptor;
import org.eclipse.higgins.icard.common.ClaimType;
import org.eclipse.higgins.icard.common.auth.SelfIssuedCredential;
import org.eclipse.higgins.icard.common.auth.UsernamePasswordCredential;
import org.eclipse.higgins.icard.provider.cardspace.common.CredentialDescriptor;
import org.eclipse.higgins.icard.provider.cardspace.common.EndpointReference;
import org.eclipse.higgins.icard.provider.cardspace.common.TokenService;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.CardEntity;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.Extension;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.MCardEntity;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.PCardEntity;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.SelfIssuedCardClaims;
import org.eclipse.higgins.icard.provider.cardspace.entity.idas.IdASContext;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAssertion;
import org.eclipse.higgins.idas.api.IFilterAttributeAssertion;
import org.eclipse.higgins.idas.api.IFilterEntityTypeAssertion;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IValue;
import org.eclipse.higgins.idas.api.IdASException;

public class CardHelper {
    private static Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$entity$idas$CardHelper == null ? (class$org$eclipse$higgins$icard$provider$cardspace$entity$idas$CardHelper = CardHelper.class$("org.eclipse.higgins.icard.provider.cardspace.entity.idas.CardHelper")) : class$org$eclipse$higgins$icard$provider$cardspace$entity$idas$CardHelper));
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$entity$idas$CardHelper;

    public static void initMCard(MCardEntity card, IEntity cardEntity) throws CardException, IdASException {
        CardHelper.initCard((CardEntity)card, cardEntity);
        card.setSupportedClaimTypeList((List)CardHelper.initClaimTypes(cardEntity));
        card.setRequireAppliesTo((Boolean)CardHelper.getSimpleValueData(cardEntity, IdASContext.ICARD_requireAppliesTo));
        card.setTokenServiceList((List)CardHelper.getTokenServiceList(cardEntity));
        CardHelper.initStsPolicy(card, cardEntity);
    }

    public static void initPCard(PCardEntity card, IEntity cardEntity) throws CardException, IdASException {
        CardHelper.initCard((CardEntity)card, cardEntity);
        card.setSupportedClaimTypeList((List)SelfIssuedCardClaims.getSupportedClaimTypeList());
        card.setPinDigest(CardHelper.getByte(cardEntity, IdASContext.ICARD_pinDigest));
        card.setRawClaims((Map)CardHelper.initPCardClaims(card, cardEntity));
    }

    private static HashMap initPCardClaims(PCardEntity card, IEntity cardEntity) throws CardException, IdASException {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        ISingleValuedAttribute claimListAttr = cardEntity.getSingleValuedAttribute(IdASContext.ICARD_claimValuesList);
        IEntity claimsList = (IEntity)claimListAttr.getValue();
        if (claimsList != null) {
            Iterator claimAttributes = claimsList.getAttributes();
            while (claimAttributes.hasNext()) {
                String claimValue;
                ISingleValuedAttribute svAttr = (ISingleValuedAttribute)claimAttributes.next();
                ISimpleValue sv = (ISimpleValue)svAttr.getValue();
                if (sv == null || (claimValue = (String)sv.getData()) == null) continue;
                String claimType = svAttr.getType().toString();
                valuesMap.put(claimType, claimValue);
            }
        }
        return valuesMap;
    }

    private static void initStsPolicy(MCardEntity card, IEntity cardEntity) throws IdASException, CardException {
        IEntity stsPolicy = (IEntity)cardEntity.getSingleValuedAttribute(IdASContext.ICARD_stsPrivacyPolicy).getValue();
        if (stsPolicy != null) {
            card.setPolicyURL((URI)CardHelper.getSimpleValueData(stsPolicy, IdASContext.ICARD_policyURL));
            card.setPolicyVersion((Integer)CardHelper.getSimpleValueData(stsPolicy, IdASContext.ICARD_policyVersion));
        }
    }

    private static ArrayList getTokenServiceList(IEntity card) throws IdASException, CardException {
        ArrayList<TokenService> tokenServices = new ArrayList<TokenService>();
        IAttribute attr = card.getAttribute(IdASContext.ICARD_tokenService);
        Iterator itr = attr.getValues();
        while (itr.hasNext()) {
            IValue val = (IValue)itr.next();
            if (val.isSimple()) continue;
            IEntity tokenService = (IEntity)val;
            EndpointReference endpoint = CardHelper.getEndpointReference(tokenService);
            CredentialDescriptor credential = CardHelper.getCredentialDescriptor(tokenService);
            TokenService tc = new TokenService(endpoint, credential);
            tokenServices.add(tc);
        }
        return tokenServices;
    }

    private static EndpointReference getEndpointReference(IEntity tokenService) throws IdASException, CardException {
        IEntity epr = (IEntity)tokenService.getSingleValuedAttribute(IdASContext.ICARD_endpointReference).getValue();
        URI epAddress = (URI)CardHelper.getSimpleValueData(epr, IdASContext.ICARD_address);
        URI epMetadata = (URI)CardHelper.getSimpleValueData(epr, IdASContext.ICARD_metadataAddress);
        byte[] epCert = CardHelper.getByte(epr, IdASContext.ICARD_certificate);
        return new EndpointReference(epAddress, epMetadata, epCert);
    }

    private static CredentialDescriptor getCredentialDescriptor(IEntity tokenService) throws CardException, IdASException {
        IEntity userCredentials = (IEntity)tokenService.getSingleValuedAttribute(IdASContext.ICARD_userCredential).getValue();
        UsernamePasswordCredential credential = null;
        String hint = (String)CardHelper.getSimpleValueData(userCredentials, IdASContext.ICARD_displayCredentialHint);
        String type = null;
        URI entityType = userCredentials.getType();
        if (IdASContext.ICARD_UsernamePasswordCredential.equals(entityType)) {
            type = "UsernamePasswordCredential";
            String username = (String)CardHelper.getSimpleValueData(userCredentials, IdASContext.ICARD_username);
            credential = new UsernamePasswordCredential(username);
        } else if (IdASContext.ICARD_SelfIssuedCredential.equals(entityType)) {
            type = "SelfIssuedCredential";
            byte[] ppid = CardHelper.getByte(userCredentials, IdASContext.ICARD_privatePersonalIdentifier);
            String ppidStr = Base64.encode((byte[])ppid);
            credential = new SelfIssuedCredential(ppidStr);
        } else if (IdASContext.ICARD_X509V3Credential.equals(entityType)) {
            type = "X509V3Credential";
            byte[] certificate = CardHelper.getByte(userCredentials, IdASContext.ICARD_x509Data);
            String certificateStr = Base64.encode((byte[])certificate);
            credential = new SelfIssuedCredential(certificateStr);
        } else {
            if (IdASContext.ICARD_KerberosV5Credential.equals(entityType)) {
                throw new CardException("Kerberos cedentials not implemented");
            }
            throw new CardException("Unexpected credentials type: " + entityType);
        }
        return new CredentialDescriptor(hint, type, (ICredential)credential);
    }

    public static void initPCardFromEntity(PCardEntity card, IEntity cardEntity) throws CardException, IdASException {
        CardHelper.initCard((CardEntity)card, cardEntity);
    }

    private static void initCard(CardEntity card, IEntity cardEntity) throws CardException, IdASException {
        card.setId((Object)cardEntity.getEntityID());
        card.setCardID((URI)CardHelper.getSimpleValueData(cardEntity, IdASContext.ICARD_cardId));
        card.setLanguage((String)CardHelper.getSimpleValueData(cardEntity, IdASContext.ICARD_langId));
        card.setName((String)CardHelper.getSimpleValueData(cardEntity, IdASContext.ICARD_cardName));
        card.setVersion(CardHelper.getInteger(cardEntity, IdASContext.ICARD_cardVersion));
        card.setIssuer((URI)CardHelper.getSimpleValueData(cardEntity, IdASContext.ICARD_issuer));
        card.setIssuerID(CardHelper.getByte(cardEntity, IdASContext.ICARD_issuerId));
        card.setIssuerName((String)CardHelper.getSimpleValueData(cardEntity, IdASContext.ICARD_issuerName));
        card.setImage(CardHelper.getByte(cardEntity, IdASContext.ICARD_image));
        card.setImageType((String)CardHelper.getSimpleValueData(cardEntity, IdASContext.ICARD_imageType));
        card.setTimeIssued((Date)CardHelper.getSimpleValueData(cardEntity, IdASContext.ICARD_timeIssued));
        card.setTimeExpires((Date)CardHelper.getSimpleValueData(cardEntity, IdASContext.ICARD_timeExpired));
        card.setTimeLastUpdated((Date)CardHelper.getSimpleValueData(cardEntity, IdASContext.ICARD_timeLastUpdated));
        card.setHashSalt(CardHelper.getByte(cardEntity, IdASContext.ICARD_hashSalt));
        card.setMasterKey(CardHelper.getByte(cardEntity, IdASContext.ICARD_masterKey));
        card.setSupportedTokenTypeList((List)CardHelper.initSupportedTokenTypes(cardEntity));
        card.setExtensionList(CardHelper.initExtensions(cardEntity));
    }

    private static List initExtensions(IEntity cardEntity) throws CardException, IdASException {
        ArrayList<Extension> exts = new ArrayList<Extension>();
        IAttribute extAttr = cardEntity.getAttribute(IdASContext.ICARD_extension);
        Iterator extensionItr = extAttr.getValues();
        while (extensionItr.hasNext()) {
            IEntity extension = (IEntity)extensionItr.next();
            exts.add(CardHelper.initExtension(extension));
        }
        return exts;
    }

    private static Extension initExtension(IEntity extension) throws CardException {
        Extension ext = new Extension();
        ext.setExtensionData((String)CardHelper.getSimpleValueData(extension, IdASContext.ICARD_extensionData));
        Boolean isEnbld = (Boolean)CardHelper.getSimpleValueData(extension, IdASContext.ICARD_extensionEnabled);
        ext.setEnabled(isEnbld != null ? isEnbld : true);
        return ext;
    }

    private static ArrayList initSupportedTokenTypes(IEntity card) throws IdASException, CardException {
        ArrayList<Object> supportedTokenTypes = new ArrayList<Object>();
        IAttribute attr = card.getAttribute(IdASContext.ICARD_supportedTokenType);
        Iterator itr = attr.getValues();
        while (itr.hasNext()) {
            IValue val = (IValue)itr.next();
            if (val.isSimple()) {
                Object obj;
                ISimpleValue sv = (ISimpleValue)val;
                if (sv == null || (obj = sv.getData()) == null) continue;
                supportedTokenTypes.add(obj);
                continue;
            }
            throw new CardException("Attribute " + IdASContext.ICARD_supportedTokenType + " contains non simple value.");
        }
        return supportedTokenTypes;
    }

    private static ArrayList initClaimTypes(IEntity card) throws IdASException, CardException {
        ArrayList<ClaimType> claimTypes = new ArrayList<ClaimType>();
        IAttribute attr = card.getAttribute(IdASContext.ICARD_supportedClaimType);
        Iterator itr = attr.getValues();
        while (itr.hasNext()) {
            IEntity cv;
            IValue val = (IValue)itr.next();
            if (val.isSimple() || (cv = (IEntity)val) == null) continue;
            URI type = (URI)CardHelper.getSimpleValueData(cv, IdASContext.ICARD_claimURI);
            String typeStr = type != null ? type.toString() : "";
            String name = (String)CardHelper.getSimpleValueData(cv, IdASContext.ICARD_claimTypeName);
            String description = (String)CardHelper.getSimpleValueData(cv, IdASContext.ICARD_claimTypeDescription);
            boolean isPPID = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier".equals(typeStr);
            ClaimType ct = new ClaimType(typeStr, name, description, !isPPID, !isPPID);
            claimTypes.add(ct);
        }
        return claimTypes;
    }

    private static Object getSimpleValueData(IEntity subj, URI attribureType) throws CardException {
        try {
            ISingleValuedAttribute attr = subj.getSingleValuedAttribute(attribureType);
            return CardHelper.getSimpleValueData(attr);
        }
        catch (IdASException e) {
            log.error((Object)e, (Throwable)e);
            throw new CardException((Throwable)e);
        }
    }

    private static byte[] getByte(IEntity subj, URI attribureType) throws CardException {
        try {
            ByteBuffer val = (ByteBuffer)CardHelper.getSimpleValueData(subj, attribureType);
            return val != null ? val.array() : null;
        }
        catch (ClassCastException e) {
            log.error((Object)e, (Throwable)e);
            throw new CardException("Attribute is not string : " + attribureType.toString());
        }
    }

    private static int getInteger(IEntity subj, URI attribureType) throws CardException {
        try {
            Integer val = (Integer)CardHelper.getSimpleValueData(subj, attribureType);
            return val != null ? val : 0;
        }
        catch (ClassCastException e) {
            log.error((Object)e, (Throwable)e);
            throw new CardException("Attribute is not string : " + attribureType.toString());
        }
    }

    private static Object getSimpleValueData(ISingleValuedAttribute attr) throws IdASException, CardException {
        IValue v;
        if (attr != null && (v = attr.getValue()) != null) {
            if (v.isSimple()) {
                ISimpleValue sv = (ISimpleValue)v;
                return sv.getData();
            }
            throw new CardException("Attribute " + (attr.getType() != null ? attr.getType().toString() : "") + " is complex.");
        }
        return null;
    }

    public static void saveMCard(MCardEntity card, IEntity cardEntity, boolean useFilterApi) throws CardException, IdASException {
        CardHelper.saveCard((CardEntity)card, cardEntity);
        CardHelper.setSimpleValueData(cardEntity, IdASContext.ICARD_requireAppliesTo, card.getRequireAppliesTo());
        CardHelper.savePrivacyPolicy(card, cardEntity);
        CardHelper.saveTokenServiceList(card, cardEntity);
        CardHelper.saveSupportedTokenList((CardEntity)card, cardEntity);
        CardHelper.saveSupportedClaimTypeList((CardEntity)card, cardEntity, useFilterApi);
    }

    public static void savePCard(PCardEntity card, IEntity cardEntity) throws CardException, IdASException {
        CardHelper.saveCard((CardEntity)card, cardEntity);
        CardHelper.setSimpleValueData(cardEntity, IdASContext.ICARD_pinDigest, card.getPinDigest());
        CardHelper.savePCardClaims(card, cardEntity);
    }

    public static void savePCardClaims(PCardEntity card, IEntity cardEntity) throws CardException, IdASException {
        ISingleValuedAttribute claimListAttr = cardEntity.getSingleValuedAttribute(IdASContext.ICARD_claimValuesList);
        IEntity claimsList = (IEntity)claimListAttr.getValue();
        if (claimsList == null) {
            claimsList = claimListAttr.addComplexValue(IdASContext.ICARD_PCardClaims);
        }
        Iterator attrs = claimsList.getAttributes();
        Map claims = card.getRawClaims();
        while (attrs.hasNext()) {
            IAttribute claimAttr = (IAttribute)attrs.next();
            String claimType = claimAttr.getType().toString();
            if (!claims.containsKey(claimType)) continue;
            String value = (String)claims.get(claimType);
            claimAttr.addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)value);
        }
    }

    public static void saveTokenServiceList(MCardEntity card, IEntity cardEntity) throws CardException, IdASException {
        IAttribute tokenServiceAttr = cardEntity.getAttribute(IdASContext.ICARD_tokenService);
        tokenServiceAttr.remove();
        List tsList = card.getTokenServiceList();
        if (tsList != null) {
            Iterator tsItr = tsList.iterator();
            while (tsItr.hasNext()) {
                TokenService tokenService = (TokenService)tsItr.next();
                IEntity tsEntity = tokenServiceAttr.addComplexValue(IdASContext.ICARD_TokenService);
                CardHelper.saveTokenService(tokenService, tsEntity);
            }
        }
    }

    private static void saveTokenService(TokenService tokenService, IEntity tsEntity) throws CardException, IdASException {
        CardHelper.saveEndpointReference(tokenService.getEndpointReference(), tsEntity);
        CardHelper.saveUserCredential(tokenService.getUserCredential(), tsEntity);
    }

    private static void saveEndpointReference(IEndpointReference endpointReference, IEntity tokenServiceEntity) throws CardException, IdASException {
        byte[] certificate;
        IEntity eprEntity = tokenServiceEntity.addAttribute(IdASContext.ICARD_endpointReference).addComplexValue(IdASContext.ICARD_EndpointReference);
        CardHelper.setSimpleValueData(eprEntity, IdASContext.ICARD_address, endpointReference.getAddress());
        CardHelper.setSimpleValueData(eprEntity, IdASContext.ICARD_metadataAddress, endpointReference.getMetadataAddress());
        try {
            certificate = endpointReference.getCertificate().getEncoded();
        }
        catch (CertificateEncodingException e) {
            log.error((Object)e, (Throwable)e);
            throw new CardException((Throwable)e);
        }
        CardHelper.setSimpleValueData(eprEntity, IdASContext.ICARD_certificate, certificate);
    }

    private static void saveUserCredential(ICredentialDescriptor credentialDescriptor, IEntity tokenServiceEntity) throws CardException, IdASException {
        IAttribute credentialAttr = tokenServiceEntity.addAttribute(IdASContext.ICARD_userCredential);
        IEntity credentialEntity = null;
        String type = credentialDescriptor.getType();
        if (type.equals("UsernamePasswordCredential")) {
            UsernamePasswordCredential upCred = (UsernamePasswordCredential)credentialDescriptor.getCredential();
            credentialEntity = credentialAttr.addComplexValue(IdASContext.ICARD_UsernamePasswordCredential);
            CardHelper.setSimpleValueData(credentialEntity, IdASContext.ICARD_username, upCred.getUsername());
        } else if (type.equals("SelfIssuedCredential")) {
            SelfIssuedCredential siCred = (SelfIssuedCredential)credentialDescriptor.getCredential();
            String ppidStr = siCred.getPPID();
            byte[] ppid = Base64.decode((String)ppidStr);
            credentialEntity = credentialAttr.addComplexValue(IdASContext.ICARD_SelfIssuedCredential);
            CardHelper.setSimpleValueData(credentialEntity, IdASContext.ICARD_privatePersonalIdentifier, ppid);
        } else if (type.equals("X509V3Credential")) {
            SelfIssuedCredential x509cred = (SelfIssuedCredential)credentialDescriptor.getCredential();
            byte[] certificate = Base64.decode((String)x509cred.getPPID());
            credentialEntity = credentialAttr.addComplexValue(IdASContext.ICARD_X509V3Credential);
            CardHelper.setSimpleValueData(credentialEntity, IdASContext.ICARD_x509Data, certificate);
        } else {
            if (type.equals("KerberosV5Credential")) {
                throw new CardException("Kerberos cedentials not implemented");
            }
            throw new CardException("Unexpected credentials type: " + type);
        }
        CardHelper.setSimpleValueData(credentialEntity, IdASContext.ICARD_displayCredentialHint, credentialDescriptor.getDisplayCredentialHint());
    }

    public static void savePrivacyPolicy(MCardEntity card, IEntity cardEntity) throws CardException, IdASException {
        ISingleValuedAttribute stsPolicyAttr = cardEntity.getSingleValuedAttribute(IdASContext.ICARD_stsPrivacyPolicy);
        IEntity stsPolicy = stsPolicyAttr.addComplexValue(IdASContext.ICARD_STSPrivacyPolicy);
        CardHelper.setSimpleValueData(stsPolicy, IdASContext.ICARD_policyURL, card.getPolicyURL());
        CardHelper.setSimpleValueData(stsPolicy, IdASContext.ICARD_policyVersion, card.getPolicyVersion(), ITypedValue.POSITIVEINTEGER_TYPE_URI);
    }

    public static void saveCard(CardEntity card, IEntity cardEntity) throws CardException, IdASException {
        CardHelper.setSimpleValueData(cardEntity, IdASContext.ICARD_cardId, card.getCardID());
        CardHelper.setSimpleValueData(cardEntity, IdASContext.ICARD_langId, card.getLanguage());
        CardHelper.setSimpleValueData(cardEntity, IdASContext.ICARD_cardName, card.getName());
        CardHelper.setSimpleValueData(cardEntity, IdASContext.ICARD_cardVersion, new Integer(card.getVersion()), ITypedValue.POSITIVEINTEGER_TYPE_URI);
        CardHelper.setSimpleValueData(cardEntity, IdASContext.ICARD_issuer, card.getIssuer());
        CardHelper.setSimpleValueData(cardEntity, IdASContext.ICARD_issuerId, card.getIssuerID());
        CardHelper.setSimpleValueData(cardEntity, IdASContext.ICARD_issuerName, card.getIssuerName());
        CardHelper.setSimpleValueData(cardEntity, IdASContext.ICARD_image, card.getImage());
        CardHelper.setSimpleValueData(cardEntity, IdASContext.ICARD_imageType, card.getImageType());
        CardHelper.setSimpleValueData(cardEntity, IdASContext.ICARD_timeIssued, card.getTimeIssued());
        CardHelper.setSimpleValueData(cardEntity, IdASContext.ICARD_timeExpired, card.getTimeExpires());
        CardHelper.setSimpleValueData(cardEntity, IdASContext.ICARD_timeLastUpdated, card.getTimeLastUpdated());
        CardHelper.setSimpleValueData(cardEntity, IdASContext.ICARD_hashSalt, card.getHashSalt());
        CardHelper.setSimpleValueData(cardEntity, IdASContext.ICARD_masterKey, card.getMasterKey());
        CardHelper.saveExtension(card.getExtensionList(), cardEntity);
    }

    private static boolean areStringsEqual(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        return !(s1 == null && s2 != null || s1 != null && s2 == null || !s1.equals(s2));
    }

    private static boolean areDatesEqual(Date d1, Date d2) {
        if (d1 == null && d2 == null) {
            return true;
        }
        return !(d1 == null && d2 != null || d1 != null && d2 == null || !d1.equals(d2));
    }

    public static void updateMCard(MCardEntity card, IEntity cardEntity) throws CardException, IdASException {
        CardHelper.updateCard((CardEntity)card, cardEntity);
    }

    public static void updatePCard(PCardEntity card, IEntity cardEntity) throws CardException, IdASException {
        CardHelper.updateCard((CardEntity)card, cardEntity);
        CardHelper.savePCardClaims(card, cardEntity);
        byte[] oldPinDigest = CardHelper.getByte(cardEntity, IdASContext.ICARD_pinDigest);
        byte[] newPinDigest = card.getPinDigest();
        byte[] oldMasterKey = CardHelper.getByte(cardEntity, IdASContext.ICARD_masterKey);
        byte[] newMasterKey = card.getMasterKey();
        if (!Arrays.equals(oldPinDigest, newPinDigest)) {
            CardHelper.setSimpleValueData(cardEntity, IdASContext.ICARD_pinDigest, newPinDigest);
        }
        if (!Arrays.equals(oldMasterKey, newMasterKey)) {
            CardHelper.setSimpleValueData(cardEntity, IdASContext.ICARD_masterKey, newMasterKey);
        }
    }

    private static void updateCard(CardEntity card, IEntity cardEntity) throws CardException, IdASException {
        String oldCardName = (String)CardHelper.getSimpleValueData(cardEntity, IdASContext.ICARD_cardName);
        String newCardName = card.getName();
        String oldIssuerName = (String)CardHelper.getSimpleValueData(cardEntity, IdASContext.ICARD_issuerName);
        String newIssuerName = card.getIssuerName();
        byte[] oldImage = CardHelper.getByte(cardEntity, IdASContext.ICARD_image);
        byte[] newImage = card.getImage();
        String oldImageType = (String)CardHelper.getSimpleValueData(cardEntity, IdASContext.ICARD_imageType);
        String newImageType = card.getImageType();
        Date oldLastUpdate = (Date)CardHelper.getSimpleValueData(cardEntity, IdASContext.ICARD_timeLastUpdated);
        Date newLastUpdate = card.getTimeLastUpdated();
        if (!CardHelper.areStringsEqual(oldCardName, newCardName)) {
            CardHelper.setSimpleValueData(cardEntity, IdASContext.ICARD_cardName, newCardName);
        }
        if (!CardHelper.areStringsEqual(oldIssuerName, newIssuerName)) {
            CardHelper.setSimpleValueData(cardEntity, IdASContext.ICARD_issuerName, newIssuerName);
        }
        if (!Arrays.equals(oldImage, newImage)) {
            CardHelper.setSimpleValueData(cardEntity, IdASContext.ICARD_image, newImage);
        }
        if (!CardHelper.areStringsEqual(oldImageType, newImageType)) {
            CardHelper.setSimpleValueData(cardEntity, IdASContext.ICARD_imageType, newImageType);
        }
        if (!CardHelper.areDatesEqual(oldLastUpdate, newLastUpdate)) {
            CardHelper.setSimpleValueData(cardEntity, IdASContext.ICARD_timeLastUpdated, newLastUpdate);
        }
        CardHelper.saveExtension(card.getExtensionList(), cardEntity);
    }

    private static void saveSupportedTokenList(CardEntity card, IEntity cardEntity) throws IdASException {
        IAttribute attr = cardEntity.addAttribute(IdASContext.ICARD_supportedTokenType);
        Iterator supportedTokenItr = card.getSupportedTokenTypeList().iterator();
        while (supportedTokenItr.hasNext()) {
            URI type = (URI)supportedTokenItr.next();
            attr.addSimpleValue(ITypedValue.ANYURI_TYPE_URI, (Object)type);
        }
    }

    private static IEntity getClaimType(IContext context, String claimType, boolean useFilterApi) throws IdASException, CardException {
        Iterator itr = null;
        if (useFilterApi) {
            IFilter filter = context.buildFilter();
            filter.setOperator("urn:eclipse.higgins.idas.OP_AND");
            IFilterEntityTypeAssertion typeAssertion = context.buildEntityTypeAssertion();
            typeAssertion.setAssertionValue(IdASContext.ICARD_ClaimType);
            filter.addFilter((IFilterAssertion)typeAssertion);
            IFilterAttributeAssertion fas = context.buildAttributeAssertion();
            fas.includeSubtypes(true);
            fas.setComparator("urn:org.eclipse.higgins.idas.api.comparator.attribute.equality");
            fas.setID(IdASContext.ICARD_claimTypeName);
            ISimpleValue val = context.buildSimpleAttrValue(ITypedValue.STRING_TYPE_URI, (Object)claimType);
            fas.setAssertionValue((IValue)val);
            filter.addFilter((IFilterAssertion)fas);
            itr = context.getEntities(filter);
        } else {
            String query = "PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> \nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX icard: <http://www.eclipse.org/higgins/ontologies/2009/4/i-card.owl#> \nSELECT ?subj WHERE { ?subj rdf:type <" + IdASContext.ICARD_claimURI.toString() + "> .\n" + "?subj <" + IdASContext.ICARD_claimTypeName + "> ?type .\n" + "FILTER (?type = \"" + claimType + "\"^^xsd:anyURI ) }";
            itr = context.getEntities(query);
        }
        if (itr.hasNext()) {
            return (IEntity)itr.next();
        }
        return null;
    }

    private static IEntity addClaimType(IContext context, ClaimType claimType) throws IdASException, CardException {
        String claimTypeStr = claimType.getType();
        URI claimTypeURI = null;
        try {
            claimTypeURI = new URI(claimTypeStr);
        }
        catch (URISyntaxException e) {
            log.error((Object)e, (Throwable)e);
            throw new CardException((Throwable)e);
        }
        IEntity ct = context.addEntity(IdASContext.ICARD_ClaimType, null);
        CardHelper.setSimpleValueData(ct, IdASContext.ICARD_claimURI, claimTypeURI);
        CardHelper.setSimpleValueData(ct, IdASContext.ICARD_claimTypeName, claimType.getDisplayName());
        CardHelper.setSimpleValueData(ct, IdASContext.ICARD_claimTypeDescription, claimType.getDescription());
        return ct;
    }

    private static void saveSupportedClaimTypeList(CardEntity card, IEntity cardEntity, boolean useFilterApi) throws IdASException, CardException {
        IContext context = cardEntity.getContext();
        IAttribute attr = cardEntity.addAttribute(IdASContext.ICARD_supportedClaimType);
        Iterator supportedClaimTypeItr = card.getSupportedClaimTypeList().iterator();
        while (supportedClaimTypeItr.hasNext()) {
            ClaimType claimType = (ClaimType)supportedClaimTypeItr.next();
            IEntity ctEntity = CardHelper.getClaimType(context, claimType.getType(), useFilterApi);
            if (ctEntity == null) {
                ctEntity = CardHelper.addClaimType(context, claimType);
            }
            attr.addValue((IValue)ctEntity);
        }
    }

    private static void saveExtension(List extensions, IEntity cardEntity) throws IdASException {
        IAttribute extAttr = cardEntity.getAttribute(IdASContext.ICARD_extension);
        extAttr.remove();
        if (extensions != null) {
            Iterator itr = extensions.iterator();
            while (itr.hasNext()) {
                Extension ext = (Extension)itr.next();
                IEntity extEntity = extAttr.addComplexValue(IdASContext.ICARD_Extension);
                CardHelper.saveExtension(ext, extEntity);
            }
        }
    }

    private static void saveExtension(Extension extension, IEntity extensionEntity) throws IdASException {
        CardHelper.setSimpleValueData(extensionEntity, IdASContext.ICARD_extensionData, extension.getExtensionData());
        CardHelper.setSimpleValueData(extensionEntity, IdASContext.ICARD_extensionEnabled, new Boolean(extension.isEnabled()));
    }

    private static void setSimpleValueData(IEntity subj, URI attribureType, String value) throws IdASException {
        ISingleValuedAttribute attr = subj.getSingleValuedAttribute(attribureType);
        attr.addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)value);
    }

    private static void setSimpleValueData(IEntity subj, URI attribureType, URI value) throws IdASException {
        ISingleValuedAttribute attr = subj.getSingleValuedAttribute(attribureType);
        attr.addSimpleValue(ITypedValue.ANYURI_TYPE_URI, (Object)value);
    }

    private static void setSimpleValueData(IEntity subj, URI attribureType, byte[] value) throws IdASException {
        ByteBuffer bb = null;
        if (value != null) {
            bb = ByteBuffer.wrap(value);
        }
        ISingleValuedAttribute attr = subj.getSingleValuedAttribute(attribureType);
        attr.addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)bb);
    }

    private static void setSimpleValueData(IEntity subj, URI attribureType, Boolean value) throws IdASException {
        ISingleValuedAttribute attr = subj.getSingleValuedAttribute(attribureType);
        attr.addSimpleValue(ITypedValue.BOOLEAN_TYPE_URI, (Object)value);
    }

    private static void setSimpleValueData(IEntity subj, URI attribureType, Integer value) throws IdASException {
        ISingleValuedAttribute attr = subj.getSingleValuedAttribute(attribureType);
        attr.addSimpleValue(ITypedValue.INTEGER_TYPE_URI, (Object)value);
    }

    private static void setSimpleValueData(IEntity subj, URI attribureType, Integer value, URI valueType) throws IdASException {
        ISingleValuedAttribute attr = subj.getSingleValuedAttribute(attribureType);
        attr.addSimpleValue(valueType, (Object)value);
    }

    private static void setSimpleValueData(IEntity subj, URI attribureType, Date value) throws IdASException {
        ISingleValuedAttribute attr = subj.getSingleValuedAttribute(attribureType);
        attr.addSimpleValue(ITypedValue.DATETIME_TYPE_URI, (Object)value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

