/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.entity.idas;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.cache.CacheProviderFactory;
import org.eclipse.higgins.cache.api.ICache;
import org.eclipse.higgins.cache.api.ICacheKey;
import org.eclipse.higgins.cache.api.key.CacheKey;
import org.eclipse.higgins.configuration.api.IConfigurableComponent;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.IPCardManagedBean;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.IUserCredentials;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.PCardEntity;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.UsernamePasswordCredentials;
import org.eclipse.higgins.icard.provider.cardspace.entity.idas.CardHelper;
import org.eclipse.higgins.icard.provider.cardspace.entity.idas.IdASContext;
import org.eclipse.higgins.idas.api.IAuthNMaterials;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.eclipse.higgins.idas.registry.IdASRegistry;
import org.eclipse.higgins.idas.registry.contextid.ContextIdFactory;
import org.eclipse.higgins.idas.registry.discovery.FileDiscovery;
import org.eclipse.higgins.idas.registry.discovery.IDiscovery;

public class PCardManagedBean
implements IPCardManagedBean,
IConfigurableComponent {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$entity$idas$PCardManagedBean == null ? (class$org$eclipse$higgins$icard$provider$cardspace$entity$idas$PCardManagedBean = PCardManagedBean.class$("org.eclipse.higgins.icard.provider.cardspace.entity.idas.PCardManagedBean")) : class$org$eclipse$higgins$icard$provider$cardspace$entity$idas$PCardManagedBean));
    private boolean isConfigured = false;
    private IdASRegistry registry;
    private static ICache cardCache = CacheProviderFactory.getCacheProvider().getCache("pcard.idas");
    private static boolean isNoCache = true;
    private IContextId contextId;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$entity$idas$PCardManagedBean;

    public synchronized void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, ISettingDescriptor componentDescriptor, ISettingDescriptor globalDescriptor) throws CardException, IdASException {
        this.isConfigured = false;
        this.init(mapComponentSettings);
        this.isConfigured = true;
    }

    private void addCard(PCardEntity card, IUserCredentials credentials) throws CardException {
        this.addCardToContext(card, credentials);
        this.addCardToCache(card, credentials);
    }

    private void addCardToContext(PCardEntity card, IUserCredentials credentials) throws CardException {
        IContext ctx = null;
        IAuthNMaterials authMaterials = PCardManagedBean.buildAuthMaterials(credentials);
        try {
            ctx = this.registry.createContext(this.contextId);
            ctx.open(authMaterials);
            IEntity cardEntity = ctx.addEntity(IdASContext.ICARD_PCard, null);
            CardHelper.savePCard(card, cardEntity);
            ctx.applyUpdates();
            card.setId((Object)cardEntity.getEntityID());
        }
        catch (IdASException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new CardException((Throwable)e);
        }
        finally {
            try {
                if (ctx != null && ctx.isOpen(null)) {
                    ctx.close();
                }
            }
            catch (IdASException e) {
                this.log.error((Object)e, (Throwable)e);
                throw new CardException((Throwable)e);
            }
        }
    }

    private void addCardToCache(PCardEntity card, IUserCredentials credentials) throws CardException {
        CacheKey cacheKey;
        HashMap cacheCards;
        if (!isNoCache && (cacheCards = this.getPCardsFromCache(cacheKey = this.buildCacheKey(credentials))) != null) {
            cacheCards.put(card.getCardID().toString(), card);
        }
    }

    public PCardEntity getPCard(String cardID, IUserCredentials credentials) throws CardException {
        if (cardID == null) {
            throw new CardException("Parameter \"cardID\" is null");
        }
        if (credentials == null) {
            throw new CardException("Parameter \"credentials\" is null");
        }
        HashMap userCards = this.getCards(credentials);
        if (userCards.containsKey(cardID)) {
            return (PCardEntity)userCards.get(cardID);
        }
        return null;
    }

    public List getPCards(IUserCredentials credentials) throws CardException {
        if (credentials == null) {
            throw new CardException("Parameter \"credentials\" is null");
        }
        HashMap userCards = this.getCards(credentials);
        ArrayList<PCardEntity> res = new ArrayList<PCardEntity>();
        Iterator itr = userCards.values().iterator();
        while (itr.hasNext()) {
            PCardEntity mc = (PCardEntity)itr.next();
            res.add(mc);
        }
        return res;
    }

    private HashMap getCards(IUserCredentials credentials) throws CardException {
        CacheKey cacheKey = this.buildCacheKey(credentials);
        HashMap cards = this.getPCardsFromCache(cacheKey);
        if (cards == null) {
            IAuthNMaterials authMaterials = PCardManagedBean.buildAuthMaterials(credentials);
            cards = this.getPCardsFromContext(authMaterials, cacheKey);
        }
        return cards;
    }

    private void updateCard(PCardEntity card, IUserCredentials credentials) throws CardException {
        String entityId = (String)card.getId();
        IContext ctx = null;
        IAuthNMaterials authMaterials = PCardManagedBean.buildAuthMaterials(credentials);
        try {
            ctx = this.registry.createContext(this.contextId);
            ctx.open(authMaterials);
            IEntity cardEntity = ctx.getEntity(entityId);
            CardHelper.updatePCard(card, cardEntity);
            ctx.applyUpdates();
        }
        catch (IdASException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new CardException((Throwable)e);
        }
        finally {
            try {
                if (ctx != null && ctx.isOpen(null)) {
                    ctx.close();
                }
            }
            catch (IdASException e) {
                this.log.error((Object)e, (Throwable)e);
                throw new CardException((Throwable)e);
            }
        }
    }

    private HashMap getPCardsFromCache(CacheKey cacheKey) throws CardException {
        if (isNoCache) {
            if (!cardCache.isKeyInCache((ICacheKey)cacheKey)) {
                return null;
            }
            return (HashMap)cardCache.get((ICacheKey)cacheKey);
        }
        return null;
    }

    private synchronized HashMap getPCardsFromContext(IAuthNMaterials authentication, CacheKey key) throws CardException {
        HashMap<String, PCardEntity> cards = this.getPCardsFromCache(key);
        if (cards != null) {
            return cards;
        }
        cards = new HashMap<String, PCardEntity>();
        IContext ctx = null;
        try {
            ctx = this.registry.createContext(this.contextId);
            ctx.open(authentication);
            String query = "SELECT ?subj WHERE { ?subj <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <" + IdASContext.ICARD_PCard.toString() + "> }";
            Iterator cardEntities = ctx.getEntities(query);
            while (cardEntities.hasNext()) {
                IEntity entity = (IEntity)cardEntities.next();
                PCardEntity me = new PCardEntity();
                CardHelper.initPCard(me, entity);
                cards.put(me.getCardID().toString(), me);
            }
        }
        catch (IdASException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new CardException((Throwable)e);
        }
        finally {
            try {
                if (ctx != null && ctx.isOpen(null)) {
                    ctx.close();
                }
            }
            catch (IdASException e) {
                this.log.error((Object)e, (Throwable)e);
                throw new CardException((Throwable)e);
            }
        }
        if (!isNoCache) {
            cardCache.put((ICacheKey)key, cards);
        }
        return cards;
    }

    protected IContext getContext() throws IdASException, CardException {
        if (!this.isConfigured) {
            throw new CardException("IdAS based managed bean was not configured");
        }
        IContext ctx = this.registry.createContext(this.contextId);
        return ctx;
    }

    private static IAuthNMaterials buildAuthMaterials(IUserCredentials credentials) throws CardException {
        if (!(credentials instanceof UsernamePasswordCredentials)) {
            throw new CardException();
        }
        UsernamePasswordCredentials upc = (UsernamePasswordCredentials)credentials;
        AuthNNamePasswordMaterials authMaterials = new AuthNNamePasswordMaterials(upc.getUsername(), upc.getPassword());
        return authMaterials;
    }

    private CacheKey buildCacheKey(IUserCredentials credentials) throws CardException {
        String password;
        String userName;
        String cacheKey = null;
        if (credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials upc = (UsernamePasswordCredentials)credentials;
            userName = upc.getUsername();
            password = upc.getPassword();
            if (userName == null) {
                throw new CardException("User name is null.");
            }
        } else {
            throw new CardException();
        }
        cacheKey = userName.trim();
        cacheKey = cacheKey + " ";
        cacheKey = cacheKey + (password != null ? password : "emptyPassword");
        return new CacheKey(cacheKey);
    }

    public void init(Map config) throws CardException {
        this.registry = IdASRegistry.getInstance();
        String discoveryFile = (String)config.get("discovery.filename");
        if (discoveryFile != null) {
            FileDiscovery factories = new FileDiscovery(new File(discoveryFile));
            this.registry.setDiscovery((IDiscovery)factories);
        }
        String contextIdStr = (String)config.get("contextId");
        try {
            this.contextId = ContextIdFactory.fromString((String)contextIdStr);
        }
        catch (IdASException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new CardException((Throwable)e);
        }
    }

    public ISettingDescriptor getComponentDescriptor() {
        return null;
    }

    public void persistPCard(PCardEntity card, IUserCredentials credentials) throws CardException {
        if (card == null) {
            throw new CardException("Parameter \"card\" is null");
        }
        if (credentials == null) {
            throw new CardException("Parameter \"credentials\" is null");
        }
        if (card.getId() == null) {
            this.addCard(card, credentials);
        } else {
            this.updateCard(card, credentials);
        }
    }

    public void deletePCard(String cardID, IUserCredentials credentials) throws CardException {
        if (cardID == null) {
            throw new CardException("Parameter \"cardID\" is null");
        }
        if (credentials == null) {
            throw new CardException("Parameter \"credentials\" is null");
        }
        PCardEntity card = this.getPCard(cardID, credentials);
        this.removeCardFromContext(card, credentials);
        this.removeCardFromCache(card, credentials);
    }

    private void removeCardFromContext(PCardEntity card, IUserCredentials credentials) throws CardException {
        IContext ctx = null;
        IAuthNMaterials authMaterials = PCardManagedBean.buildAuthMaterials(credentials);
        String entityId = (String)card.getId();
        if (entityId == null) {
            throw new CardException("Card entity contains no entity id.");
        }
        try {
            ctx = this.registry.createContext(this.contextId);
            ctx.open(authMaterials);
            IEntity entity = ctx.getEntity(entityId);
            entity.remove();
            ctx.applyUpdates();
        }
        catch (IdASException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new CardException((Throwable)e);
        }
        finally {
            try {
                if (ctx != null && ctx.isOpen(null)) {
                    ctx.close();
                }
            }
            catch (IdASException e) {
                this.log.error((Object)e, (Throwable)e);
                throw new CardException((Throwable)e);
            }
        }
    }

    private void removeCardFromCache(PCardEntity card, IUserCredentials credentials) throws CardException {
        CacheKey cacheKey;
        HashMap cacheCards;
        if (!isNoCache && (cacheCards = this.getPCardsFromCache(cacheKey = this.buildCacheKey(credentials))) != null) {
            String cardId = card.getCardID().toString();
            cacheCards.remove(cardId);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

