/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.entity.idas;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.cache.CacheProviderFactory;
import org.eclipse.higgins.cache.api.ICache;
import org.eclipse.higgins.cache.api.ICacheKey;
import org.eclipse.higgins.cache.api.key.CacheKey;
import org.eclipse.higgins.configuration.api.IConfigurableComponent;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.IMCardManagedBean;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.IUserCredentials;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.MCardEntity;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.UsernamePasswordCredentials;
import org.eclipse.higgins.icard.provider.cardspace.entity.idas.CardHelper;
import org.eclipse.higgins.icard.provider.cardspace.entity.idas.IdASContext;
import org.eclipse.higgins.idas.api.IAuthNMaterials;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAssertion;
import org.eclipse.higgins.idas.api.IFilterEntityTypeAssertion;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.eclipse.higgins.idas.registry.IdASRegistry;
import org.eclipse.higgins.idas.registry.contextid.ContextIdFactory;
import org.eclipse.higgins.idas.registry.discovery.FileDiscovery;
import org.eclipse.higgins.idas.registry.discovery.IDiscovery;

public class MCardManagedBean
implements IMCardManagedBean,
IConfigurableComponent {
    private Log log;
    private boolean isConfigured;
    private IdASRegistry registry;
    private static ICache cardCache = CacheProviderFactory.getCacheProvider().getCache("mcard.idas");
    private static boolean isNoCache = true;
    private boolean useFilterApi;
    private IContextId contextId;
    static /* synthetic */ Class class$0;

    public MCardManagedBean() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.icard.provider.cardspace.entity.idas.MCardManagedBean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
        this.isConfigured = false;
        this.useFilterApi = false;
    }

    public synchronized void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, ISettingDescriptor componentDescriptor, ISettingDescriptor globalDescriptor) throws CardException, IdASException {
        this.isConfigured = false;
        this.init(mapComponentSettings);
        this.isConfigured = true;
    }

    private void addCard(MCardEntity card, IUserCredentials credentials) throws CardException {
        this.addCardToContext(card, credentials);
        this.addCardToCache(card, credentials);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addCardToContext(MCardEntity card, IUserCredentials credentials) throws CardException {
        IContext ctx = null;
        IAuthNMaterials authMaterials = MCardManagedBean.buildAuthMaterials(credentials);
        try {
            try {
                ctx = this.registry.createContext(this.contextId);
                ctx.open(authMaterials);
                IEntity cardEntity = ctx.addEntity(IdASContext.ICARD_MCard, null);
                CardHelper.saveMCard(card, cardEntity, this.useFilterApi);
                ctx.applyUpdates();
                card.setId((Object)cardEntity.getEntityID());
            }
            catch (IdASException e) {
                this.log.error((Object)e, (Throwable)e);
                throw new CardException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (ctx == null) throw throwable;
                if (!ctx.isOpen(null)) throw throwable;
                ctx.close();
                throw throwable;
            }
            catch (IdASException e) {
                this.log.error((Object)e, (Throwable)e);
                throw new CardException((Throwable)e);
            }
        }
        {
            Object var6_9 = null;
        }
        try {}
        catch (IdASException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new CardException((Throwable)e);
        }
        if (ctx == null) return;
        if (!ctx.isOpen(null)) return;
        ctx.close();
    }

    private void addCardToCache(MCardEntity card, IUserCredentials credentials) throws CardException {
        CacheKey cacheKey;
        HashMap cacheCards;
        if (!isNoCache && (cacheCards = this.getMCardsFromCache(cacheKey = this.buildCacheKey(credentials))) != null) {
            cacheCards.put(card.getCardID().toString(), card);
        }
    }

    public MCardEntity getMCard(String cardID, IUserCredentials credentials) throws CardException {
        if (cardID == null) {
            throw new CardException("Parameter \"cardID\" is null");
        }
        if (credentials == null) {
            throw new CardException("Parameter \"credentials\" is null");
        }
        HashMap userCards = this.getCards(credentials);
        if (userCards.containsKey(cardID)) {
            return (MCardEntity)userCards.get(cardID);
        }
        return null;
    }

    public List getMCards(IUserCredentials credentials) throws CardException {
        if (credentials == null) {
            throw new CardException("Parameter \"credentials\" is null");
        }
        HashMap userCards = this.getCards(credentials);
        ArrayList<MCardEntity> res = new ArrayList<MCardEntity>();
        Iterator itr = userCards.values().iterator();
        while (itr.hasNext()) {
            MCardEntity mc = (MCardEntity)itr.next();
            res.add(mc);
        }
        return res;
    }

    private HashMap getCards(IUserCredentials credentials) throws CardException {
        CacheKey cacheKey = this.buildCacheKey(credentials);
        HashMap cards = this.getMCardsFromCache(cacheKey);
        if (cards == null) {
            IAuthNMaterials authMaterials = MCardManagedBean.buildAuthMaterials(credentials);
            cards = this.getMCardsFromContext(authMaterials, cacheKey);
        }
        return cards;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateCard(MCardEntity card, IUserCredentials credentials) throws CardException {
        String entityId = (String)card.getId();
        IContext ctx = null;
        IAuthNMaterials authMaterials = MCardManagedBean.buildAuthMaterials(credentials);
        try {
            try {
                ctx = this.registry.createContext(this.contextId);
                ctx.open(authMaterials);
                IEntity cardEntity = ctx.getEntity(entityId);
                CardHelper.updateMCard(card, cardEntity);
                ctx.applyUpdates();
            }
            catch (IdASException e) {
                this.log.error((Object)e, (Throwable)e);
                throw new CardException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                if (ctx == null) throw throwable;
                if (!ctx.isOpen(null)) throw throwable;
                ctx.close();
                throw throwable;
            }
            catch (IdASException e) {
                this.log.error((Object)e, (Throwable)e);
                throw new CardException((Throwable)e);
            }
        }
        {
            Object var7_10 = null;
        }
        try {}
        catch (IdASException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new CardException((Throwable)e);
        }
        if (ctx == null) return;
        if (!ctx.isOpen(null)) return;
        ctx.close();
    }

    private HashMap getMCardsFromCache(CacheKey cacheKey) throws CardException {
        if (isNoCache) {
            if (!cardCache.isKeyInCache((ICacheKey)cacheKey)) {
                return null;
            }
            return (HashMap)cardCache.get((ICacheKey)cacheKey);
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized HashMap getMCardsFromContext(IAuthNMaterials authentication, CacheKey key) throws CardException {
        HashMap<String, MCardEntity> cards = this.getMCardsFromCache(key);
        if (cards != null) {
            return cards;
        }
        cards = new HashMap<String, MCardEntity>();
        IContext ctx = null;
        try {
            try {
                ctx = this.registry.createContext(this.contextId);
                ctx.open(authentication);
                Iterator cardEntities = null;
                if (this.useFilterApi) {
                    IFilter filter = ctx.buildFilter();
                    IFilterEntityTypeAssertion typeAssertion = ctx.buildEntityTypeAssertion();
                    typeAssertion.setAssertionValue(IdASContext.ICARD_MCard);
                    filter.setAssertion((IFilterAssertion)typeAssertion);
                    cardEntities = ctx.getEntities(filter);
                } else {
                    String query = "SELECT ?subj WHERE { ?subj <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <" + IdASContext.ICARD_MCard.toString() + "> }";
                    cardEntities = ctx.getEntities(query);
                }
                while (cardEntities.hasNext()) {
                    IEntity entity = (IEntity)cardEntities.next();
                    MCardEntity me = new MCardEntity();
                    CardHelper.initMCard(me, entity);
                    cards.put(me.getCardID().toString(), me);
                }
            }
            catch (IdASException e) {
                this.log.error((Object)e, (Throwable)e);
                throw new CardException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (ctx == null) throw throwable;
                if (!ctx.isOpen(null)) throw throwable;
                ctx.close();
                throw throwable;
            }
            catch (IdASException e) {
                this.log.error((Object)e, (Throwable)e);
                throw new CardException((Throwable)e);
            }
        }
        {
            Object var8_11 = null;
        }
        try {}
        catch (IdASException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new CardException((Throwable)e);
        }
        if (ctx != null && ctx.isOpen(null)) {
            ctx.close();
        }
        if (isNoCache) return cards;
        cardCache.put((ICacheKey)key, cards);
        return cards;
    }

    protected IContext getContext() throws IdASException, CardException {
        if (!this.isConfigured) {
            throw new CardException("IdAS based managed bean was not configured");
        }
        IContext ctx = this.registry.createContext(this.contextId);
        return ctx;
    }

    private static IAuthNMaterials buildAuthMaterials(IUserCredentials credentials) throws CardException {
        if (!(credentials instanceof UsernamePasswordCredentials)) {
            throw new CardException();
        }
        UsernamePasswordCredentials upc = (UsernamePasswordCredentials)credentials;
        AuthNNamePasswordMaterials authMaterials = new AuthNNamePasswordMaterials(upc.getUsername(), upc.getPassword());
        return authMaterials;
    }

    private CacheKey buildCacheKey(IUserCredentials credentials) throws CardException {
        String password;
        String userName;
        String cacheKey = null;
        if (credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials upc = (UsernamePasswordCredentials)credentials;
            userName = upc.getUsername();
            password = upc.getPassword();
            if (userName == null) {
                throw new CardException("User name is null.");
            }
        } else {
            throw new CardException();
        }
        cacheKey = userName.trim();
        cacheKey = String.valueOf(cacheKey) + " ";
        cacheKey = String.valueOf(cacheKey) + (password != null ? password : "emptyPassword");
        return new CacheKey(cacheKey);
    }

    public void init(Map config) throws CardException {
        String useFilter;
        this.registry = IdASRegistry.getInstance();
        String discoveryFile = (String)config.get("discovery.filename");
        if (discoveryFile != null) {
            FileDiscovery factories = new FileDiscovery(new File(discoveryFile));
            this.registry.setDiscovery((IDiscovery)factories);
        }
        this.useFilterApi = (useFilter = (String)config.get("filter.api")) != null && "true".equalsIgnoreCase(useFilter);
        String contextIdStr = (String)config.get("contextId");
        try {
            this.contextId = ContextIdFactory.fromString((String)contextIdStr);
        }
        catch (IdASException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new CardException((Throwable)e);
        }
    }

    public ISettingDescriptor getComponentDescriptor() {
        return null;
    }

    public void persistMCard(MCardEntity card, IUserCredentials credentials) throws CardException {
        if (card == null) {
            throw new CardException("Parameter \"card\" is null");
        }
        if (credentials == null) {
            throw new CardException("Parameter \"credentials\" is null");
        }
        if (card.getId() == null) {
            this.addCard(card, credentials);
        } else {
            this.updateCard(card, credentials);
        }
    }

    public void deleteMCard(String cardID, IUserCredentials credentials) throws CardException {
        if (cardID == null) {
            throw new CardException("Parameter \"cardID\" is null");
        }
        if (credentials == null) {
            throw new CardException("Parameter \"credentials\" is null");
        }
        MCardEntity card = this.getMCard(cardID, credentials);
        this.removeCardFromContext(card, credentials);
        this.removeCardFromCache(card, credentials);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeCardFromContext(MCardEntity card, IUserCredentials credentials) throws CardException {
        IContext ctx = null;
        IAuthNMaterials authMaterials = MCardManagedBean.buildAuthMaterials(credentials);
        String entityId = (String)card.getId();
        if (entityId == null) {
            throw new CardException("Card entity contains no entity id.");
        }
        try {
            try {
                ctx = this.registry.createContext(this.contextId);
                ctx.open(authMaterials);
                IEntity entity = ctx.getEntity(entityId);
                entity.remove();
                ctx.applyUpdates();
            }
            catch (IdASException e) {
                this.log.error((Object)e, (Throwable)e);
                throw new CardException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                if (ctx == null) throw throwable;
                if (!ctx.isOpen(null)) throw throwable;
                ctx.close();
                throw throwable;
            }
            catch (IdASException e) {
                this.log.error((Object)e, (Throwable)e);
                throw new CardException((Throwable)e);
            }
        }
        {
            Object var7_10 = null;
        }
        try {}
        catch (IdASException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new CardException((Throwable)e);
        }
        if (ctx == null) return;
        if (!ctx.isOpen(null)) return;
        ctx.close();
    }

    private void removeCardFromCache(MCardEntity card, IUserCredentials credentials) throws CardException {
        CacheKey cacheKey;
        HashMap cacheCards;
        if (!isNoCache && (cacheCards = this.getMCardsFromCache(cacheKey = this.buildCacheKey(credentials))) != null) {
            String cardId = card.getCardID().toString();
            cacheCards.remove(cardId);
        }
    }
}

