/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.entity.mysql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CardException;

public class ConnectionFactory {
    private static Log log;
    public static final String JNDI_CONTEXT = "jndi.context";
    public static final String SOURCE_NAME = "source.name";
    public static final String DRIVER_CLASS_NAME = "driver.classname";
    public static final String DB_USER_NAME = "db.username";
    public static final String DB_PASSWORD = "db.password";
    public static final String DB_URL = "db.url";
    public static final String USE_POOL = "db.pool";
    protected String dbUserName;
    protected String dbPassword;
    protected String dbURL;
    protected String jndiContext;
    protected boolean isPoolUsed;
    protected DataSource dataSource;
    protected String driverName;
    protected String userName;
    protected String password;
    protected String url;
    protected String contextName;
    protected String sourceName;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.icard.provider.cardspace.entity.mysql.ConnectionFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public ConnectionFactory(String driverName, String userName, String password, String url) throws CardException {
        log.debug((Object)("driverName = " + driverName + ", userName = " + userName + ", password = " + password + ", url = " + url));
        this.isPoolUsed = false;
        this.driverName = driverName;
        this.userName = userName;
        this.password = password;
        this.url = url;
        try {
            Class.forName(driverName);
            this.initDatabase();
        }
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            throw new CardException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e, (Throwable)e);
            throw new CardException((Throwable)e);
        }
    }

    public ConnectionFactory(String contextName, String sourceName) throws CardException {
        log.debug((Object)("context name = " + contextName + ",dataSource name " + sourceName));
        this.isPoolUsed = true;
        this.contextName = contextName;
        this.sourceName = sourceName;
        try {
            InitialContext init = new InitialContext();
            Context ctx = (Context)init.lookup(contextName);
            if (ctx == null) {
                throw new CardException("Can not find context by name = " + contextName);
            }
            this.dataSource = (DataSource)ctx.lookup(sourceName);
            if (this.dataSource == null) {
                throw new CardException("Can not find DataSource by name = " + sourceName);
            }
            this.initDatabase();
        }
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            throw new CardException((Throwable)e);
        }
        catch (NamingException e) {
            log.error((Object)e, (Throwable)e);
            throw new CardException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void initDatabase() throws CardException, SQLException {
        block15: {
            con = null;
            rs = null;
            try {
                try {
                    con = this.getConnection();
                    types = new String[]{"TABLE"};
                    rs = con.getMetaData().getTables(null, null, "ManagedCard", types);
                    if (!rs.next()) {
                        this.createDbStructure(con);
                    }
                }
                catch (Exception e) {
                    ConnectionFactory.log.error((Object)e, (Throwable)e);
                    throw new CardException((Throwable)e);
                }
            }
            catch (Throwable var5_5) {
                var4_6 = null;
                try {
                    if (con != null && !con.isClosed()) {
                        con.close();
                        con = null;
                    }
                }
                catch (SQLException e) {
                    ConnectionFactory.log.error((Object)e, (Throwable)e);
                }
                try {
                    if (rs == null) throw var5_5;
                    rs.close();
                    rs = null;
                    throw var5_5;
                }
                catch (SQLException e) {
                    ConnectionFactory.log.error((Object)e, (Throwable)e);
                }
                throw var5_5;
            }
            {
                var4_7 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 83->107)] { 
lbl35:
            // 1 sources

            if (con != null && !con.isClosed()) {
                con.close();
                con = null;
            }
            break block15;
lbl39:
            // 1 sources

            catch (SQLException e) {
                ConnectionFactory.log.error((Object)e, (Throwable)e);
            }
        }
        try {}
        catch (SQLException e) {
            ConnectionFactory.log.error((Object)e, (Throwable)e);
            return;
        }
        if (rs == null) return;
        rs.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList getCreateStatements() throws IOException {
        StringBuffer sb;
        block7: {
            InputStream is = null;
            sb = new StringBuffer();
            try {
                is = ClassLoader.getSystemResourceAsStream("mysql.sql");
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String line = br.readLine();
                while (line != null) {
                    sb.append(line);
                    line = br.readLine();
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (is != null) {
                    is.close();
                }
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (is == null) break block7;
            }
            is.close();
        }
        ArrayList<String> statemens = new ArrayList<String>();
        String all = sb.toString();
        StringTokenizer st = new StringTokenizer(all, ";");
        while (st.hasMoreTokens()) {
            statemens.add(st.nextToken());
        }
        return statemens;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createDbStructure(Connection con) throws SQLException, IOException {
        ArrayList sts = this.getCreateStatements();
        Statement st = null;
        try {
            st = con.createStatement();
            int i = 0;
            int s = sts.size();
            while (true) {
                block7: {
                    if (i < s) break block7;
                    st.executeBatch();
                    break;
                }
                String sql = (String)sts.get(i);
                st.addBatch(sql);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (st == null) throw throwable;
                st.close();
                st = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (st == null) return;
        st.close();
    }

    public Connection getConnection() throws SQLException {
        Connection con = null;
        con = this.isPoolUsed ? this.dataSource.getConnection() : DriverManager.getConnection(this.url, this.userName, this.password);
        con.setAutoCommit(false);
        return con;
    }

    public static ConnectionFactory buildConnectionFactory(Map config) throws CardException {
        String dbURL;
        boolean isPoolUsed;
        String useConnectionPool = config.containsKey(USE_POOL) ? (String)config.get(USE_POOL) : null;
        boolean bl = isPoolUsed = "yes".equalsIgnoreCase(useConnectionPool);
        if (isPoolUsed) {
            String sourceName;
            String jndiContext = config.containsKey(JNDI_CONTEXT) ? (String)config.get(JNDI_CONTEXT) : null;
            String string = sourceName = config.containsKey(SOURCE_NAME) ? (String)config.get(SOURCE_NAME) : null;
            if (jndiContext == null) {
                throw new CardException("Property \"jndi.context\" not found.");
            }
            if (sourceName == null) {
                throw new CardException("Property \"source.name\" not found.");
            }
            return new ConnectionFactory(jndiContext, sourceName);
        }
        String driverName = config.containsKey(DRIVER_CLASS_NAME) ? (String)config.get(DRIVER_CLASS_NAME) : "com.mysql.jdbc.Driver";
        String dbUserName = config.containsKey(DB_USER_NAME) ? (String)config.get(DB_USER_NAME) : null;
        String dbPassword = config.containsKey(DB_PASSWORD) ? (String)config.get(DB_PASSWORD) : "";
        String string = dbURL = config.containsKey(DB_URL) ? (String)config.get(DB_URL) : null;
        if (dbUserName == null) {
            throw new CardException("Property \"db.username\" not found.");
        }
        if (dbURL == null) {
            throw new CardException("Property \"db.url\" not found.");
        }
        return new ConnectionFactory(driverName, dbUserName, dbPassword, dbURL);
    }
}

