/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.entity.mysql;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.IClaimType;
import org.eclipse.higgins.icard.ITokenService;
import org.eclipse.higgins.icard.common.ClaimType;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.provider.cardspace.common.CredentialDescriptor;
import org.eclipse.higgins.icard.provider.cardspace.common.EndpointReference;
import org.eclipse.higgins.icard.provider.cardspace.common.STSPrivacyPolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.TokenService;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.CardEntity;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.Extension;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.MCardEntity;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.XMLUtils;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MCardHelper {
    private static Log log;
    private static final long maxMySQLDate_ = 253402253999000L;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.icard.provider.cardspace.entity.mysql.MCardHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    /*
     * Loose catch block
     */
    public ArrayList getMCards(Connection con, String userId) throws CardException {
        ArrayList<MCardEntity> list = new ArrayList<MCardEntity>();
        String query = "SELECT * FROM ManagedCard WHERE userID_ = ? ORDER BY id_";
        PreparedStatement ps = null;
        ResultSet rs = null;
        ps = con.prepareStatement(query);
        ps.setString(1, userId);
        rs = ps.executeQuery();
        while (rs.next()) {
            MCardEntity mc = new MCardEntity();
            MCardHelper.initMCard(mc, rs, con);
            list.add(mc);
        }
        ArrayList<MCardEntity> arrayList = list;
        Object var8_10 = null;
        try {
            if (rs != null) {
                rs.close();
                rs = null;
            }
        }
        catch (SQLException e2) {
            log.error((Object)e2, (Throwable)e2);
        }
        try {
            if (ps != null) {
                ps.close();
                ps = null;
            }
        }
        catch (SQLException e2) {
            log.error((Object)e2, (Throwable)e2);
        }
        return arrayList;
        catch (Exception e) {
            try {
                log.error((Object)e, (Throwable)e);
                throw new CardException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException e2) {
                    log.error((Object)e2, (Throwable)e2);
                }
                try {
                    if (ps != null) {
                        ps.close();
                        ps = null;
                    }
                }
                catch (SQLException e2) {
                    log.error((Object)e2, (Throwable)e2);
                }
                throw throwable;
            }
        }
    }

    public static void initMCard(MCardEntity card, ResultSet rs, Connection con) throws Exception {
        MCardHelper.initCard((CardEntity)card, rs, con);
        int id = (Integer)card.getId();
        card.setSupportedTokenTypeList((List)MCardHelper.initMCardSupportedTokenTypes(id, con));
        card.setSupportedClaimTypeList((List)MCardHelper.initMCardClaimTypes(id, con));
        card.setExtensionList((List)MCardHelper.initMCardExtensionList(id, con));
        BigDecimal rat = rs.getBigDecimal("requireAppliesTo_");
        if (rat != null) {
            card.setRequireAppliesTo(rat.intValue() == 0 ? Boolean.TRUE : Boolean.FALSE);
        } else {
            card.setRequireAppliesTo(null);
        }
        MCardHelper.initStsPolicy(card, rs);
        card.setTokenServiceList((List)MCardHelper.getTokenServiceList(id, con));
    }

    private static void initStsPolicy(MCardEntity card, ResultSet rs) throws URISyntaxException, SQLException, CardException {
        String policyStr = rs.getString("privacyNotice_");
        if (policyStr != null) {
            STSPrivacyPolicy sp = new STSPrivacyPolicy(policyStr);
            card.setPolicyURL(new URI(sp.getPrivacyUrl()));
            String version = sp.getPrivacyVersion();
            try {
                Integer versionInt = new Integer(version);
                card.setPolicyVersion(versionInt);
            }
            catch (NumberFormatException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    private static void initCard(CardEntity card, ResultSet rs, Connection con) throws SQLException, URISyntaxException {
        int rowId = rs.getInt("id_");
        card.setId((Object)new Integer(rowId));
        String cardID = rs.getString("cardID_");
        card.setCardID(new URI(cardID));
        card.setLanguage(rs.getString("language_"));
        card.setName(rs.getString("name_"));
        card.setVersion(rs.getInt("version_"));
        card.setIssuer(new URI(rs.getString("issuer_")));
        card.setIssuerID(rs.getBytes("issuerID_"));
        card.setIssuerName(rs.getString("issuerName_"));
        card.setImage(rs.getBytes("image_"));
        card.setImageType(rs.getString("imageType_"));
        card.setTimeIssued((java.util.Date)rs.getDate("timeIssued_"));
        card.setTimeExpires((java.util.Date)rs.getDate("timeExpires_"));
        card.setTimeLastUpdated((java.util.Date)rs.getDate("timeLastUpdated_"));
        card.setHashSalt(rs.getBytes("hashSalt_"));
        card.setMasterKey(rs.getBytes("masterKey_"));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ArrayList initMCardSupportedTokenTypes(int cardRowId, Connection con) throws SQLException, URISyntaxException {
        block13: {
            query = "SELECT stt.id_, stt.tokenTypeID_, tt.type_ FROM SupportedTokenType AS stt, TokenType AS tt WHERE stt.cardID_ = ? AND stt.tokenTypeID_ = tt.id_ ORDER BY stt.id_";
            supportedTokenTypeList = new ArrayList<URI>();
            ps = null;
            rs = null;
            try {
                ps = con.prepareStatement(query);
                ps.setInt(1, cardRowId);
                rs = ps.executeQuery();
                while (rs.next()) {
                    supportedTokenTypeList.add(new URI(rs.getString("type_")));
                }
            }
            catch (Throwable var7_6) {
                var6_7 = null;
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException e) {
                    MCardHelper.log.error((Object)e, (Throwable)e);
                }
                try {
                    if (ps == null) throw var7_6;
                    ps.close();
                    ps = null;
                    throw var7_6;
                }
                catch (SQLException e) {
                    MCardHelper.log.error((Object)e, (Throwable)e);
                }
                throw var7_6;
            }
            {
                var6_8 = null;
            }
            ** try [egrp 1[TRYBLOCK] [2 : 93->111)] { 
lbl35:
            // 1 sources

            if (rs != null) {
                rs.close();
                rs = null;
            }
            break block13;
lbl39:
            // 1 sources

            catch (SQLException e) {
                MCardHelper.log.error((Object)e, (Throwable)e);
            }
        }
        try {}
        catch (SQLException e) {
            MCardHelper.log.error((Object)e, (Throwable)e);
            return supportedTokenTypeList;
        }
        if (ps == null) return supportedTokenTypeList;
        ps.close();
        ps = null;
        return supportedTokenTypeList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ArrayList initMCardExtensionList(int cardRowId, Connection con) throws SQLException {
        block13: {
            query = "SELECT * FROM MCardExtension WHERE cardID_ = ?";
            extensionList = new ArrayList<Extension>();
            ps = null;
            rs = null;
            try {
                ps = con.prepareStatement(query);
                ps.setInt(1, cardRowId);
                rs = ps.executeQuery();
                while (rs.next()) {
                    ext = new Extension();
                    ext.setId((Object)new Integer(rs.getInt("id_")));
                    ext.setExtensionData(rs.getString("element_"));
                    ext.setEnabled(rs.getBoolean("enabled_"));
                    extensionList.add(ext);
                }
            }
            catch (Throwable var8_7) {
                var7_8 = null;
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException e) {
                    MCardHelper.log.error((Object)e, (Throwable)e);
                }
                try {
                    if (ps == null) throw var8_7;
                    ps.close();
                    ps = null;
                    throw var8_7;
                }
                catch (SQLException e) {
                    MCardHelper.log.error((Object)e, (Throwable)e);
                }
                throw var8_7;
            }
            {
                var7_9 = null;
            }
            ** try [egrp 1[TRYBLOCK] [2 : 138->156)] { 
lbl39:
            // 1 sources

            if (rs != null) {
                rs.close();
                rs = null;
            }
            break block13;
lbl43:
            // 1 sources

            catch (SQLException e) {
                MCardHelper.log.error((Object)e, (Throwable)e);
            }
        }
        try {}
        catch (SQLException e) {
            MCardHelper.log.error((Object)e, (Throwable)e);
            return extensionList;
        }
        if (ps == null) return extensionList;
        ps.close();
        ps = null;
        return extensionList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ArrayList initMCardClaimTypes(int cardRowId, Connection con) throws SQLException, CardException {
        block13: {
            query = "SELECT sct.id_, sct.claimTypeID_, ct.type_ , ct.displayName_ , ct.description_ FROM SupportedClaimType AS sct, ClaimType AS ct WHERE sct.cardID_ = ? AND sct.claimTypeID_ = ct.id_ ORDER BY sct.id_";
            claimTypes = new ArrayList<ClaimType>();
            ps = null;
            rs = null;
            try {
                ps = con.prepareStatement(query);
                ps.setInt(1, cardRowId);
                rs = ps.executeQuery();
                while (rs.next()) {
                    type = rs.getString("type_");
                    description = rs.getString("description_");
                    displayName = rs.getString("displayName_");
                    isPPID = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier".equals(type);
                    ct = new ClaimType(type, displayName, description, isPPID == false, isPPID == false);
                    claimTypes.add(ct);
                }
            }
            catch (Throwable var12_11) {
                var11_12 = null;
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException e) {
                    MCardHelper.log.error((Object)e, (Throwable)e);
                }
                try {
                    if (ps == null) throw var12_11;
                    ps.close();
                    ps = null;
                    throw var12_11;
                }
                catch (SQLException e) {
                    MCardHelper.log.error((Object)e, (Throwable)e);
                }
                throw var12_11;
            }
            {
                var11_13 = null;
            }
            ** try [egrp 1[TRYBLOCK] [2 : 159->177)] { 
lbl40:
            // 1 sources

            if (rs != null) {
                rs.close();
                rs = null;
            }
            break block13;
lbl44:
            // 1 sources

            catch (SQLException e) {
                MCardHelper.log.error((Object)e, (Throwable)e);
            }
        }
        try {}
        catch (SQLException e) {
            MCardHelper.log.error((Object)e, (Throwable)e);
            return claimTypes;
        }
        if (ps == null) return claimTypes;
        ps.close();
        ps = null;
        return claimTypes;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ArrayList getTokenServiceList(int cardRowId, Connection con) throws SQLException, CardException, URISyntaxException, IllegalArgumentException, ParserConfigurationException, SAXException, IOException {
        block13: {
            tokenServiceList = new ArrayList<TokenService>();
            query = "SELECT * FROM TokenService WHERE cardID_ = ?";
            ps = null;
            rs = null;
            try {
                ps = con.prepareStatement(query);
                ps.setInt(1, cardRowId);
                rs = ps.executeQuery();
                while (rs.next()) {
                    endpointAddress = rs.getString("endpointAddress_");
                    hint = rs.getString("hint_");
                    identity = rs.getString("identity_");
                    credential = rs.getString("credential_");
                    metadata = rs.getString("metadata_");
                    epAddress = new URI(endpointAddress);
                    endpoint = new EndpointReference(epAddress, metadata, identity);
                    credentialDescriptor = new CredentialDescriptor(hint, credential);
                    ts = new TokenService(endpoint, credentialDescriptor);
                    tokenServiceList.add(ts);
                }
            }
            catch (Throwable var16_15) {
                var15_16 = null;
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException e) {
                    MCardHelper.log.error((Object)e, (Throwable)e);
                }
                try {
                    if (ps == null) throw var16_15;
                    ps.close();
                    ps = null;
                    throw var16_15;
                }
                catch (SQLException e) {
                    MCardHelper.log.error((Object)e, (Throwable)e);
                }
                throw var16_15;
            }
            {
                var15_17 = null;
            }
            ** try [egrp 1[TRYBLOCK] [2 : 190->208)] { 
lbl44:
            // 1 sources

            if (rs != null) {
                rs.close();
                rs = null;
            }
            break block13;
lbl48:
            // 1 sources

            catch (SQLException e) {
                MCardHelper.log.error((Object)e, (Throwable)e);
            }
        }
        try {}
        catch (SQLException e) {
            MCardHelper.log.error((Object)e, (Throwable)e);
            return tokenServiceList;
        }
        if (ps == null) return tokenServiceList;
        ps.close();
        ps = null;
        return tokenServiceList;
    }

    private static BigDecimal boolToInt(Boolean bool) {
        if (bool != null) {
            return bool != false ? new BigDecimal(0) : new BigDecimal(1);
        }
        return null;
    }

    private static String getPrivacyPolicy(MCardEntity card) throws Exception {
        URI uri = card.getPolicyURL();
        if (uri == null) {
            return null;
        }
        Integer ver = card.getPolicyVersion();
        String version = ver != null ? ver.toString() : null;
        STSPrivacyPolicy spp = new STSPrivacyPolicy(uri.toString(), version);
        IElement iElement = spp.getPrivacyElement();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (String)iElement.getAs((Class)clazz);
    }

    private static Date convertDate(java.util.Date date) {
        if (date == null) {
            return null;
        }
        if (date.getTime() > 253402253999000L) {
            return new Date(253402253999000L);
        }
        if (date instanceof Date) {
            return (Date)date;
        }
        return new Date(date.getTime());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveMCard(MCardEntity card, Connection con, String userId) throws Exception {
        block16: {
            block15: {
                id = null;
                query = "INSERT INTO ManagedCard (cardID_, language_, name_, version_, issuer_, issuerName_, image_, imageType_, timeIssued_, timeExpires_, timeLastUpdated_, hashSalt_, masterKey_, requireAppliesTo_, privacyNotice_, userID_, issuerID_) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                ps = null;
                rs = null;
                try {
                    try {
                        ps = con.prepareStatement(query, 1);
                        ps.setString(1, card.getCardID().toString());
                        ps.setString(2, card.getLanguage());
                        ps.setString(3, card.getName());
                        ps.setInt(4, card.getVersion());
                        issuer = card.getIssuer();
                        ps.setString(5, issuer != null ? issuer.toString() : null);
                        ps.setString(6, card.getIssuerName());
                        ps.setBytes(7, card.getImage());
                        ps.setString(8, card.getImageType());
                        ps.setDate(9, MCardHelper.convertDate(card.getTimeIssued()));
                        ps.setDate(10, MCardHelper.convertDate(card.getTimeExpires()));
                        ps.setDate(11, MCardHelper.convertDate(card.getTimeLastUpdated()));
                        ps.setBytes(12, card.getHashSalt());
                        ps.setBytes(13, card.getMasterKey());
                        ps.setBigDecimal(14, MCardHelper.boolToInt(card.getRequireAppliesTo()));
                        ps.setString(15, MCardHelper.getPrivacyPolicy(card));
                        ps.setString(16, userId);
                        ps.setBytes(17, card.getIssuerID());
                        ps.execute();
                        rs = ps.getGeneratedKeys();
                        if (rs.next() == false) throw new CardException("Prepared statement did not return primary key for inserted row.");
                        id = new Integer(rs.getInt(1));
                    }
                    catch (SQLException e) {
                        MCardHelper.log.error((Object)e, (Throwable)e);
                        throw new CardException((Throwable)e);
                    }
                }
                catch (Throwable var9_9) {
                    var8_10 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                    }
                    catch (SQLException e) {
                        MCardHelper.log.error((Object)e, (Throwable)e);
                    }
                    try {
                        if (ps == null) throw var9_9;
                        ps.close();
                        ps = null;
                        throw var9_9;
                    }
                    catch (SQLException e) {
                        MCardHelper.log.error((Object)e, (Throwable)e);
                    }
                    throw var9_9;
                }
                {
                    var8_11 = null;
                }
                ** try [egrp 2[TRYBLOCK] [3 : 359->377)] { 
lbl56:
                // 1 sources

                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                break block15;
lbl60:
                // 1 sources

                catch (SQLException e) {
                    MCardHelper.log.error((Object)e, (Throwable)e);
                }
            }
            ** try [egrp 3[TRYBLOCK] [4 : 391->409)] { 
lbl64:
            // 1 sources

            if (ps != null) {
                ps.close();
                ps = null;
            }
            break block16;
lbl68:
            // 1 sources

            catch (SQLException e) {
                MCardHelper.log.error((Object)e, (Throwable)e);
            }
        }
        MCardHelper.saveMCardTokenServiceList(id, con, card.getTokenServiceList());
        MCardHelper.saveMCardSupportedTokenTypeList(id, con, card.getSupportedTokenTypeList());
        MCardHelper.saveMCardSupportedClaimTypeList(id, con, card.getSupportedClaimTypeList());
        MCardHelper.insertMCardExtensionList(id, con, card.getExtensionList());
        card.setId((Object)id);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveMCardTokenServiceList(int cardId, Connection con, List tokenServiceList) throws CardException, TransformerException {
        block16: {
            if (tokenServiceList == null) return;
            if (tokenServiceList.size() == 0) {
                return;
            }
            query = "INSERT INTO TokenService (cardID_, endpointAddress_, hint_, identity_, credential_, metadata_) VALUES (?, ?, ?, ?, ?, ?)";
            ps = null;
            rs = null;
            try {
                try {
                    ps = con.prepareStatement(query);
                    ps.setInt(1, cardId);
                    i = 0;
                    while (i < tokenServiceList.size()) {
                        ts = (ITokenService)tokenServiceList.get(i);
                        er = ts.getEndpointReference();
                        cd = ts.getUserCredential();
                        ps.setString(2, er.getAddress().toString());
                        ps.setString(3, cd.getDisplayCredentialHint());
                        ps.setString(4, XMLUtils.elementToString((Element)er.getIdentity()));
                        ps.setString(5, XMLUtils.elementToString((Element)cd.asXML()));
                        ps.setString(6, XMLUtils.elementToString((Element)er.getMetadata()));
                        ps.execute();
                        ++i;
                    }
                }
                catch (SQLException e) {
                    MCardHelper.log.error((Object)e, (Throwable)e);
                    throw new CardException((Throwable)e);
                }
            }
            catch (Throwable var11_11) {
                var10_12 = null;
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException e) {
                    MCardHelper.log.error((Object)e, (Throwable)e);
                }
                try {
                    if (ps == null) throw var11_11;
                    ps.close();
                    ps = null;
                    throw var11_11;
                }
                catch (SQLException e) {
                    MCardHelper.log.error((Object)e, (Throwable)e);
                }
                throw var11_11;
            }
            {
                var10_13 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 226->244)] { 
lbl50:
            // 1 sources

            if (rs != null) {
                rs.close();
                rs = null;
            }
            break block16;
lbl54:
            // 1 sources

            catch (SQLException e) {
                MCardHelper.log.error((Object)e, (Throwable)e);
            }
        }
        try {}
        catch (SQLException e) {
            MCardHelper.log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * Loose catch block
     */
    private static int getTokenType(Connection con, String tokenType) throws CardException {
        ResultSet rs;
        PreparedStatement ps;
        block19: {
            int id;
            String query = "SELECT id_ FROM TokenType WHERE type_ = ?";
            ps = null;
            rs = null;
            ps = con.prepareStatement(query);
            ps.setString(1, tokenType);
            rs = ps.executeQuery();
            if (!rs.next()) break block19;
            int n = id = rs.getInt("id_");
            Object var6_8 = null;
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (SQLException e2) {
                log.error((Object)e2, (Throwable)e2);
            }
            try {
                if (ps != null) {
                    ps.close();
                    ps = null;
                }
            }
            catch (SQLException e2) {
                log.error((Object)e2, (Throwable)e2);
            }
            return n;
        }
        Object var6_9 = null;
        try {
            if (rs != null) {
                rs.close();
                rs = null;
            }
        }
        catch (SQLException e2) {
            log.error((Object)e2, (Throwable)e2);
        }
        try {
            if (ps != null) {
                ps.close();
                ps = null;
            }
        }
        catch (SQLException e2) {
            log.error((Object)e2, (Throwable)e2);
        }
        return -1;
        catch (SQLException e) {
            try {
                log.error((Object)e, (Throwable)e);
                throw new CardException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException e2) {
                    log.error((Object)e2, (Throwable)e2);
                }
                try {
                    if (ps != null) {
                        ps.close();
                        ps = null;
                    }
                }
                catch (SQLException e2) {
                    log.error((Object)e2, (Throwable)e2);
                }
                throw throwable;
            }
        }
    }

    private static int insertTokenType(Connection con, String tokenType) throws CardException {
        ResultSet rs;
        PreparedStatement ps;
        block15: {
            int id;
            String query = "INSERT INTO TokenType (type_) VALUES (?)";
            ps = null;
            rs = null;
            ps = con.prepareStatement(query, 1);
            ps.setString(1, tokenType);
            ps.execute();
            rs = ps.getGeneratedKeys();
            if (!rs.next()) break block15;
            int n = id = rs.getInt(1);
            Object var6_8 = null;
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            try {
                if (ps != null) {
                    ps.close();
                    ps = null;
                }
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            return n;
        }
        try {
            try {
                throw new CardException("Prepared statement did not return primary key for inserted row.");
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
                throw new CardException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            try {
                if (ps != null) {
                    ps.close();
                    ps = null;
                }
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
    }

    private static int initTokenType(Connection con, String tokenType) throws CardException {
        int tokenTypeID = MCardHelper.getTokenType(con, tokenType);
        if (tokenTypeID == -1) {
            tokenTypeID = MCardHelper.insertTokenType(con, tokenType);
        }
        return tokenTypeID;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveMCardSupportedTokenTypeList(int cardId, Connection con, List tokenList) throws CardException {
        if (tokenList == null) return;
        if (tokenList.size() == 0) {
            return;
        }
        String query = "INSERT INTO SupportedTokenType (cardID_, tokenTypeID_) VALUES (?, ?)";
        PreparedStatement ps = null;
        try {
            try {
                ps = con.prepareStatement(query);
                ps.setInt(1, cardId);
                int i = 0;
                while (i < tokenList.size()) {
                    URI tokenType = (URI)tokenList.get(i);
                    int tokenTypeID = MCardHelper.initTokenType(con, tokenType.toString());
                    ps.setInt(2, tokenTypeID);
                    ps.execute();
                    ++i;
                }
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
                throw new CardException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveMCardSupportedClaimTypeList(int cardId, Connection con, List claimTypeList) throws CardException {
        block16: {
            if (claimTypeList == null) return;
            if (claimTypeList.size() == 0) {
                return;
            }
            query = "INSERT INTO SupportedClaimType (cardID_, claimTypeID_) VALUES (?, ?)";
            ps = null;
            rs = null;
            try {
                try {
                    ps = con.prepareStatement(query);
                    ps.setInt(1, cardId);
                    i = 0;
                    while (i < claimTypeList.size()) {
                        ct = (IClaimType)claimTypeList.get(i);
                        claimTypeID = MCardHelper.initClaimType(con, ct);
                        ps.setInt(2, claimTypeID);
                        ps.execute();
                        ++i;
                    }
                }
                catch (SQLException e) {
                    MCardHelper.log.error((Object)e, (Throwable)e);
                    throw new CardException((Throwable)e);
                }
            }
            catch (Throwable var10_10) {
                var9_11 = null;
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException e) {
                    MCardHelper.log.error((Object)e, (Throwable)e);
                }
                try {
                    if (ps == null) throw var10_10;
                    ps.close();
                    ps = null;
                    throw var10_10;
                }
                catch (SQLException e) {
                    MCardHelper.log.error((Object)e, (Throwable)e);
                }
                throw var10_10;
            }
            {
                var9_12 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 138->156)] { 
lbl45:
            // 1 sources

            if (rs != null) {
                rs.close();
                rs = null;
            }
            break block16;
lbl49:
            // 1 sources

            catch (SQLException e) {
                MCardHelper.log.error((Object)e, (Throwable)e);
            }
        }
        try {}
        catch (SQLException e) {
            MCardHelper.log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    private static int initClaimType(Connection con, IClaimType claimType) throws CardException {
        int tokenTypeID = MCardHelper.getClaimType(con, claimType);
        if (tokenTypeID == -1) {
            tokenTypeID = MCardHelper.insertClaimType(con, claimType);
        }
        return tokenTypeID;
    }

    /*
     * Loose catch block
     */
    private static int getClaimType(Connection con, IClaimType claimType) throws CardException {
        ResultSet rs;
        PreparedStatement ps;
        block19: {
            int id;
            String query = "SELECT id_ FROM ClaimType WHERE type_ = ? AND typeLocalName_ = ? AND displayName_ = ? AND description_ = ?";
            ps = null;
            rs = null;
            ps = con.prepareStatement(query);
            ps.setString(1, claimType.getType());
            ps.setString(2, claimType.getTypeLocalName());
            ps.setString(3, claimType.getDisplayName());
            ps.setString(4, claimType.getDescription());
            rs = ps.executeQuery();
            if (!rs.next()) break block19;
            int n = id = rs.getInt("id_");
            Object var6_8 = null;
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (SQLException e2) {
                log.error((Object)e2, (Throwable)e2);
            }
            try {
                if (ps != null) {
                    ps.close();
                    ps = null;
                }
            }
            catch (SQLException e2) {
                log.error((Object)e2, (Throwable)e2);
            }
            return n;
        }
        Object var6_9 = null;
        try {
            if (rs != null) {
                rs.close();
                rs = null;
            }
        }
        catch (SQLException e2) {
            log.error((Object)e2, (Throwable)e2);
        }
        try {
            if (ps != null) {
                ps.close();
                ps = null;
            }
        }
        catch (SQLException e2) {
            log.error((Object)e2, (Throwable)e2);
        }
        return -1;
        catch (SQLException e) {
            try {
                log.error((Object)e, (Throwable)e);
                throw new CardException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException e2) {
                    log.error((Object)e2, (Throwable)e2);
                }
                try {
                    if (ps != null) {
                        ps.close();
                        ps = null;
                    }
                }
                catch (SQLException e2) {
                    log.error((Object)e2, (Throwable)e2);
                }
                throw throwable;
            }
        }
    }

    private static int insertClaimType(Connection con, IClaimType claimType) throws CardException {
        ResultSet rs;
        PreparedStatement ps;
        block15: {
            int id;
            String query = "INSERT INTO ClaimType (type_, typeLocalName_, displayName_, description_) VALUES (?, ?, ?, ?)";
            ps = null;
            rs = null;
            ps = con.prepareStatement(query, 1);
            ps.setString(1, claimType.getType());
            ps.setString(2, claimType.getTypeLocalName());
            ps.setString(3, claimType.getDisplayName());
            ps.setString(4, claimType.getDescription());
            ps.execute();
            rs = ps.getGeneratedKeys();
            if (!rs.next()) break block15;
            int n = id = rs.getInt(1);
            Object var6_8 = null;
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            try {
                if (ps != null) {
                    ps.close();
                    ps = null;
                }
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            return n;
        }
        try {
            try {
                throw new CardException("Prepared statement did not return primary key for inserted row.");
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
                throw new CardException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            try {
                if (ps != null) {
                    ps.close();
                    ps = null;
                }
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updateMCardName(int cardId, Connection con, String newName, java.util.Date lastUpdated) throws SQLException {
        String query = "UPDATE ManagedCard SET name_ = ?, timeLastUpdated_ = ? WHERE id_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setString(1, newName);
            ps.setDate(2, MCardHelper.convertDate(lastUpdated));
            ps.setInt(3, cardId);
            ps.execute();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updateMCardImage(int cardId, Connection con, byte[] newImage, java.util.Date lastUpdated) throws SQLException {
        String query = "UPDATE ManagedCard SET image_ = ?, timeLastUpdated_ = ? WHERE id_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setBytes(1, newImage);
            ps.setDate(2, MCardHelper.convertDate(lastUpdated));
            ps.setInt(3, cardId);
            ps.execute();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updateMCardImageType(int cardId, Connection con, String newImageType, java.util.Date lastUpdated) throws SQLException {
        String query = "UPDATE ManagedCard SET imageType_ = ?, timeLastUpdated_ = ? WHERE id_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setString(1, newImageType);
            ps.setDate(2, MCardHelper.convertDate(lastUpdated));
            ps.setInt(3, cardId);
            ps.execute();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updateMCardIssuerName(int cardId, Connection con, String newIssuerName, java.util.Date lastUpdated) throws SQLException {
        String query = "UPDATE ManagedCard SET issuerName_ = ?, timeLastUpdated_ = ? WHERE id_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setString(1, newIssuerName);
            ps.setDate(2, MCardHelper.convertDate(lastUpdated));
            ps.setInt(3, cardId);
            ps.execute();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    private static boolean areStringsEqual(String s1, String s2) {
        return !(s1 == null && s2 != null || s1 != null && s2 == null || !s1.equals(s2));
    }

    public static void updateMCard(MCardEntity card, Connection con) throws CardException, SQLException {
        MCardHelper.updateMCardCommonFields(card, con);
        MCardHelper.updateMCardExtensions(card, con);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updateMCardCommonFields(MCardEntity card, Connection con) throws CardException {
        block19: {
            id = (Integer)card.getId();
            lastUpdated = new java.util.Date();
            query = "SELECT name_, image_, imageType_, issuerName_ FROM ManagedCard WHERE id_ = ?";
            ps = null;
            rs = null;
            try {
                try {
                    ps = con.prepareStatement(query);
                    ps.setInt(1, id);
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        oldCardName = rs.getString("name_");
                        oldImage = rs.getBytes("image_");
                        oldImageType = rs.getString("imageType_");
                        oldIssuerName = rs.getString("issuerName_");
                        newCardName = card.getName();
                        newIssuerName = card.getIssuerName();
                        newImage = card.getImage();
                        newImageType = card.getImageType();
                        if (!MCardHelper.areStringsEqual(oldCardName, newCardName)) {
                            MCardHelper.updateMCardName(id, con, newCardName, lastUpdated);
                        }
                        if (!MCardHelper.areStringsEqual(oldIssuerName, newIssuerName)) {
                            MCardHelper.updateMCardIssuerName(id, con, newIssuerName, lastUpdated);
                        }
                        if (!Arrays.equals(oldImage, newImage)) {
                            MCardHelper.updateMCardImage(id, con, newImage, lastUpdated);
                        }
                        if (!MCardHelper.areStringsEqual(oldImageType, newImageType)) {
                            MCardHelper.updateMCardImageType(id, con, newImageType, lastUpdated);
                        }
                    }
                }
                catch (Exception e) {
                    MCardHelper.log.error((Object)e, (Throwable)e);
                    throw new CardException((Throwable)e);
                }
            }
            catch (Throwable var16_16) {
                var15_17 = null;
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException e) {
                    MCardHelper.log.error((Object)e, (Throwable)e);
                }
                try {
                    if (ps == null) throw var16_16;
                    ps.close();
                    ps = null;
                    throw var16_16;
                }
                catch (SQLException e) {
                    MCardHelper.log.error((Object)e, (Throwable)e);
                }
                throw var16_16;
            }
            {
                var15_18 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 261->279)] { 
lbl54:
            // 1 sources

            if (rs != null) {
                rs.close();
                rs = null;
            }
            break block19;
lbl58:
            // 1 sources

            catch (SQLException e) {
                MCardHelper.log.error((Object)e, (Throwable)e);
            }
        }
        try {}
        catch (SQLException e) {
            MCardHelper.log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    private static Extension getExtensionById(Object id, List extList) {
        if (id == null) {
            return null;
        }
        int i = 0;
        int s = extList.size();
        while (i < s) {
            Extension ext = (Extension)extList.get(i);
            if (id.equals(ext.getId())) {
                return ext;
            }
            ++i;
        }
        return null;
    }

    private static List getExtensionForInsert(List oldExt, List newExt) {
        if (newExt == null || newExt.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        if (oldExt == null || oldExt.size() == 0) {
            return newExt;
        }
        ArrayList<Extension> forInsert = new ArrayList<Extension>();
        int i = 0;
        while (i < newExt.size()) {
            Extension ext = (Extension)newExt.get(i);
            Object newId = ext.getId();
            if (newId == null || MCardHelper.getExtensionById(newId, oldExt) == null) {
                forInsert.add(ext);
            }
            ++i;
        }
        return forInsert;
    }

    private static List getExtensionForUpdate(List oldExtList, List newExtList) {
        if (newExtList == null || newExtList.size() == 0 || oldExtList == null || oldExtList.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Extension> forUpdate = new ArrayList<Extension>();
        int i = 0;
        while (i < newExtList.size()) {
            Extension newExt = (Extension)newExtList.get(i);
            Object newId = newExt.getId();
            if (newId != null) {
                Extension oldExt = MCardHelper.getExtensionById(newId, oldExtList);
                if (!MCardHelper.areStringsEqual(newExt.getExtensionData(), oldExt.getExtensionData()) || newExt.isEnabled() != oldExt.isEnabled()) {
                    forUpdate.add(newExt);
                }
            }
            ++i;
        }
        return forUpdate;
    }

    private static List getExtensionForDelete(List oldExtList, List newExtList) {
        if (oldExtList == null || oldExtList.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Extension> forDelete = new ArrayList<Extension>();
        int i = 0;
        while (i < oldExtList.size()) {
            Extension oldExt = (Extension)oldExtList.get(i);
            Object oldId = oldExt.getId();
            if (MCardHelper.getExtensionById(oldId, newExtList) == null) {
                forDelete.add(oldExt);
            }
            ++i;
        }
        return forDelete;
    }

    private static void updateMCardExtensions(MCardEntity card, Connection con) throws SQLException, CardException {
        Integer id = (Integer)card.getId();
        int cardRowId = id;
        ArrayList oldExtList = MCardHelper.initMCardExtensionList(cardRowId, con);
        List newExtensionList = card.getExtensionList();
        MCardHelper.insertMCardExtensionList(cardRowId, con, MCardHelper.getExtensionForInsert(oldExtList, newExtensionList));
        MCardHelper.updateMCardExtensionList(con, MCardHelper.getExtensionForUpdate(oldExtList, newExtensionList));
        MCardHelper.deleteMCardExtensionList(con, MCardHelper.getExtensionForDelete(oldExtList, newExtensionList));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void insertMCardExtensionList(int cardRowId, Connection con, List extensions) throws SQLException, CardException {
        block14: {
            if (extensions == null) return;
            if (extensions.size() == 0) {
                return;
            }
            query = "INSERT INTO MCardExtension (cardID_, element_, enabled_) VALUES (?, ?, ?)";
            ps = null;
            rs = null;
            try {
                ps = con.prepareStatement(query, 1);
                ps.setInt(1, cardRowId);
                i = 0;
                size = extensions.size();
                while (i < size) {
                    ext = (Extension)extensions.get(i);
                    ps.setString(2, ext.getExtensionData());
                    ps.setBoolean(3, ext.isEnabled());
                    ps.execute();
                    rs = ps.getGeneratedKeys();
                    if (rs.next() == false) throw new CardException("Prepared statement did not return primary key for inserted row.");
                    id = rs.getInt(1);
                    ext.setId((Object)new Integer(id));
                    ++i;
                }
            }
            catch (Throwable var11_10) {
                var10_11 = null;
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException e) {
                    MCardHelper.log.error((Object)e, (Throwable)e);
                }
                try {
                    if (ps == null) throw var11_10;
                    ps.close();
                    ps = null;
                    throw var11_10;
                }
                catch (SQLException e) {
                    MCardHelper.log.error((Object)e, (Throwable)e);
                }
                throw var11_10;
            }
            {
                var10_12 = null;
            }
            ** try [egrp 1[TRYBLOCK] [2 : 184->202)] { 
lbl46:
            // 1 sources

            if (rs != null) {
                rs.close();
                rs = null;
            }
            break block14;
lbl50:
            // 1 sources

            catch (SQLException e) {
                MCardHelper.log.error((Object)e, (Throwable)e);
            }
        }
        try {}
        catch (SQLException e) {
            MCardHelper.log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updateMCardExtensionList(Connection con, List extensions) throws SQLException {
        if (extensions == null) return;
        if (extensions.size() == 0) {
            return;
        }
        String query = "UPDATE MCardExtension SET element_ = ?, enabled_ = ? WHERE id_ = ?";
        Statement ps = null;
        try {
            int i = 0;
            int size = extensions.size();
            while (i < size) {
                Extension ext = (Extension)extensions.get(i);
                Integer id = (Integer)ext.getId();
                ps = con.prepareStatement(query);
                ps.setString(1, ext.getExtensionData());
                ps.setBoolean(2, ext.isEnabled());
                ps.setInt(3, id);
                ps.execute();
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void deleteMCardExtensionList(Connection con, List extensions) throws SQLException {
        if (extensions == null) return;
        if (extensions.size() == 0) {
            return;
        }
        String query = "DELETE FROM MCardExtension WHERE id_ = ?";
        Statement ps = null;
        try {
            int i = 0;
            int size = extensions.size();
            while (i < size) {
                Extension ext = (Extension)extensions.get(i);
                Integer id = (Integer)ext.getId();
                ps = con.prepareStatement(query);
                ps.setInt(1, id);
                ps.execute();
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    public static void deleteMCard(MCardEntity card, Connection con) throws SQLException, CardException {
        Integer id = (Integer)card.getId();
        if (id == null) {
            throw new CardException("Card entity contains no id.");
        }
        MCardHelper.deleteMCardRow(id, con);
        MCardHelper.deleteTokenService(id, con);
        MCardHelper.deleteExtensions(id, con);
        MCardHelper.deleteClaimTypes(id, con);
        MCardHelper.deleteTokenTypes(id, con);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void deleteMCardRow(int cardRowId, Connection con) throws SQLException {
        String query = "DELETE FROM ManagedCard WHERE id_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setInt(1, cardRowId);
            ps.execute();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void deleteTokenService(int cardRowId, Connection con) throws SQLException {
        String query = "DELETE FROM TokenService WHERE cardID_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setInt(1, cardRowId);
            ps.execute();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void deleteExtensions(int cardRowId, Connection con) throws SQLException {
        String query = "DELETE FROM MCardExtension WHERE cardID_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setInt(1, cardRowId);
            ps.execute();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void deleteTokenTypes(int cardRowId, Connection con) throws SQLException {
        String query = "DELETE FROM SupportedTokenType WHERE cardID_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setInt(1, cardRowId);
            ps.execute();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void deleteClaimTypes(int cardRowId, Connection con) throws SQLException {
        String query = "DELETE FROM SupportedClaimType WHERE cardID_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setInt(1, cardRowId);
            ps.execute();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }
}

