/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.entity.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.cache.CacheProviderFactory;
import org.eclipse.higgins.cache.api.ICache;
import org.eclipse.higgins.cache.api.ICacheKey;
import org.eclipse.higgins.cache.api.key.CacheKey;
import org.eclipse.higgins.configuration.api.IConfigurableComponent;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.IMCardManagedBean;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.IUserCredentials;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.MCardEntity;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.UsernamePasswordCredentials;
import org.eclipse.higgins.icard.provider.cardspace.entity.mysql.ConnectionFactory;
import org.eclipse.higgins.icard.provider.cardspace.entity.mysql.MCardHelper;

public class MCardManagedBean
implements IMCardManagedBean,
IConfigurableComponent {
    private static Log log;
    private boolean isConfigured = false;
    private static ICache cardCache;
    private static boolean isNoCache;
    private ConnectionFactory connectionFactory;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.icard.provider.cardspace.entity.mysql.MCardManagedBean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        cardCache = CacheProviderFactory.getCacheProvider().getCache("mcard.jdbc");
        isNoCache = true;
    }

    public synchronized void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, ISettingDescriptor componentDescriptor, ISettingDescriptor globalDescriptor) throws CardException {
        this.init(mapComponentSettings);
    }

    private void addCard(MCardEntity card, IUserCredentials credentials) throws CardException {
        CacheKey cacheKey = this.buildCacheKey(credentials);
        this.addCardToDB(card, credentials);
        this.addCardToCache(card, cacheKey);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addCardToDB(MCardEntity card, IUserCredentials credentials) throws CardException {
        String userId = this.buildUserId(credentials);
        Connection con = null;
        try {
            try {
                con = this.getConnection();
                MCardHelper.saveMCard(card, con, userId);
                if (!con.getAutoCommit()) {
                    con.commit();
                }
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                try {
                    con.rollback();
                    throw new CardException((Throwable)e);
                }
                catch (SQLException ex) {
                    log.error((Object)ex, (Throwable)ex);
                    throw new CardException((Throwable)ex);
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (con == null) throw throwable;
                con.close();
                con = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (con == null) return;
        con.close();
    }

    private void addCardToCache(MCardEntity card, CacheKey cacheKey) throws CardException {
        HashMap cacheCards;
        if (!isNoCache && (cacheCards = this.getMCardsFromCache(cacheKey)) != null) {
            cacheCards.put(card.getCardID().toString(), card);
        }
    }

    public void deleteMCard(String cardID, IUserCredentials credentials) throws CardException {
        if (cardID == null) {
            throw new CardException("Parameter \"cardID\" is null");
        }
        if (credentials == null) {
            throw new CardException("Parameter \"credentials\" is null");
        }
        MCardEntity card = this.getMCard(cardID, credentials);
        this.removeCardFromDB(card, credentials);
        this.removeCardFromCache(card, credentials);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeCardFromDB(MCardEntity card, IUserCredentials credentials) throws CardException {
        Connection con = null;
        try {
            try {
                con = this.getConnection();
                MCardHelper.deleteMCard(card, con);
                if (!con.getAutoCommit()) {
                    con.commit();
                }
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                try {
                    con.rollback();
                    throw new CardException((Throwable)e);
                }
                catch (SQLException ex) {
                    log.error((Object)ex, (Throwable)ex);
                    throw new CardException((Throwable)ex);
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (con == null) throw throwable;
                con.close();
                con = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (con == null) return;
        con.close();
    }

    private void removeCardFromCache(MCardEntity card, IUserCredentials credentials) throws CardException {
        if (!isNoCache) {
            CacheKey cacheKey = this.buildCacheKey(credentials);
            HashMap cacheCards = this.getMCardsFromCache(cacheKey);
            String cardId = card.getCardID().toString();
            if (cacheCards != null) {
                cacheCards.remove(cardId);
            }
        }
    }

    public MCardEntity getMCard(String cardID, IUserCredentials credentials) throws CardException {
        if (cardID == null) {
            throw new CardException("Parameter \"cardID\" is null");
        }
        if (credentials == null) {
            throw new CardException("Parameter \"credentials\" is null");
        }
        HashMap userCards = this.getCards(credentials);
        if (userCards.containsKey(cardID)) {
            return (MCardEntity)userCards.get(cardID);
        }
        return null;
    }

    public List getMCards(IUserCredentials credentials) throws CardException {
        if (credentials == null) {
            throw new CardException("Parameter \"credentials\" is null");
        }
        HashMap userCards = this.getCards(credentials);
        ArrayList<MCardEntity> res = new ArrayList<MCardEntity>();
        Iterator itr = userCards.values().iterator();
        while (itr.hasNext()) {
            MCardEntity mc = (MCardEntity)itr.next();
            res.add(mc);
        }
        return res;
    }

    private HashMap getCards(IUserCredentials credentials) throws CardException {
        CacheKey cacheKey = this.buildCacheKey(credentials);
        HashMap cards = this.getMCardsFromCache(cacheKey);
        if (cards == null) {
            String userId = this.buildUserId(credentials);
            cards = this.getMCardsFromDB(userId);
            if (!isNoCache) {
                cardCache.put((ICacheKey)cacheKey, (Object)cards);
            }
        }
        return cards;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateCard(MCardEntity card, IUserCredentials credentials) throws CardException {
        Connection con = null;
        try {
            try {
                con = this.getConnection();
                MCardHelper.updateMCard(card, con);
                if (!con.getAutoCommit()) {
                    con.commit();
                }
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                try {
                    con.rollback();
                    throw new CardException((Throwable)e);
                }
                catch (SQLException ex) {
                    log.error((Object)ex, (Throwable)ex);
                    throw new CardException((Throwable)ex);
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (con == null) throw throwable;
                con.close();
                con = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (con == null) return;
        con.close();
    }

    private HashMap getMCardsFromCache(CacheKey cacheKey) throws CardException {
        if (isNoCache) {
            if (!cardCache.isKeyInCache((ICacheKey)cacheKey)) {
                return null;
            }
            return (HashMap)cardCache.get((ICacheKey)cacheKey);
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private HashMap getMCardsFromDB(String userId) throws CardException {
        String query = "SELECT * FROM ManagedCard WHERE userID_ = ? ORDER BY id_";
        HashMap<String, MCardEntity> cards = new HashMap<String, MCardEntity>();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        con = this.getConnection();
        ps = con.prepareStatement(query);
        ps.setString(1, userId);
        rs = ps.executeQuery();
        while (rs.next()) {
            MCardEntity me = new MCardEntity();
            MCardHelper.initMCard(me, rs, con);
            cards.put(me.getCardID().toString(), me);
        }
        HashMap<String, MCardEntity> hashMap = cards;
        Object var8_10 = null;
        try {
            if (rs != null) {
                rs.close();
                rs = null;
            }
        }
        catch (SQLException e2) {
            log.error((Object)e2, (Throwable)e2);
        }
        try {
            if (ps != null) {
                ps.close();
                ps = null;
            }
        }
        catch (SQLException e2) {
            log.error((Object)e2, (Throwable)e2);
        }
        try {
            if (con != null && !con.isClosed()) {
                con.close();
                con = null;
            }
        }
        catch (SQLException e2) {
            log.error((Object)e2, (Throwable)e2);
        }
        return hashMap;
        catch (Exception e) {
            try {
                log.error((Object)e, (Throwable)e);
                throw new CardException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException e2) {
                    log.error((Object)e2, (Throwable)e2);
                }
                try {
                    if (ps != null) {
                        ps.close();
                        ps = null;
                    }
                }
                catch (SQLException e2) {
                    log.error((Object)e2, (Throwable)e2);
                }
                try {
                    if (con != null && !con.isClosed()) {
                        con.close();
                        con = null;
                    }
                }
                catch (SQLException e2) {
                    log.error((Object)e2, (Throwable)e2);
                }
                throw throwable;
            }
        }
    }

    protected Connection getConnection() throws CardException, SQLException {
        if (!this.isConfigured) {
            throw new CardException("Managed bean was not configured");
        }
        return this.connectionFactory.getConnection();
    }

    private String buildUserId(IUserCredentials credentials) throws CardException {
        if (credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials upc = (UsernamePasswordCredentials)credentials;
            String userName = upc.getUsername();
            if (userName == null) {
                throw new CardException("UsernamePasswordCredentials object contains null user name.");
            }
            return userName.trim();
        }
        throw new CardException();
    }

    private CacheKey buildCacheKey(IUserCredentials credentials) throws CardException {
        String cacheKey = null;
        if (credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials upc = (UsernamePasswordCredentials)credentials;
            String userName = upc.getUsername();
            cacheKey = userName.trim();
            return new CacheKey(cacheKey);
        }
        throw new CardException();
    }

    public void init(Map config) throws CardException {
        this.isConfigured = false;
        this.connectionFactory = ConnectionFactory.buildConnectionFactory(config);
        this.isConfigured = true;
    }

    public ISettingDescriptor getComponentDescriptor() {
        return null;
    }

    public void persistMCard(MCardEntity card, IUserCredentials credentials) throws CardException {
        if (card == null) {
            throw new CardException("Parameter \"card\" is null");
        }
        if (credentials == null) {
            throw new CardException("Parameter \"credentials\" is null");
        }
        if (card.getId() == null) {
            this.addCard(card, credentials);
        } else {
            this.updateCard(card, credentials);
        }
    }
}

