/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.entity.mysql;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.CardEntity;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.Extension;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.PCardEntity;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.SelfIssuedCardClaims;

public class PCardHelper {
    private static Log log;
    private static final long maxMySQLDate = 253402253999000L;
    private static final Hashtable claimTypeToClaimId;
    private static final Hashtable claimIdToClaimType;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.icard.provider.cardspace.entity.mysql.PCardHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        claimTypeToClaimId = SelfIssuedCardClaims.getSupportedTypesHash();
        claimIdToClaimType = new Hashtable();
        Enumeration keys = claimTypeToClaimId.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object val = claimTypeToClaimId.get(key);
            claimIdToClaimType.put(val, key);
        }
    }

    private static void initCard(CardEntity card, ResultSet rs, Connection con) throws SQLException, URISyntaxException {
        int rowId = rs.getInt("id_");
        card.setId((Object)new Integer(rowId));
        String cardID = rs.getString("cardID_");
        card.setCardID(new URI(cardID));
        card.setLanguage(rs.getString("language_"));
        card.setName(rs.getString("name_"));
        card.setVersion(rs.getInt("version_"));
        card.setIssuerID(rs.getBytes("issuerID_"));
        card.setImage(rs.getBytes("image_"));
        card.setImageType(rs.getString("imageType_"));
        card.setTimeIssued((java.util.Date)rs.getDate("timeIssued_"));
        card.setTimeExpires((java.util.Date)rs.getDate("timeExpires_"));
        card.setTimeLastUpdated((java.util.Date)rs.getDate("timeLastUpdated_"));
        card.setHashSalt(rs.getBytes("hashSalt_"));
        card.setMasterKey(rs.getBytes("masterKey_"));
    }

    public static void initPCard(PCardEntity card, ResultSet rs, Connection con) throws Exception {
        PCardHelper.initCard((CardEntity)card, rs, con);
        card.setPinDigest(rs.getBytes("pinDigest_"));
        int id = (Integer)card.getId();
        card.setSupportedClaimTypeList((List)SelfIssuedCardClaims.getSupportedClaimTypeList());
        card.setRawClaims((Map)PCardHelper.getPCardClaims(id, con));
        card.setExtensionList((List)PCardHelper.initPCardExtensionList(id, con));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static HashMap getPCardClaims(int cardRowId, Connection con) throws CardException, SQLException {
        block13: {
            valuesMap = new HashMap<String, String>();
            query = "SELECT * FROM PersonalCardClaim WHERE cardID_ = ?";
            ps = null;
            rs = null;
            try {
                ps = con.prepareStatement(query);
                ps.setInt(1, cardRowId);
                rs = ps.executeQuery();
                while (rs.next()) {
                    typeIndex = rs.getInt("claimTypeID_");
                    value = rs.getString("claimValue_");
                    id = String.valueOf(typeIndex);
                    if (PCardHelper.claimIdToClaimType.containsKey(id) == false) throw new CardException("Can not find claim type in dictionary by id = " + id);
                    type = (String)PCardHelper.claimIdToClaimType.get(id);
                    valuesMap.put(type, value);
                }
            }
            catch (Throwable var11_10) {
                var10_11 = null;
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException e) {
                    PCardHelper.log.error((Object)e, (Throwable)e);
                }
                try {
                    if (ps == null) throw var11_10;
                    ps.close();
                    ps = null;
                    throw var11_10;
                }
                catch (SQLException e) {
                    PCardHelper.log.error((Object)e, (Throwable)e);
                }
                throw var11_10;
            }
            {
                var10_12 = null;
            }
            ** try [egrp 1[TRYBLOCK] [2 : 164->182)] { 
lbl40:
            // 1 sources

            if (rs != null) {
                rs.close();
                rs = null;
            }
            break block13;
lbl44:
            // 1 sources

            catch (SQLException e) {
                PCardHelper.log.error((Object)e, (Throwable)e);
            }
        }
        try {}
        catch (SQLException e) {
            PCardHelper.log.error((Object)e, (Throwable)e);
            return valuesMap;
        }
        if (ps == null) return valuesMap;
        ps.close();
        ps = null;
        return valuesMap;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ArrayList initPCardExtensionList(int cardRowId, Connection con) throws SQLException {
        block13: {
            query = "SELECT * FROM PCardExtension WHERE cardID_ = ?";
            extensionList = new ArrayList<Extension>();
            ps = null;
            rs = null;
            try {
                ps = con.prepareStatement(query);
                ps.setInt(1, cardRowId);
                rs = ps.executeQuery();
                while (rs.next()) {
                    ext = new Extension();
                    ext.setId((Object)new Integer(rs.getInt("id_")));
                    ext.setExtensionData(rs.getString("element_"));
                    ext.setEnabled(rs.getBoolean("enabled_"));
                    extensionList.add(ext);
                }
            }
            catch (Throwable var8_7) {
                var7_8 = null;
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException e) {
                    PCardHelper.log.error((Object)e, (Throwable)e);
                }
                try {
                    if (ps == null) throw var8_7;
                    ps.close();
                    ps = null;
                    throw var8_7;
                }
                catch (SQLException e) {
                    PCardHelper.log.error((Object)e, (Throwable)e);
                }
                throw var8_7;
            }
            {
                var7_9 = null;
            }
            ** try [egrp 1[TRYBLOCK] [2 : 138->156)] { 
lbl39:
            // 1 sources

            if (rs != null) {
                rs.close();
                rs = null;
            }
            break block13;
lbl43:
            // 1 sources

            catch (SQLException e) {
                PCardHelper.log.error((Object)e, (Throwable)e);
            }
        }
        try {}
        catch (SQLException e) {
            PCardHelper.log.error((Object)e, (Throwable)e);
            return extensionList;
        }
        if (ps == null) return extensionList;
        ps.close();
        ps = null;
        return extensionList;
    }

    private static Date convertDate(java.util.Date date) {
        if (date == null) {
            return null;
        }
        if (date.getTime() > 253402253999000L) {
            return new Date(253402253999000L);
        }
        if (date instanceof Date) {
            return (Date)date;
        }
        return new Date(date.getTime());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addPCard(PCardEntity card, Connection con, String userId) throws CardException, SQLException {
        block16: {
            block15: {
                query = "INSERT INTO PersonalCard (cardID_, language_, name_, version_, image_, imageType_, timeIssued_, timeExpires_, timeLastUpdated_, hashSalt_, masterKey_, pinDigest_, userID_, issuerID_) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                ps = null;
                rs = null;
                id = null;
                try {
                    try {
                        ps = con.prepareStatement(query, 1);
                        ps.setString(1, card.getCardID().toString());
                        ps.setString(2, card.getLanguage());
                        ps.setString(3, card.getName());
                        ps.setInt(4, card.getVersion());
                        ps.setBytes(5, card.getImage());
                        ps.setString(6, card.getImageType());
                        ps.setDate(7, PCardHelper.convertDate(card.getTimeIssued()));
                        ps.setDate(8, PCardHelper.convertDate(card.getTimeExpires()));
                        ps.setDate(9, PCardHelper.convertDate(card.getTimeLastUpdated()));
                        ps.setBytes(10, card.getHashSalt());
                        ps.setBytes(11, card.getMasterKey());
                        ps.setBytes(12, card.getPinDigest());
                        ps.setString(13, userId);
                        ps.setBytes(14, card.getIssuerID());
                        ps.execute();
                        rs = ps.getGeneratedKeys();
                        if (rs.next() == false) throw new CardException("Prepared statement did not return primary key for inserted row.");
                        id = new Integer(rs.getInt(1));
                    }
                    catch (SQLException e) {
                        PCardHelper.log.error((Object)e, (Throwable)e);
                        throw new CardException((Throwable)e);
                    }
                }
                catch (Throwable var9_8) {
                    var8_9 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                    }
                    catch (SQLException e) {
                        PCardHelper.log.error((Object)e, (Throwable)e);
                    }
                    try {
                        if (ps == null) throw var9_8;
                        ps.close();
                        ps = null;
                        throw var9_8;
                    }
                    catch (SQLException e) {
                        PCardHelper.log.error((Object)e, (Throwable)e);
                    }
                    throw var9_8;
                }
                {
                    var8_10 = null;
                }
                ** try [egrp 2[TRYBLOCK] [3 : 301->319)] { 
lbl52:
                // 1 sources

                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                break block15;
lbl56:
                // 1 sources

                catch (SQLException e) {
                    PCardHelper.log.error((Object)e, (Throwable)e);
                }
            }
            ** try [egrp 3[TRYBLOCK] [4 : 333->351)] { 
lbl60:
            // 1 sources

            if (ps != null) {
                ps.close();
                ps = null;
            }
            break block16;
lbl64:
            // 1 sources

            catch (SQLException e) {
                PCardHelper.log.error((Object)e, (Throwable)e);
            }
        }
        PCardHelper.insertClaims(id, con, card.getRawClaims());
        PCardHelper.insertExtensions(id, con, card.getExtensionList());
        card.setId((Object)id);
    }

    private static boolean areStringsEqual(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        return !(s1 == null && s2 != null || s1 != null && s2 == null || !s1.equals(s2));
    }

    private static Extension getExtensionById(Object id, List extList) {
        if (id == null) {
            return null;
        }
        int i = 0;
        int s = extList.size();
        while (i < s) {
            Extension ext = (Extension)extList.get(i);
            if (id.equals(ext.getId())) {
                return ext;
            }
            ++i;
        }
        return null;
    }

    private static List getExtensionForInsert(List oldExt, List newExt) {
        if (newExt == null || newExt.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        if (oldExt == null || oldExt.size() == 0) {
            return newExt;
        }
        ArrayList<Extension> forInsert = new ArrayList<Extension>();
        int i = 0;
        while (i < newExt.size()) {
            Extension ext = (Extension)newExt.get(i);
            Object newId = ext.getId();
            if (newId == null || PCardHelper.getExtensionById(newId, oldExt) == null) {
                forInsert.add(ext);
            }
            ++i;
        }
        return forInsert;
    }

    private static List getExtensionForUpdate(List oldExtList, List newExtList) {
        if (newExtList == null || newExtList.size() == 0 || oldExtList == null || oldExtList.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Extension> forUpdate = new ArrayList<Extension>();
        int i = 0;
        while (i < newExtList.size()) {
            Extension newExt = (Extension)newExtList.get(i);
            Object newId = newExt.getId();
            if (newId != null) {
                Extension oldExt = PCardHelper.getExtensionById(newId, oldExtList);
                if (!PCardHelper.areStringsEqual(newExt.getExtensionData(), oldExt.getExtensionData()) || newExt.isEnabled() != oldExt.isEnabled()) {
                    forUpdate.add(newExt);
                }
            }
            ++i;
        }
        return forUpdate;
    }

    private static List getExtensionForDelete(List oldExtList, List newExtList) {
        if (oldExtList == null || oldExtList.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Extension> forDelete = new ArrayList<Extension>();
        int i = 0;
        while (i < oldExtList.size()) {
            Extension oldExt = (Extension)oldExtList.get(i);
            Object oldId = oldExt.getId();
            if (PCardHelper.getExtensionById(oldId, newExtList) != null) {
                forDelete.add(oldExt);
            }
            ++i;
        }
        return forDelete;
    }

    private static void updatePCardExtensions(PCardEntity card, Connection con) throws SQLException, CardException {
        Integer id = (Integer)card.getId();
        int cardRowId = id;
        ArrayList oldExtList = PCardHelper.initPCardExtensionList(cardRowId, con);
        List newExtensionList = card.getExtensionList();
        PCardHelper.insertExtensions(cardRowId, con, PCardHelper.getExtensionForInsert(oldExtList, newExtensionList));
        PCardHelper.updateExtensions(con, PCardHelper.getExtensionForUpdate(oldExtList, newExtensionList));
        PCardHelper.deleteExtensions(con, PCardHelper.getExtensionForDelete(oldExtList, newExtensionList));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void insertExtensions(int cardRowId, Connection con, List extensions) throws SQLException, CardException {
        block14: {
            if (extensions == null) return;
            if (extensions.size() == 0) {
                return;
            }
            query = "INSERT INTO PCardExtension (cardID_, element_, enabled_) VALUES (?, ?, ?)";
            ps = null;
            rs = null;
            try {
                ps = con.prepareStatement(query, 1);
                ps.setInt(1, cardRowId);
                i = 0;
                size = extensions.size();
                while (i < size) {
                    ext = (Extension)extensions.get(i);
                    ps.setString(2, ext.getExtensionData());
                    ps.setBoolean(3, ext.isEnabled());
                    ps.execute();
                    rs = ps.getGeneratedKeys();
                    if (rs.next() == false) throw new CardException("Prepared statement did not return primary key for inserted row.");
                    id = rs.getInt(1);
                    ext.setId((Object)new Integer(id));
                    ++i;
                }
            }
            catch (Throwable var11_10) {
                var10_11 = null;
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException e) {
                    PCardHelper.log.error((Object)e, (Throwable)e);
                }
                try {
                    if (ps == null) throw var11_10;
                    ps.close();
                    ps = null;
                    throw var11_10;
                }
                catch (SQLException e) {
                    PCardHelper.log.error((Object)e, (Throwable)e);
                }
                throw var11_10;
            }
            {
                var10_12 = null;
            }
            ** try [egrp 1[TRYBLOCK] [2 : 184->202)] { 
lbl46:
            // 1 sources

            if (rs != null) {
                rs.close();
                rs = null;
            }
            break block14;
lbl50:
            // 1 sources

            catch (SQLException e) {
                PCardHelper.log.error((Object)e, (Throwable)e);
            }
        }
        try {}
        catch (SQLException e) {
            PCardHelper.log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updateExtensions(Connection con, List extensions) throws SQLException {
        if (extensions == null) return;
        if (extensions.size() == 0) {
            return;
        }
        String query = "UPDATE PCardExtension SET element_ = ?, enabled_ = ? WHERE id_ = ?";
        Statement ps = null;
        try {
            int i = 0;
            int size = extensions.size();
            while (i < size) {
                Extension ext = (Extension)extensions.get(i);
                Integer id = (Integer)ext.getId();
                ps = con.prepareStatement(query);
                ps.setString(1, ext.getExtensionData());
                ps.setBoolean(2, ext.isEnabled());
                ps.setInt(3, id);
                ps.execute();
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void deleteExtensions(Connection con, List extensions) throws SQLException {
        if (extensions == null) return;
        if (extensions.size() == 0) {
            return;
        }
        String query = "DELETE FROM PCardExtension WHERE id_ = ?";
        Statement ps = null;
        try {
            int i = 0;
            int size = extensions.size();
            while (i < size) {
                Extension ext = (Extension)extensions.get(i);
                Integer id = (Integer)ext.getId();
                ps = con.prepareStatement(query);
                ps.setInt(1, id);
                ps.execute();
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    public static void updatePCard(PCardEntity card, Connection con) throws CardException, SQLException {
        PCardHelper.updatePCardCommonFields(card, con);
        PCardHelper.updatePCardExtensions(card, con);
        PCardHelper.updatePCardClaims(card, con);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updatePCardCommonFields(PCardEntity card, Connection con) throws CardException {
        block20: {
            id = (Integer)card.getId();
            lastUpdated = new java.util.Date();
            query = "SELECT name_, image_, imageType_, masterKey_, pinDigest_ FROM PersonalCard WHERE id_ = ?";
            ps = null;
            rs = null;
            try {
                try {
                    ps = con.prepareStatement(query);
                    ps.setInt(1, id);
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        oldCardName = rs.getString("name_");
                        oldImage = rs.getBytes("image_");
                        oldImageType = rs.getString("imageType_");
                        oldMasterKey = rs.getBytes("masterKey_");
                        oldPinDigest = rs.getBytes("pinDigest_");
                        newCardName = card.getName();
                        newImage = card.getImage();
                        newImageType = card.getImageType();
                        newMasterKey = card.getMasterKey();
                        newPinDigest = card.getPinDigest();
                        if (!PCardHelper.areStringsEqual(oldCardName, newCardName)) {
                            PCardHelper.updateName(id, con, newCardName, lastUpdated);
                        }
                        if (!Arrays.equals(oldImage, newImage)) {
                            PCardHelper.updateImage(id, con, newImage, lastUpdated);
                        }
                        if (!PCardHelper.areStringsEqual(oldImageType, newImageType)) {
                            PCardHelper.updateImageType(id, con, newImageType, lastUpdated);
                        }
                        if (!Arrays.equals(oldMasterKey, newMasterKey)) {
                            PCardHelper.updateMasterKey(id, con, newMasterKey, lastUpdated);
                        }
                        if (!Arrays.equals(oldPinDigest, newPinDigest)) {
                            PCardHelper.updatePinDigest(id, con, newPinDigest, lastUpdated);
                        }
                    }
                }
                catch (Exception e) {
                    PCardHelper.log.error((Object)e, (Throwable)e);
                    throw new CardException((Throwable)e);
                }
            }
            catch (Throwable var18_18) {
                var17_19 = null;
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException e) {
                    PCardHelper.log.error((Object)e, (Throwable)e);
                }
                try {
                    if (ps == null) throw var18_18;
                    ps.close();
                    ps = null;
                    throw var18_18;
                }
                catch (SQLException e) {
                    PCardHelper.log.error((Object)e, (Throwable)e);
                }
                throw var18_18;
            }
            {
                var17_20 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 295->313)] { 
lbl58:
            // 1 sources

            if (rs != null) {
                rs.close();
                rs = null;
            }
            break block20;
lbl62:
            // 1 sources

            catch (SQLException e) {
                PCardHelper.log.error((Object)e, (Throwable)e);
            }
        }
        try {}
        catch (SQLException e) {
            PCardHelper.log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updateMasterKey(int cardId, Connection con, byte[] newMasterKey, java.util.Date lastUpdated) throws SQLException {
        String query = "UPDATE PersonalCard SET masterKey_ = ?, timeLastUpdated_ = ? WHERE id_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setBytes(1, newMasterKey);
            ps.setDate(2, PCardHelper.convertDate(lastUpdated));
            ps.setInt(3, cardId);
            ps.execute();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updatePinDigest(int cardId, Connection con, byte[] newPinDigest, java.util.Date lastUpdated) throws SQLException {
        String query = "UPDATE PersonalCard SET pinDigest_ = ?, timeLastUpdated_ = ? WHERE id_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setBytes(1, newPinDigest);
            ps.setDate(2, PCardHelper.convertDate(lastUpdated));
            ps.setInt(3, cardId);
            ps.execute();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updateName(int cardId, Connection con, String newName, java.util.Date lastUpdated) throws SQLException {
        String query = "UPDATE PersonalCard SET name_ = ?, timeLastUpdated_ = ? WHERE id_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setString(1, newName);
            ps.setDate(2, PCardHelper.convertDate(lastUpdated));
            ps.setInt(3, cardId);
            ps.execute();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updateImage(int cardId, Connection con, byte[] newImage, java.util.Date lastUpdated) throws SQLException {
        String query = "UPDATE PersonalCard SET image_ = ?, timeLastUpdated_ = ? WHERE id_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setBytes(1, newImage);
            ps.setDate(2, PCardHelper.convertDate(lastUpdated));
            ps.setInt(3, cardId);
            ps.execute();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updateImageType(int cardId, Connection con, String newImageType, java.util.Date lastUpdated) throws SQLException {
        String query = "UPDATE PersonalCard SET imageType_ = ?, timeLastUpdated_ = ? WHERE id_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setString(1, newImageType);
            ps.setDate(2, PCardHelper.convertDate(lastUpdated));
            ps.setInt(3, cardId);
            ps.execute();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    private static Map getClaimsForInsert(Map oldClaims, Map newClaims) {
        if (newClaims == null || newClaims.size() == 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap forInsert = new HashMap();
        Iterator newClaimsItr = newClaims.keySet().iterator();
        while (newClaimsItr.hasNext()) {
            Object newClaimType = newClaimsItr.next();
            if (oldClaims.containsKey(newClaimType)) continue;
            Object newClaimValue = newClaims.get(newClaimType);
            forInsert.put(newClaimType, newClaimValue);
        }
        return forInsert;
    }

    private static Map getClaimsForUpdate(Map oldClaims, Map newClaims) {
        if (newClaims == null || newClaims.size() == 0 || oldClaims == null || oldClaims.size() == 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap forUpdate = new HashMap();
        Iterator newClaimsItr = newClaims.keySet().iterator();
        while (newClaimsItr.hasNext()) {
            String newClaimValue;
            String oldClaimValue;
            Object claimType = newClaimsItr.next();
            if (!oldClaims.containsKey(claimType) || PCardHelper.areStringsEqual(oldClaimValue = (String)oldClaims.get(claimType), newClaimValue = (String)newClaims.get(claimType))) continue;
            forUpdate.put(claimType, newClaimValue);
        }
        return forUpdate;
    }

    private static List getClaimsForDelete(Map oldClaims, Map newClaims) {
        if (oldClaims == null || oldClaims.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList forDelete = new ArrayList();
        Iterator oldClaimsItr = oldClaims.keySet().iterator();
        while (oldClaimsItr.hasNext()) {
            Object claimType = oldClaimsItr.next();
            if (newClaims.containsKey(claimType)) continue;
            forDelete.add(claimType);
        }
        return forDelete;
    }

    private static void updatePCardClaims(PCardEntity card, Connection con) throws SQLException, CardException {
        Integer id = (Integer)card.getId();
        int cardRowId = id;
        HashMap oldClaimsMap = PCardHelper.getPCardClaims(cardRowId, con);
        Map newClaimsMap = card.getRawClaims();
        PCardHelper.insertClaims(cardRowId, con, PCardHelper.getClaimsForInsert(oldClaimsMap, newClaimsMap));
        PCardHelper.updateClaims(cardRowId, con, PCardHelper.getClaimsForUpdate(oldClaimsMap, newClaimsMap));
        PCardHelper.deleteClaims(cardRowId, con, PCardHelper.getClaimsForDelete(oldClaimsMap, newClaimsMap));
    }

    private static String getClaimTypeId(String claimType) throws CardException {
        if (claimTypeToClaimId.containsKey(claimType)) {
            return (String)claimTypeToClaimId.get(claimType);
        }
        throw new CardException("No claim id ");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void insertClaims(int cardRowId, Connection con, Map newClaims) throws SQLException, CardException {
        if (newClaims == null) return;
        if (newClaims.size() == 0) {
            return;
        }
        String query = "INSERT INTO PersonalCardClaim (cardID_, claimTypeID_, claimValue_) VALUES (?, ?, ?)";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setInt(1, cardRowId);
            Iterator claimTypes = newClaims.keySet().iterator();
            while (claimTypes.hasNext()) {
                String claimType = (String)claimTypes.next();
                String claimTypeId = PCardHelper.getClaimTypeId(claimType);
                String value = (String)newClaims.get(claimType);
                ps.setString(2, claimTypeId);
                ps.setString(3, value);
                ps.execute();
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updateClaims(int cardRowId, Connection con, Map updateClaims) throws SQLException, CardException {
        if (updateClaims == null) return;
        if (updateClaims.size() == 0) {
            return;
        }
        String query = "UPDATE PersonalCardClaim SET claimValue_ = ? WHERE claimTypeID_ = ? AND cardID_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setInt(3, cardRowId);
            Iterator claimTypes = updateClaims.keySet().iterator();
            while (claimTypes.hasNext()) {
                String claimType = (String)claimTypes.next();
                String claimTypeId = PCardHelper.getClaimTypeId(claimType);
                String value = (String)updateClaims.get(claimType);
                ps.setString(2, claimTypeId);
                ps.setString(1, value);
                ps.execute();
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void deleteClaims(int cardRowId, Connection con, List deleteClaimTypes) throws SQLException, CardException {
        if (deleteClaimTypes == null) return;
        if (deleteClaimTypes.size() == 0) {
            return;
        }
        String query = "DELETE FROM PersonalCardClaim WHERE cardID_ = ? AND claimTypeID_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setInt(1, cardRowId);
            int i = 0;
            int size = deleteClaimTypes.size();
            while (i < size) {
                String claimType = (String)deleteClaimTypes.get(i);
                String claimTypeId = PCardHelper.getClaimTypeId(claimType);
                ps.setString(2, claimTypeId);
                ps.execute();
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    public static void deletePCard(PCardEntity card, Connection con) throws CardException, SQLException {
        Integer id = (Integer)card.getId();
        if (id == null) {
            throw new CardException("Card entity contains no id.");
        }
        PCardHelper.deletePCardRow(id, con);
        PCardHelper.deleteExtensions(id, con);
        PCardHelper.deleteClaimValues(id, con);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void deletePCardRow(int cardRowId, Connection con) throws SQLException {
        String query = "DELETE FROM PersonalCard WHERE id_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setInt(1, cardRowId);
            ps.execute();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void deleteExtensions(int cardRowId, Connection con) throws SQLException {
        String query = "DELETE FROM PCardExtension WHERE cardID_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setInt(1, cardRowId);
            ps.execute();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void deleteClaimValues(int cardId, Connection con) throws SQLException {
        String query = "DELETE FROM PersonalCardClaim WHERE cardId_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setInt(1, cardId);
            ps.execute();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (SQLException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }
}

