/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.entity.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.cache.CacheProviderFactory;
import org.eclipse.higgins.cache.api.ICache;
import org.eclipse.higgins.cache.api.ICacheKey;
import org.eclipse.higgins.cache.api.key.CacheKey;
import org.eclipse.higgins.configuration.api.IConfigurableComponent;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.IPCardManagedBean;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.IUserCredentials;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.PCardEntity;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.UsernamePasswordCredentials;
import org.eclipse.higgins.icard.provider.cardspace.entity.mysql.ConnectionFactory;
import org.eclipse.higgins.icard.provider.cardspace.entity.mysql.PCardHelper;

public class PCardManagedBean
implements IPCardManagedBean,
IConfigurableComponent {
    private Log log;
    private boolean isConfigured;
    private static ICache cardCache = CacheProviderFactory.getCacheProvider().getCache("pcard.jdbc");
    private static boolean isNoCache = true;
    private ConnectionFactory connectionFactory;
    static /* synthetic */ Class class$0;

    public PCardManagedBean() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.icard.provider.cardspace.entity.mysql.PCardManagedBean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
        this.isConfigured = false;
    }

    public synchronized void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, ISettingDescriptor componentDescriptor, ISettingDescriptor globalDescriptor) throws CardException {
        this.init(mapComponentSettings);
    }

    private void addCard(PCardEntity card, IUserCredentials credentials) throws CardException {
        CacheKey cacheKey = this.buildCacheKey(credentials);
        this.addCardToDB(card, credentials);
        this.addCardToCache(card, cacheKey);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addCardToDB(PCardEntity card, IUserCredentials credentials) throws CardException {
        String userId = this.buildUserId(credentials);
        Connection con = null;
        try {
            try {
                con = this.getConnection();
                PCardHelper.addPCard(card, con, userId);
                if (!con.getAutoCommit()) {
                    con.commit();
                }
            }
            catch (Exception e) {
                this.log.error((Object)e, (Throwable)e);
                try {
                    con.rollback();
                    throw new CardException((Throwable)e);
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex, (Throwable)ex);
                    throw new CardException((Throwable)ex);
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (con == null) throw throwable;
                con.close();
                con = null;
                throw throwable;
            }
            catch (SQLException e) {
                this.log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (SQLException e) {
            this.log.error((Object)e, (Throwable)e);
            return;
        }
        if (con == null) return;
        con.close();
    }

    private void addCardToCache(PCardEntity card, CacheKey cacheKey) throws CardException {
        HashMap cacheCards;
        if (!isNoCache && (cacheCards = this.getPCardsFromCache(cacheKey)) != null) {
            cacheCards.put(card.getCardID().toString(), card);
        }
    }

    public void deletePCard(String cardID, IUserCredentials credentials) throws CardException {
        if (cardID == null) {
            throw new CardException("Parameter \"cardID\" is null");
        }
        if (credentials == null) {
            throw new CardException("Parameter \"credentials\" is null");
        }
        PCardEntity card = this.getPCard(cardID, credentials);
        this.removeCardFromDB(card, credentials);
        this.removeCardFromCache(card, credentials);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeCardFromDB(PCardEntity card, IUserCredentials credentials) throws CardException {
        Connection con = null;
        try {
            try {
                con = this.getConnection();
                PCardHelper.deletePCard(card, con);
                if (!con.getAutoCommit()) {
                    con.commit();
                }
            }
            catch (Exception e) {
                this.log.error((Object)e, (Throwable)e);
                try {
                    con.rollback();
                    throw new CardException((Throwable)e);
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex, (Throwable)ex);
                    throw new CardException((Throwable)ex);
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (con == null) throw throwable;
                con.close();
                con = null;
                throw throwable;
            }
            catch (SQLException e) {
                this.log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (SQLException e) {
            this.log.error((Object)e, (Throwable)e);
            return;
        }
        if (con == null) return;
        con.close();
    }

    private void removeCardFromCache(PCardEntity card, IUserCredentials credentials) throws CardException {
        if (!isNoCache) {
            CacheKey cacheKey = this.buildCacheKey(credentials);
            HashMap cacheCards = this.getPCardsFromCache(cacheKey);
            String cardId = card.getCardID().toString();
            if (cacheCards != null && cacheCards.containsKey(cardId)) {
                cacheCards.remove(cardId);
            }
        }
    }

    public PCardEntity getPCard(String cardID, IUserCredentials credentials) throws CardException {
        if (cardID == null) {
            throw new CardException("Parameter \"cardID\" is null");
        }
        if (credentials == null) {
            throw new CardException("Parameter \"credentials\" is null");
        }
        HashMap userCards = this.getCards(credentials);
        if (userCards.containsKey(cardID)) {
            return (PCardEntity)userCards.get(cardID);
        }
        return null;
    }

    public List getPCards(IUserCredentials credentials) throws CardException {
        if (credentials == null) {
            throw new CardException("Parameter \"credentials\" is null");
        }
        HashMap userCards = this.getCards(credentials);
        ArrayList<PCardEntity> res = new ArrayList<PCardEntity>();
        Iterator itr = userCards.values().iterator();
        while (itr.hasNext()) {
            PCardEntity mc = (PCardEntity)itr.next();
            res.add(mc);
        }
        return res;
    }

    private HashMap getCards(IUserCredentials credentials) throws CardException {
        CacheKey cacheKey = this.buildCacheKey(credentials);
        HashMap cards = this.getPCardsFromCache(cacheKey);
        if (cards == null) {
            String userId = this.buildUserId(credentials);
            cards = this.getPCardsFromDB(userId);
            if (!isNoCache) {
                cardCache.put((ICacheKey)cacheKey, (Object)cards);
            }
        }
        return cards;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateCard(PCardEntity card, IUserCredentials credentials) throws CardException {
        Connection con = null;
        try {
            try {
                con = this.getConnection();
                PCardHelper.updatePCard(card, con);
                if (!con.getAutoCommit()) {
                    con.commit();
                }
            }
            catch (Exception e) {
                this.log.error((Object)e, (Throwable)e);
                try {
                    con.rollback();
                    throw new CardException((Throwable)e);
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex, (Throwable)ex);
                    throw new CardException((Throwable)ex);
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (con == null) throw throwable;
                con.close();
                con = null;
                throw throwable;
            }
            catch (SQLException e) {
                this.log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (SQLException e) {
            this.log.error((Object)e, (Throwable)e);
            return;
        }
        if (con == null) return;
        con.close();
    }

    private HashMap getPCardsFromCache(CacheKey cacheKey) throws CardException {
        if (isNoCache) {
            if (!cardCache.isKeyInCache((ICacheKey)cacheKey)) {
                return null;
            }
            return (HashMap)cardCache.get((ICacheKey)cacheKey);
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private HashMap getPCardsFromDB(String userId) throws CardException {
        String query = "SELECT * FROM PersonalCard WHERE userID_ = ? ORDER BY id_";
        HashMap<String, PCardEntity> cards = new HashMap<String, PCardEntity>();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        con = this.getConnection();
        ps = con.prepareStatement(query);
        ps.setString(1, userId);
        rs = ps.executeQuery();
        while (rs.next()) {
            PCardEntity me = new PCardEntity();
            PCardHelper.initPCard(me, rs, con);
            cards.put(me.getCardID().toString(), me);
        }
        HashMap<String, PCardEntity> hashMap = cards;
        Object var8_10 = null;
        try {
            if (rs != null) {
                rs.close();
                rs = null;
            }
        }
        catch (SQLException e2) {
            this.log.error((Object)e2, (Throwable)e2);
        }
        try {
            if (ps != null) {
                ps.close();
                ps = null;
            }
        }
        catch (SQLException e2) {
            this.log.error((Object)e2, (Throwable)e2);
        }
        try {
            if (con != null && !con.isClosed()) {
                con.close();
                con = null;
            }
        }
        catch (SQLException e2) {
            this.log.error((Object)e2, (Throwable)e2);
        }
        return hashMap;
        catch (Exception e) {
            try {
                this.log.error((Object)e, (Throwable)e);
                throw new CardException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException e2) {
                    this.log.error((Object)e2, (Throwable)e2);
                }
                try {
                    if (ps != null) {
                        ps.close();
                        ps = null;
                    }
                }
                catch (SQLException e2) {
                    this.log.error((Object)e2, (Throwable)e2);
                }
                try {
                    if (con != null && !con.isClosed()) {
                        con.close();
                        con = null;
                    }
                }
                catch (SQLException e2) {
                    this.log.error((Object)e2, (Throwable)e2);
                }
                throw throwable;
            }
        }
    }

    protected Connection getConnection() throws CardException, SQLException {
        if (!this.isConfigured) {
            throw new CardException("Managed bean was not configured");
        }
        return this.connectionFactory.getConnection();
    }

    private String buildUserId(IUserCredentials credentials) throws CardException {
        if (credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials upc = (UsernamePasswordCredentials)credentials;
            String userName = upc.getUsername();
            if (userName == null) {
                throw new CardException("UsernamePasswordCredentials object contains null user name.");
            }
            return userName.trim();
        }
        throw new CardException();
    }

    private CacheKey buildCacheKey(IUserCredentials credentials) throws CardException {
        String cacheKey = null;
        if (credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials upc = (UsernamePasswordCredentials)credentials;
            String userName = upc.getUsername();
            cacheKey = userName.trim();
            return new CacheKey(cacheKey);
        }
        throw new CardException();
    }

    public void init(Map config) throws CardException {
        this.isConfigured = false;
        this.connectionFactory = ConnectionFactory.buildConnectionFactory(config);
        this.isConfigured = true;
    }

    public ISettingDescriptor getComponentDescriptor() {
        return null;
    }

    public void persistPCard(PCardEntity card, IUserCredentials credentials) throws CardException {
        if (card == null) {
            throw new CardException("Parameter \"card\" is null");
        }
        if (credentials == null) {
            throw new CardException("Parameter \"credentials\" is null");
        }
        if (card.getId() == null) {
            this.addCard(card, credentials);
        } else {
            this.updateCard(card, credentials);
        }
    }
}

