CREATE TABLE ManagedCard (
	id_ INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
	cardID_ VARCHAR(255) NOT NULL,
	language_ VARCHAR(5),
	name_ VARCHAR(255),
	version_ INT,
	issuer_ VARCHAR(255),
	issuerName_ VARCHAR(255),
	issuerID_ TINYBLOB,
	image_ BLOB,
	imageType_ VARCHAR(50),
	timeIssued_ DATETIME,
	timeExpires_ DATETIME,
	timeLastUpdated_ DATETIME,
	hashSalt_ TINYBLOB,
	masterKey_ TINYBLOB,
	requireAppliesTo_ INTEGER(1),
	privacyNotice_ TEXT,
	userID_ VARCHAR(255) NOT NULL
);

CREATE INDEX index_ManagedCard_cardID ON ManagedCard (cardID_);
CREATE INDEX index_ManagedCard_userID ON ManagedCard (userID_);
CREATE UNIQUE INDEX index_ManagedCard_userID_cardID ON ManagedCard (userID_, cardID_);

CREATE TABLE PersonalCard (
	id_ INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
	cardID_ VARCHAR(255) NOT NULL,
	language_ VARCHAR(5),
	name_ VARCHAR(255),
	version_ INT,
	image_ BLOB,
	imageType_ VARCHAR(50),
	timeIssued_ DATETIME,
	timeExpires_ DATETIME,
	timeLastUpdated_ DATETIME,
	issuerID_ TINYBLOB,
	hashSalt_ TINYBLOB,
	masterKey_ TINYBLOB,
	pinDigest_ TINYBLOB,
	userID_ VARCHAR(255) NOT NULL
);

CREATE INDEX index_PersonalCard_cardID ON PersonalCard (cardID_);
CREATE INDEX index_PersonalCard_userID ON PersonalCard (userID_);
CREATE UNIQUE INDEX index_PersonalCard_userID_cardID ON PersonalCard (userID_, cardID_);

CREATE TABLE PersonalCardClaim (
	id_ INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
	cardID_ INT NOT NULL,
	claimTypeID_ INT NOT NULL,
	claimValue_ VARCHAR(255)
);
CREATE INDEX index_PersonalCardClaim_cardID ON PersonalCardClaim (cardID_);
CREATE UNIQUE INDEX index_PersonalCardClaim_claimTypeID ON PersonalCardClaim (cardID_, claimTypeID_);
CREATE TABLE ClaimType (
	id_ INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
	type_ VARCHAR(255) NOT NULL,
	typeLocalName_ VARCHAR(255),
	displayName_ VARCHAR(255),
	description_ VARCHAR(255)
);
CREATE INDEX index_ClaimType_type ON ClaimType (type_);
CREATE INDEX index_ClaimType_typeLocalName ON ClaimType (typeLocalName_);
CREATE INDEX index_ClaimType_displayName ON ClaimType (displayName_);
CREATE INDEX index_ClaimType_description ON ClaimType (description_);
CREATE TABLE TokenType (
	id_ INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
	type_ VARCHAR(255) NOT NULL UNIQUE
);
CREATE INDEX index_TokenType_type ON TokenType (type_);
INSERT INTO TokenType (type_) VALUES ('urn:oasis:names:tc:SAML:1.0:assertion');
INSERT INTO TokenType (type_) VALUES ('urn:oasis:names:tc:SAML:2.0:assertion');
INSERT INTO TokenType (type_) VALUES ('http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1.');
CREATE TABLE TokenService (
	id_ INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
	cardID_ INT NOT NULL,
	endpointAddress_ VARCHAR(255),
	hint_ VARCHAR(255),
	identity_ TEXT,
	credential_ TEXT,
	metadata_ TEXT
);
CREATE INDEX index_TokenService_cardID ON TokenService (cardID_);
CREATE TABLE SupportedTokenType (
	id_ INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
	cardID_ INT NOT NULL,
	tokenTypeID_ INT NOT NULL
);
CREATE INDEX index_SupportedTokenType_cardID ON SupportedTokenType (cardID_);
CREATE INDEX index_SupportedTokenType_tokenTypeID ON SupportedTokenType (tokenTypeID_);
CREATE TABLE SupportedClaimType (
	id_ INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
	cardID_ INT NOT NULL,
	claimTypeID_ INT NOT NULL
);
CREATE INDEX index_SupportedClaimType_cardID ON SupportedClaimType (cardID_);
CREATE INDEX index_SupportedClaimType_claimTypeID ON SupportedClaimType (claimTypeID_);
CREATE TABLE MCardExtension (
	id_ INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
	cardID_ INT NOT NULL,
	element_ TEXT,
	enabled_ BIT(1)
);
CREATE INDEX index_MCardExtension_cardID ON MCardExtension (cardID_);
CREATE TABLE PCardExtension (
	id_ INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
	cardID_ INT NOT NULL,
	element_ TEXT,
	enabled_ BIT(1)
);
CREATE INDEX index_PCardExtension_cardID ON PCardExtension (cardID_);
