/**
 * Copyright (c) 2009 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */
package org.eclipse.higgins.icard.provider.cardspace.entity.mysql;

import java.net.URI;

/**
 * Contains URIs of higgins schema for CardSpace-interoperable I-Card
 */
public class IdASContext {

	public static final String ICARD_NS = "http://www.eclipse.org/higgins/ontologies/2009/4/i-card.owl#";

	public static final URI ICARD_ICard = URI.create(ICARD_NS + "I-Card");
	public static final URI ICARD_UsernamePasswordCredential = URI.create(ICARD_NS + "UsernamePasswordCredential");
	public static final URI ICARD_TokenService = URI.create(ICARD_NS + "TokenService");
	public static final URI ICARD_IssuerInformationEntry = URI.create(ICARD_NS + "IssuerInformationEntry");
	public static final URI ICARD_UserCredential = URI.create(ICARD_NS + "UserCredential");
	public static final URI ICARD_EndpointReference = URI.create(ICARD_NS + "EndpointReference");
	public static final URI ICARD_STSPrivacyPolicy = URI.create(ICARD_NS + "STSPrivacyPolicy");
	public static final URI ICARD_CredentialDescriptor = URI.create(ICARD_NS + "CredentialDescriptor");
	public static final URI ICARD_PCard = URI.create(ICARD_NS + "P-Card");
	public static final URI ICARD_X509V3Credential = URI.create(ICARD_NS + "X509V3Credential");
	public static final URI ICARD_SelfIssuedCredential = URI.create(ICARD_NS + "SelfIssuedCredential");
	public static final URI ICARD_KerberosV5Credential = URI.create(ICARD_NS + "KerberosV5Credential");
	public static final URI ICARD_MCard = URI.create(ICARD_NS + "M-Card");
	public static final URI ICARD_Extension = URI.create(ICARD_NS + "Extension");
	public static final URI ICARD_ClaimType = URI.create(ICARD_NS + "ClaimType");
	
		

	public static final URI ICARD_ic07IssuerInformation = URI.create(ICARD_NS + "ic07IssuerInformation");
	public static final URI ICARD_userCredential = URI.create(ICARD_NS + "userCredential");
	public static final URI ICARD_supportedClaimType = URI.create(ICARD_NS + "supportedClaimType");
	public static final URI ICARD_tokenService = URI.create(ICARD_NS + "tokenService");
	public static final URI ICARD_stsPrivacyPolicy = URI.create(ICARD_NS + "stsPrivacyPolicy");
	public static final URI ICARD_endpointReference = URI.create(ICARD_NS + "endpointReference");
	public static final URI ICARD_resource_udi = URI.create(ICARD_NS + "resource-udi");
	public static final URI ICARD_claimTypeName = URI.create(ICARD_NS + "claimTypeName");
	public static final URI ICARD_langId = URI.create(ICARD_NS + "langId");
	public static final URI ICARD_timeExpired = URI.create(ICARD_NS + "timeExpired");
	public static final URI ICARD_masterKey = URI.create(ICARD_NS + "masterKey");
	public static final URI ICARD_issuerId = URI.create(ICARD_NS + "issuerId");
	public static final URI ICARD_certificate = URI.create(ICARD_NS + "certificate");
	public static final URI ICARD_username = URI.create(ICARD_NS + "username");
	public static final URI ICARD_timeIssued = URI.create(ICARD_NS + "timeIssued");
	public static final URI ICARD_isSelfIssued = URI.create(ICARD_NS + "isSelfIssued");
	public static final URI ICARD_displayCredentialHint = URI.create(ICARD_NS + "displayCredentialHint");
	public static final URI ICARD_supportedTokenType = URI.create(ICARD_NS + "supportedTokenType");
	public static final URI ICARD_issuerName = URI.create(ICARD_NS + "issuerName");
	public static final URI ICARD_imageType = URI.create(ICARD_NS + "imageType");
	public static final URI ICARD_image = URI.create(ICARD_NS + "image");
	public static final URI ICARD_pinDigest = URI.create(ICARD_NS + "pinDigest");
	public static final URI ICARD_cardId = URI.create(ICARD_NS + "cardId");
	public static final URI ICARD_claimURI = URI.create(ICARD_NS + "claimURI");
	public static final URI ICARD_policyVersion = URI.create(ICARD_NS + "policyVersion");
	public static final URI ICARD_entryName = URI.create(ICARD_NS + "entryName");
	public static final URI ICARD_hashSalt = URI.create(ICARD_NS + "hashSalt");
	public static final URI ICARD_extension = URI.create(ICARD_NS + "extension");
	public static final URI ICARD_requireAppliesTo = URI.create(ICARD_NS + "requireAppliesTo");
	public static final URI ICARD_cardVersion = URI.create(ICARD_NS + "cardVersion");
	public static final URI ICARD_metadataAddress = URI.create(ICARD_NS + "metadataAddress");
	public static final URI ICARD_backgroundColor = URI.create(ICARD_NS + "backgroundColor");
	public static final URI ICARD_issuer = URI.create(ICARD_NS + "issuer");
	public static final URI ICARD_cardName = URI.create(ICARD_NS + "cardName");
	public static final URI ICARD_address = URI.create(ICARD_NS + "address");
	public static final URI ICARD_policyURL = URI.create(ICARD_NS + "policyURL");
	public static final URI ICARD_claimTypeDescription = URI.create(ICARD_NS + "claimTypeDescription");
	public static final URI ICARD_entryValue = URI.create(ICARD_NS + "entryValue");
	public static final URI ICARD_privatePersonalIdentifier = URI.create(ICARD_NS + "privatePersonalIdentifier");
	public static final URI ICARD_requireStrongRecipientIdentity = URI.create(ICARD_NS + "requireStrongRecipientIdentity");
	public static final URI ICARD_timeLastUpdated = URI.create(ICARD_NS + "timeLastUpdated");
	public static final URI ICARD_x509Data = URI.create(ICARD_NS + "x509Data");

	public static final URI ICARD_extensionData = URI.create(ICARD_NS + "extensionData");
	public static final URI ICARD_extensionEnabled = URI.create(ICARD_NS + "extensionEnabled");

	public static final URI ICARD_claimValuesList = URI.create(ICARD_NS + "claimValuesList");
	public static final URI ICARD_PCardClaims = URI.create(ICARD_NS + "P-CardClaims");

	
}


