/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.icard.provider.cardspace.managed.xml;

import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.AuthenticationException;
import org.eclipse.higgins.icard.AuthenticationRequiredException;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.InvalidClaimException;
import org.eclipse.higgins.icard.InvalidStateException;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.ReadOnlyObjectException;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.IPinCodeCredential;
import org.eclipse.higgins.icard.provider.cardspace.common.PersonalCard;
import org.w3c.dom.Element;

/**
 * Implementation of managed CardSpace-interoperable ICard stored in xml file
 */
public class XMLBasedPersonalCard extends PersonalCard {
	private Log log = LogFactory.getLog(XMLBasedPersonalCard.class);

	protected String user_ = null;

	protected String password_ = null;

	protected boolean editMode = false;
	/**
	 * @param provider
	 * @param card
	 * @throws CardException
	 */
	public XMLBasedPersonalCard(XMLBasedManagedCardProvider provider, Element card, String user, String password) throws CardException {
		description_ = "XML-based CardSpace-interoperable personal I-Card";
		if (provider == null)
			throw new CardException("Parameter \"provider\" is null");
		provider_ = provider;
		if (card == null)
			throw new CardException("Parameter \"card\" is null");
		if (user == null)
			throw new CardException("Parameter \"user\" is null");
		if (password == null)
			throw new CardException("Parameter \"password\" is null");
		user_ = user;
		password_ = password;
		try {
			initFromXML(card);
		} catch (Exception e) {
			log.error(e);
			throw new CardException(e.getMessage());
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.ICard#setImage(byte[], java.lang.String)
	 */
	public void setImage(byte[] newImage, String newImageType) throws CardException {
		if (newImage == null)
			throw new CardException("Parameter \"newImage\" is null.");
		if (newImageType == null)
			throw new CardException("Parameter \"newImageType\" is null.");
		image_ = newImage;
		imageMimeType_ = newImageType;
		((XMLBasedManagedCardProvider)provider_).updateCard(this);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.ICard#setName(java.lang.String)
	 */
	public void setName(String newName) throws CardException {
		if (newName == null || newName.trim().length() == 0)
			throw new CardException("Parameter \"newName\" is empty string.");
		name_ = newName.trim();
		((XMLBasedManagedCardProvider)provider_).updateCard(this);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.ICard#setExpiredTime(java.util.Date)
	 */
	public void setTimeExpires(Date date) throws CardException {
		timeExpires_ = date;
		((XMLBasedManagedCardProvider)provider_).updateCard(this);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.ICard#setIssuerName(java.lang.String)
	 */
	public void setIssuerName(String name) throws CardException {
		issuerName_ = name;
		((XMLBasedManagedCardProvider)provider_).updateCard(this);
	}

	public IClaim createClaim(String type) throws InvalidTypeException, ReadOnlyObjectException {
		throw new ReadOnlyObjectException();
	}

	public IClaim setClaim(IClaim copyFrom) throws InvalidClaimException, InvalidTypeException, ReadOnlyObjectException {
		throw new ReadOnlyObjectException();
	}

	public void applyUpdates() throws InvalidStateException, CardException {
		// TODO Auto-generated method stub
		
	}

	public void beginUpdates() throws InvalidStateException {
		if (editMode) {
			throw new InvalidStateException();
		} else {
			editMode = true;
		}
	}

	public void cancelUpdates() throws InvalidStateException {
		if (!editMode) {
			throw new InvalidStateException();
		} else {
			
		}
	}

	public boolean isEditMode() {
		return editMode;
	}

	public boolean isEditable() {
		return false;
	}

	public void setPinCode(IPinCodeCredential pinCodeCredential) throws CardException {
		throw new CardException("Not implemented.");
	}

	protected void retrieveClaims(ICredential credential) throws AuthenticationRequiredException, AuthenticationException, CardException {
		// TODO Auto-generated method stub
		
	}

}
